/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

final class TerracottaFile {
    private ArrayList<BufferWrapper> buffers = new ArrayList();
    long length;
    private long lastModified = System.currentTimeMillis();
    private ReentrantLock lock = new ReentrantLock();

    TerracottaFile() {
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    long getLength() {
        return this.length;
    }

    void setLength(long length) {
        this.length = length;
    }

    synchronized long getLastModified() {
        return this.lastModified;
    }

    synchronized void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    final byte[] addBuffer(int size) {
        BufferWrapper buffer = new BufferWrapper(new byte[size]);
        this.buffers.add(buffer);
        return buffer.buffer.buffer;
    }

    final void addBuffers(byte[] ... newBuffers) {
        for (byte[] buffer : newBuffers) {
            this.buffers.add(new BufferWrapper(buffer));
        }
    }

    final void setFirstBuffer(byte[] buffer) {
        this.buffers.get((int)0).buffer.buffer = buffer;
    }

    final byte[] getBuffer(int index) {
        return this.buffers.get((int)index).buffer.buffer;
    }

    final int getNumBuffers() {
        return this.buffers.size();
    }

    public static class Buffer {
        public byte[] buffer;

        private Buffer(byte[] buffer) {
            this.buffer = buffer;
        }
    }

    public static class BufferWrapper {
        public final Buffer buffer;

        private BufferWrapper(byte[] buffer) {
            this.buffer = new Buffer(buffer);
        }

        public byte[] getBuffer() {
            return this.buffer.buffer;
        }
    }
}

