/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.lifecycle;

import java.io.Serializable;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.mapping.Cascade;
import org.compass.gps.device.hibernate.HibernateGpsDevice;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.lifecycle.HibernateEventListener;
import org.compass.gps.spi.CompassGpsInterfaceDevice;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;

public class HibernateCollectionEventListener
extends HibernateEventListener
implements PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener {
    public HibernateCollectionEventListener(HibernateGpsDevice device, boolean marshallIds, boolean pendingCascades, boolean processCollections) {
        super(device, marshallIds, pendingCascades, processCollections);
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent postCollectionRecreateEvent) {
        this.processCollectionEvent((AbstractCollectionEvent)postCollectionRecreateEvent);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent postCollectionRemoveEvent) {
        this.processCollectionEvent((AbstractCollectionEvent)postCollectionRemoveEvent);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent postCollectionUpdateEvent) {
        this.processCollectionEvent((AbstractCollectionEvent)postCollectionUpdateEvent);
    }

    private void processCollectionEvent(final AbstractCollectionEvent event) {
        final Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        CollectionEntry collectionEntry = event.getSession().getPersistenceContext().getCollectionEntry(event.getCollection());
        if (collectionEntry != null && collectionEntry.getLoadedPersister() == null) {
            return;
        }
        if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterCollection(event)) {
            return;
        }
        final CompassGpsInterfaceDevice compassGps = (CompassGpsInterfaceDevice)this.device.getGps();
        if (!compassGps.hasMappingForEntityForMirror(entity.getClass(), Cascade.SAVE)) {
            return;
        }
        Serializable id = this.getId(entity, event);
        if (id == null) {
            this.log.warn((Object)("Unable to reindex entity on collection change, id cannot be extracted: " + event.getAffectedOwnerEntityName()));
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)this.device.buildMessage("Updating [" + entity + "]"));
            }
            compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    HibernateCollectionEventListener.this.doUpdate(session, compassGps, entity, event.getSession());
                }
            });
        }
        catch (Exception e) {
            if (this.device.isIgnoreMirrorExceptions()) {
                this.log.error((Object)this.device.buildMessage("Failed while updating [" + entity + "]"), (Throwable)e);
            }
            throw new HibernateGpsDeviceException(this.device.buildMessage("Failed while updating [" + entity + "]"), e);
        }
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }
}

