/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.jdom.converter;

import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.xsem.SupportsXmlContentWrapper;
import org.compass.core.xml.AliasedXmlObject;
import org.compass.core.xml.jdom.JDomAliasedXmlObject;
import org.compass.core.xml.jdom.converter.AbstractXmlOutputterXmlContentConverter;
import org.compass.core.xml.jdom.converter.support.StAXBuilder;
import org.jdom.Document;

public class STAXBuilderXmlContentConverter
extends AbstractXmlOutputterXmlContentConverter
implements SupportsXmlContentWrapper,
CompassConfigurable {
    private StAXBuilder stAXBuilder;
    XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public void configure(CompassSettings settings) throws CompassException {
        super.configure(settings);
        this.stAXBuilder = this.doCreateStAXBuilder(settings);
    }

    protected StAXBuilder doCreateStAXBuilder(CompassSettings settings) {
        return new StAXBuilder();
    }

    public boolean supports(String wrapper) {
        return !"singleton".equals(wrapper);
    }

    public AliasedXmlObject fromXml(String alias, Reader xml) throws ConversionException {
        Document doc;
        try {
            XMLStreamReader sr = this.xmlInputFactory.createXMLStreamReader(xml);
            doc = this.stAXBuilder.build(sr);
            sr.close();
        }
        catch (Exception e) {
            throw new ConversionException("Failed to parse alias[" + alias + "] xml[" + xml + "]", e);
        }
        return new JDomAliasedXmlObject(alias, doc.getRootElement());
    }
}

