/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TimedBlockingPolicy
implements RejectedExecutionHandler {
    private final long waitTime;

    public TimedBlockingPolicy(long waitTime) {
        this.waitTime = waitTime;
    }

    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        try {
            boolean successful = executor.getQueue().offer(r, this.waitTime, TimeUnit.MILLISECONDS);
            if (!successful) {
                throw new RejectedExecutionException("Rejected execution after waiting " + this.waitTime + " ms for task [" + r.getClass() + "] to be executed.");
            }
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException(e);
        }
    }
}

