/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.spi;

import java.io.Serializable;
import org.compass.core.CompassException;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.engine.utils.ResourceHelper;
import org.compass.core.mapping.ResourceMapping;

public final class ResourceKey
implements Serializable {
    private static final char SEPARATOR = '#';
    private String alias;
    private String subIndex;
    private Property[] ids;
    private transient int hashCode = Integer.MIN_VALUE;
    private transient ResourceMapping resourceMapping;

    public ResourceKey(ResourceMapping resourceMapping, Resource idResource) {
        this(resourceMapping, ResourceHelper.toIds(idResource, resourceMapping));
    }

    public ResourceKey(ResourceMapping resourceMapping, Property[] ids) {
        this.resourceMapping = resourceMapping;
        this.ids = ids;
        this.alias = resourceMapping.getAlias();
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSubIndex() {
        if (this.subIndex == null) {
            SubIndexHash subIndexHash = this.getResourceMapping().getSubIndexHash();
            this.subIndex = subIndexHash.mapSubIndex(this.getAlias(), this.getIds());
        }
        return this.subIndex;
    }

    public Property[] getIds() {
        return this.ids;
    }

    public String buildUID() throws CompassException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAlias()).append('#');
        for (Property idProp : this.getIds()) {
            String idValue = idProp.getStringValue();
            if (idValue == null) {
                throw new CompassException("Missing id [" + idProp.getName() + "] for alias [" + this.getAlias() + "]");
            }
            sb.append(idValue);
            sb.append('#');
        }
        return sb.toString();
    }

    public String getUIDPath() {
        return this.resourceMapping.getUIDPath();
    }

    public ResourceMapping getResourceMapping() {
        return this.resourceMapping;
    }

    public void attach(SearchEngineFactory searchEngineFactory) {
        this.resourceMapping = searchEngineFactory.getMapping().getRootMappingByAlias(this.getAlias());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        ResourceKey key = (ResourceKey)other;
        if (!key.alias.equals(this.alias)) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (key.ids[i].getStringValue().equals(this.ids[i].getStringValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.alias.hashCode();
        for (Property id : this.ids) {
            result = 29 * result + id.getStringValue().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("alias [").append(this.getAlias()).append("]");
        sb.append(" uid [").append(this.buildUID()).append("]");
        return sb.toString();
    }
}

