/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.readcommitted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.DefaultLuceneSearchEngineHits;
import org.compass.core.lucene.engine.EmptyLuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;
import org.compass.core.lucene.engine.transaction.readcommitted.BitSetByAliasFilter;
import org.compass.core.lucene.engine.transaction.readcommitted.TransIndexManager;
import org.compass.core.lucene.engine.transaction.support.AbstractConcurrentTransactionProcessor;
import org.compass.core.lucene.engine.transaction.support.job.DeleteByQueryTransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.DeleteTransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.FlushCommitTransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.UpdateTransactionJob;
import org.compass.core.lucene.support.ChainedFilter;
import org.compass.core.spi.ResourceKey;
import org.compass.core.transaction.context.TransactionalCallable;

public class ReadCommittedTransactionProcessor
extends AbstractConcurrentTransactionProcessor {
    private static final Log logger = LogFactory.getLog(ReadCommittedTransactionProcessor.class);
    private final TransIndexManager transIndexManager;
    private final Map<String, IndexWriter> indexWriterBySubIndex;
    private final BitSetByAliasFilter filter;
    private final Map<String, LuceneIndexHolder> indexHoldersBySubIndex;

    public ReadCommittedTransactionProcessor(LuceneSearchEngine searchEngine) {
        super(logger, searchEngine, true, searchEngine.getSearchEngineFactory().getIndexManager().supportsConcurrentOperations());
        if (this.isConcurrentOperations()) {
            this.indexWriterBySubIndex = new ConcurrentHashMap<String, IndexWriter>();
            this.indexHoldersBySubIndex = new ConcurrentHashMap<String, LuceneIndexHolder>();
        } else {
            this.indexWriterBySubIndex = new HashMap<String, IndexWriter>();
            this.indexHoldersBySubIndex = new HashMap<String, LuceneIndexHolder>();
        }
        this.filter = new BitSetByAliasFilter(this.isConcurrentOperations());
        this.transIndexManager = new TransIndexManager(searchEngine.getSearchEngineFactory(), this.isConcurrentOperations());
        this.transIndexManager.configure(searchEngine.getSettings());
    }

    public String getName() {
        return "read_committed";
    }

    protected String[] getDirtySubIndexes() {
        return this.indexWriterBySubIndex.keySet().toArray(new String[this.indexWriterBySubIndex.keySet().size()]);
    }

    public void begin() throws SearchEngineException {
        this.filter.clear();
    }

    protected void doPrepare() throws SearchEngineException {
        this.releaseHolders();
        if (this.indexManager.supportsConcurrentCommits()) {
            ArrayList prepareCallables = new ArrayList();
            for (String subIndex : this.indexWriterBySubIndex.keySet()) {
                if (!this.transIndexManager.hasTransIndex(subIndex)) continue;
                prepareCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new PrepareCallable(subIndex)));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(prepareCallables, 1);
        } else {
            for (String subIndex : this.indexWriterBySubIndex.keySet()) {
                if (!this.transIndexManager.hasTransIndex(subIndex)) continue;
                try {
                    new PrepareCallable(subIndex).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to prepare transaction for sub index [" + subIndex + "]", e);
                }
            }
        }
    }

    protected void doCommit(boolean onePhase) throws SearchEngineException {
        this.releaseHolders();
        if (onePhase) {
            this.prepare();
        }
        if (this.indexManager.supportsConcurrentCommits()) {
            ArrayList commitCallables = new ArrayList();
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                commitCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new CommitCallable(entry.getKey(), entry.getValue(), false)));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(commitCallables, 1);
        } else {
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                try {
                    new CommitCallable(entry.getKey(), entry.getValue(), false).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to commit transaction for sub index [" + entry.getKey() + "]", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRollback() throws SearchEngineException {
        this.releaseHolders();
        SearchEngineException lastException = null;
        for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
            try {
                if (this.transIndexManager.hasTransIndex(entry.getKey())) {
                    this.transIndexManager.rollback(entry.getKey());
                    this.transIndexManager.close(entry.getKey());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                entry.getValue().rollback();
            }
            catch (AlreadyClosedException e) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Failed to abort transaction for sub index [" + entry.getKey() + "] since it is alreayd closed"));
            }
            catch (IOException e) {
                Directory dir = this.indexManager.getStore().openDirectory(entry.getKey());
                try {
                    if (IndexWriter.isLocked((Directory)dir)) {
                        IndexWriter.unlock((Directory)dir);
                    }
                }
                catch (Exception e1) {
                    logger.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + entry.getKey() + "]"), (Throwable)e);
                }
                lastException = new SearchEngineException("Failed to rollback sub index [" + entry.getKey() + "]", e);
            }
            finally {
                this.indexManager.getIndexWritersManager().trackCloseIndexWriter(entry.getKey(), entry.getValue());
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    protected LuceneSearchEngineInternalSearch doInternalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        if (this.indexHoldersBySubIndex.isEmpty() && !this.transIndexManager.hasTransactions()) {
            return super.buildInternalSearch(subIndexes, aliases, true);
        }
        ArrayList<LuceneIndexHolder> indexHoldersToClose = new ArrayList<LuceneIndexHolder>();
        try {
            String[] calcSubIndexes = this.indexManager.getStore().calcSubIndexes(subIndexes, aliases);
            ArrayList<IndexSearcher> searchers = new ArrayList<IndexSearcher>();
            for (String subIndex : calcSubIndexes) {
                LuceneIndexHolder indexHolder = this.indexHoldersBySubIndex.get(subIndex);
                if (indexHolder == null) {
                    indexHolder = this.indexManager.getIndexHoldersCache().getHolder(subIndex);
                    indexHoldersToClose.add(indexHolder);
                }
                if (indexHolder.getIndexReader().numDocs() > 0) {
                    searchers.add(indexHolder.getIndexSearcher());
                }
                if (!this.transIndexManager.hasTransIndex(subIndex)) continue;
                searchers.add(this.transIndexManager.getSearcher(subIndex));
            }
            if (searchers.size() == 0) {
                return new LuceneSearchEngineInternalSearch(this.searchEngine, indexHoldersToClose);
            }
            MultiSearcher indexSeracher = this.indexManager.openMultiSearcher((Searchable[])searchers.toArray(new Searcher[searchers.size()]));
            return new LuceneSearchEngineInternalSearch(this.searchEngine, indexSeracher, indexHoldersToClose);
        }
        catch (IOException e) {
            for (LuceneIndexHolder indexHolder : indexHoldersToClose) {
                indexHolder.release();
            }
            throw new SearchEngineException("Failed to open Lucene reader/searcher", e);
        }
    }

    protected LuceneSearchEngineHits doFind(LuceneSearchEngineQuery query) throws SearchEngineException {
        LuceneSearchEngineInternalSearch internalSearch = this.internalSearch(query.getSubIndexes(), query.getAliases());
        if (internalSearch.isEmpty()) {
            return new EmptyLuceneSearchEngineHits(this.searchEngine, internalSearch);
        }
        Filter qFilter = null;
        if (this.filter.hasDeletes()) {
            qFilter = query.getFilter() == null ? this.filter : new ChainedFilter(new Filter[]{this.filter, query.getFilter().getFilter()}, 1);
        } else if (query.getFilter() != null) {
            qFilter = query.getFilter().getFilter();
        }
        Hits hits = this.findByQuery(internalSearch, query, qFilter);
        return new DefaultLuceneSearchEngineHits(hits, this.searchEngine, query, internalSearch);
    }

    /*
     * Exception decompiling
     */
    protected Resource[] doGet(ResourceKey resourceKey) throws SearchEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doProcessJob(TransactionJob job) throws SearchEngineException {
        try {
            IndexWriter indexWriter = this.openIndexWriterIfNeeded(job.getSubIndex());
            if (job instanceof DeleteTransactionJob) {
                DeleteTransactionJob deleteJob = (DeleteTransactionJob)job;
                this.markDeleted(deleteJob.getResourceKey());
                job.execute(indexWriter, this.searchEngineFactory);
                this.transIndexManager.processJob(job);
            } else if (job instanceof DeleteByQueryTransactionJob) {
                job.execute(indexWriter, this.searchEngineFactory);
                this.transIndexManager.processJob(job);
            } else if (job instanceof UpdateTransactionJob) {
                UpdateTransactionJob updateJob = (UpdateTransactionJob)job;
                Term deleteTerm = this.markDeleted(updateJob.getResource().getResourceKey());
                indexWriter.deleteDocuments(deleteTerm);
                this.transIndexManager.processJob(job);
            } else if (job instanceof FlushCommitTransactionJob) {
                if (this.transIndexManager.hasTransIndex(job.getSubIndex())) {
                    this.transIndexManager.commit(job.getSubIndex());
                    Directory transDir = this.transIndexManager.getDirectory(job.getSubIndex());
                    indexWriter.addIndexesNoOptimize(new Directory[]{transDir});
                    this.transIndexManager.close(job.getSubIndex());
                }
                indexWriter.commit();
            } else {
                this.transIndexManager.processJob(job);
            }
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to process job [" + job + "]", e);
        }
    }

    protected void prepareBeforeAsyncDirtyOperation(TransactionJob job) throws SearchEngineException {
        try {
            this.openIndexWriterIfNeeded(job.getSubIndex());
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open writer for sub index [" + job.getSubIndex() + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Term markDeleted(ResourceKey resourceKey) {
        Term deleteTerm;
        block18: {
            LuceneIndexHolder indexHolder = this.indexHoldersBySubIndex.get(resourceKey.getSubIndex());
            if (indexHolder == null) {
                Map<String, LuceneIndexHolder> map = this.indexHoldersBySubIndex;
                synchronized (map) {
                    indexHolder = this.indexHoldersBySubIndex.get(resourceKey.getSubIndex());
                    if (indexHolder == null) {
                        this.indexManager.getIndexHoldersCache().refreshCache(resourceKey.getSubIndex());
                        indexHolder = this.indexManager.getIndexHoldersCache().getHolder(resourceKey.getSubIndex());
                        this.indexHoldersBySubIndex.put(resourceKey.getSubIndex(), indexHolder);
                    }
                }
            }
            deleteTerm = new Term(resourceKey.getUIDPath(), resourceKey.buildUID());
            TermDocs termDocs = null;
            try {
                termDocs = indexHolder.getIndexReader().termDocs(deleteTerm);
                if (termDocs == null) break block18;
                int maxDoc = indexHolder.getIndexReader().maxDoc();
                try {
                    while (termDocs.next()) {
                        this.filter.markDelete(indexHolder.getIndexReader(), termDocs.doc(), maxDoc);
                    }
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to iterate data in order to delete", e);
                }
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to search for property [" + resourceKey + "]", e);
            }
            finally {
                try {
                    if (termDocs != null) {
                        termDocs.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return deleteTerm;
    }

    protected IndexWriter openIndexWriterIfNeeded(String subIndex) throws IOException {
        IndexWriter indexWriter = this.indexWriterBySubIndex.get(subIndex);
        if (indexWriter != null) {
            return indexWriter;
        }
        indexWriter = this.indexManager.getIndexWritersManager().openIndexWriter(this.searchEngine.getSettings(), subIndex);
        this.indexWriterBySubIndex.put(subIndex, indexWriter);
        this.indexManager.getIndexWritersManager().trackOpenIndexWriter(subIndex, indexWriter);
        return indexWriter;
    }

    private void releaseHolders() {
        for (LuceneIndexHolder indexHolder : this.indexHoldersBySubIndex.values()) {
            indexHolder.release();
        }
        this.indexHoldersBySubIndex.clear();
    }

    private class CommitCallable
    implements Callable {
        private String subIndex;
        private IndexWriter indexWriter;
        private PrepareCallable prepareCallable;

        public CommitCallable(String subIndex, IndexWriter indexWriter, boolean onePhase) {
            this.subIndex = subIndex;
            this.indexWriter = indexWriter;
            if (onePhase) {
                this.prepareCallable = new PrepareCallable(subIndex);
            }
        }

        public Object call() throws Exception {
            if (this.prepareCallable != null) {
                this.prepareCallable.call();
            }
            try {
                if (ReadCommittedTransactionProcessor.this.transIndexManager.hasTransIndex(this.subIndex)) {
                    Directory transDir = ReadCommittedTransactionProcessor.this.transIndexManager.getDirectory(this.subIndex);
                    this.indexWriter.addIndexesNoOptimize(new Directory[]{transDir});
                }
                this.indexWriter.close();
            }
            catch (IOException e) {
                Directory dir = ReadCommittedTransactionProcessor.this.indexManager.getStore().openDirectory(this.subIndex);
                try {
                    if (IndexWriter.isLocked((Directory)dir)) {
                        IndexWriter.unlock((Directory)dir);
                    }
                }
                catch (Exception e1) {
                    logger.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + this.subIndex + "]"), (Throwable)e);
                }
                throw new SearchEngineException("Failed to add transaction index to sub index [" + this.subIndex + "]", e);
            }
            finally {
                ReadCommittedTransactionProcessor.this.indexManager.getIndexWritersManager().trackCloseIndexWriter(this.subIndex, this.indexWriter);
            }
            if (ReadCommittedTransactionProcessor.this.isInvalidateCacheOnCommit()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Invalidating cache after commit for sub index [" + this.subIndex + "]"));
                }
                ReadCommittedTransactionProcessor.this.indexManager.getIndexHoldersCache().invalidateCache(this.subIndex);
            }
            try {
                ReadCommittedTransactionProcessor.this.transIndexManager.close(this.subIndex);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to close transactional index for sub index [" + this.subIndex + "], ignoring"), (Throwable)e);
            }
            return null;
        }
    }

    private class PrepareCallable
    implements Callable {
        private String subIndex;

        private PrepareCallable(String subIndex) {
            this.subIndex = subIndex;
        }

        public Object call() throws Exception {
            if (ReadCommittedTransactionProcessor.this.transIndexManager.hasTransIndex(this.subIndex)) {
                ReadCommittedTransactionProcessor.this.transIndexManager.commit(this.subIndex);
            }
            return null;
        }
    }
}

