/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import java.io.Reader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.query.LuceneSearchEngineBooleanQueryBuilder;
import org.compass.core.lucene.engine.query.LuceneSearchEngineMoreLikeThisQueryBuilder;
import org.compass.core.lucene.engine.query.LuceneSearchEngineMultiPhraseQueryBuilder;
import org.compass.core.lucene.engine.query.LuceneSearchEngineMultiPropertyQueryStringBuilder;
import org.compass.core.lucene.engine.query.LuceneSearchEngineQuerySpanNearBuilder;
import org.compass.core.lucene.engine.query.LuceneSearchEngineQuerySpanOrBuilder;
import org.compass.core.lucene.engine.query.LuceneSearchEngineQueryStringBuilder;
import org.compass.core.lucene.search.ConstantScorePrefixQuery;

public class LuceneSearchEngineQueryBuilder
implements SearchEngineQueryBuilder {
    private LuceneSearchEngineFactory searchEngineFactory;

    public LuceneSearchEngineQueryBuilder(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }

    public SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder bool() {
        return this.bool(false);
    }

    public SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder bool(boolean disableCoord) {
        return new LuceneSearchEngineBooleanQueryBuilder(this.searchEngineFactory, disableCoord);
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder multiPhrase(String resourcePropertyName) {
        return new LuceneSearchEngineMultiPhraseQueryBuilder(this.searchEngineFactory, resourcePropertyName);
    }

    public SearchEngineQuery term(String resourcePropertyName, String value) {
        TermQuery query = new TermQuery(new Term(resourcePropertyName, value));
        return new LuceneSearchEngineQuery(this.searchEngineFactory, (Query)query);
    }

    public SearchEngineQuery between(String resourcePropertyName, String low, String high, boolean inclusive, boolean constantScore) {
        ConstantScoreRangeQuery query;
        if (constantScore) {
            query = new ConstantScoreRangeQuery(resourcePropertyName, low, high, inclusive, inclusive);
        } else {
            Term lowTerm = null;
            if (low != null) {
                lowTerm = new Term(resourcePropertyName, low);
            }
            Term highTerm = null;
            if (high != null) {
                highTerm = new Term(resourcePropertyName, high);
            }
            query = new RangeQuery(lowTerm, highTerm, inclusive);
        }
        return new LuceneSearchEngineQuery(this.searchEngineFactory, (Query)query);
    }

    public SearchEngineQuery between(String resourcePropertyName, String low, String high, boolean inclusive) {
        return this.between(resourcePropertyName, low, high, inclusive, true);
    }

    public SearchEngineQuery ge(String resourcePropertyName, String value) {
        return this.between(resourcePropertyName, value, null, true);
    }

    public SearchEngineQuery gt(String resourcePropertyName, String value) {
        return this.between(resourcePropertyName, value, null, false);
    }

    public SearchEngineQuery le(String resourcePropertyName, String value) {
        return this.between(resourcePropertyName, null, value, true);
    }

    public SearchEngineQuery lt(String resourcePropertyName, String value) {
        return this.between(resourcePropertyName, null, value, false);
    }

    public SearchEngineQuery prefix(String resourcePropertyName, String prefix) {
        ConstantScorePrefixQuery query = new ConstantScorePrefixQuery(new Term(resourcePropertyName, prefix));
        return new LuceneSearchEngineQuery(this.searchEngineFactory, query);
    }

    public SearchEngineQuery wildcard(String resourcePropertyName, String wildcard) {
        WildcardQuery query = new WildcardQuery(new Term(resourcePropertyName, wildcard));
        return new LuceneSearchEngineQuery(this.searchEngineFactory, (Query)query);
    }

    public SearchEngineQuery matchAll() {
        return new LuceneSearchEngineQuery(this.searchEngineFactory, (Query)new MatchAllDocsQuery());
    }

    public SearchEngineQuery fuzzy(String resourcePropertyName, String value, float minimumSimilarity) {
        FuzzyQuery query = new FuzzyQuery(new Term(resourcePropertyName, value), minimumSimilarity);
        return new LuceneSearchEngineQuery(this.searchEngineFactory, (Query)query);
    }

    public SearchEngineQuery fuzzy(String resourcePropertyName, String value, float minimumSimilarity, int prefixLength) {
        FuzzyQuery query = new FuzzyQuery(new Term(resourcePropertyName, value), minimumSimilarity, prefixLength);
        return new LuceneSearchEngineQuery(this.searchEngineFactory, (Query)query);
    }

    public SearchEngineQuery fuzzy(String resourcePropertyName, String value) {
        FuzzyQuery query = new FuzzyQuery(new Term(resourcePropertyName, value));
        return new LuceneSearchEngineQuery(this.searchEngineFactory, (Query)query);
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder queryString(String queryString) {
        return new LuceneSearchEngineQueryStringBuilder(this.searchEngineFactory, queryString);
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder multiPropertyQueryString(String queryString) {
        return new LuceneSearchEngineMultiPropertyQueryStringBuilder(this.searchEngineFactory, queryString);
    }

    public SearchEngineQuery.SearchEngineSpanQuery spanEq(String resourcePropertyName, String value) {
        SpanTermQuery spanQuery = new SpanTermQuery(new Term(resourcePropertyName, value));
        return new LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery(this.searchEngineFactory, (SpanQuery)spanQuery);
    }

    public SearchEngineQuery.SearchEngineSpanQuery spanFirst(SearchEngineQuery.SearchEngineSpanQuery searchEngineSpanQuery, int end) {
        SpanFirstQuery spanQuery = new SpanFirstQuery(((LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery)searchEngineSpanQuery).toSpanQuery(), end);
        return new LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery(this.searchEngineFactory, (SpanQuery)spanQuery);
    }

    public SearchEngineQuery.SearchEngineSpanQuery spanFirst(String resourcePropertyName, String value, int end) {
        SpanFirstQuery spanQuery = new SpanFirstQuery((SpanQuery)new SpanTermQuery(new Term(resourcePropertyName, value)), end);
        return new LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery(this.searchEngineFactory, (SpanQuery)spanQuery);
    }

    public SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder spanNear(String resourcePropertyName) {
        return new LuceneSearchEngineQuerySpanNearBuilder(this.searchEngineFactory, resourcePropertyName);
    }

    public SearchEngineQuery.SearchEngineSpanQuery spanNot(SearchEngineQuery.SearchEngineSpanQuery include, SearchEngineQuery.SearchEngineSpanQuery exclude) {
        SpanNotQuery spanNotQuery = new SpanNotQuery(((LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery)include).toSpanQuery(), ((LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery)exclude).toSpanQuery());
        return new LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery(this.searchEngineFactory, (SpanQuery)spanNotQuery);
    }

    public SearchEngineQueryBuilder.SearchEngineQuerySpanOrBuilder spanOr() {
        return new LuceneSearchEngineQuerySpanOrBuilder(this.searchEngineFactory);
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder moreLikeThis(SearchEngine searchEngine, Resource idResource) {
        return new LuceneSearchEngineMoreLikeThisQueryBuilder((LuceneSearchEngine)searchEngine, this.searchEngineFactory, idResource);
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder moreLikeThis(SearchEngine searchEngine, Reader reader) {
        return new LuceneSearchEngineMoreLikeThisQueryBuilder((LuceneSearchEngine)searchEngine, this.searchEngineFactory, reader);
    }
}

