/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.compass.core.lucene.engine.manager.IndexHoldersCache;

public class LuceneIndexHolder {
    private final IndexHoldersCache indexHoldersCache;
    private final String subIndex;
    private final IndexSearcher indexSearcher;
    private final IndexReader indexReader;
    private volatile long lastCacheInvalidation = System.currentTimeMillis();
    private volatile boolean invalidated;
    private int count = 0;
    private boolean markForClose = false;
    private boolean closed;

    public LuceneIndexHolder(IndexHoldersCache indexHoldersCache, String subIndex, IndexSearcher indexSearcher) {
        this.indexHoldersCache = indexHoldersCache;
        this.subIndex = subIndex;
        this.indexSearcher = indexSearcher;
        this.indexReader = indexSearcher.getIndexReader();
        if (indexHoldersCache.isDebug()) {
            AtomicInteger count = (AtomicInteger)indexHoldersCache.getDebugHoldersCount().get(subIndex);
            if (count == null) {
                AtomicInteger newCount = new AtomicInteger();
                count = indexHoldersCache.getDebugHoldersCount().putIfAbsent(subIndex, newCount);
                if (count == null) {
                    count = newCount;
                }
            }
            count.incrementAndGet();
        }
    }

    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public synchronized boolean acquire() {
        if (this.markForClose) {
            return false;
        }
        ++this.count;
        return true;
    }

    public synchronized void release() {
        --this.count;
        this.checkIfCanClose();
    }

    public synchronized void markForClose() {
        this.markForClose = true;
        this.checkIfCanClose();
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public void setInvalidated(boolean invalidated) {
        this.invalidated = invalidated;
    }

    private void checkIfCanClose() {
        if (this.markForClose && this.count <= 0 && !this.closed) {
            if (this.indexHoldersCache.isDebug()) {
                ((AtomicInteger)this.indexHoldersCache.getDebugHoldersCount().get(this.subIndex)).decrementAndGet();
            }
            this.closed = true;
            try {
                this.indexSearcher.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.indexReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getLastCacheInvalidation() {
        return this.lastCacheInvalidation;
    }

    public void markLastCacheInvalidation() {
        this.lastCacheInvalidation = System.currentTimeMillis();
    }
}

