/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.util.Map;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.ResourceFactory;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.osem.AbstractRefAliasMappingConverter;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceEntry;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.RefAliasObjectMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.marshall.MarshallingContext;

public class ReferenceMappingConverter
extends AbstractRefAliasMappingConverter {
    private static final Object DISABLE_UID_MARK = new Object();

    protected boolean doMarshall(Resource resource, Object root, RefAliasObjectMapping hasRefAliasMapping, ClassMapping refMapping, MarshallingContext context) throws ConversionException {
        Object current = context.getAttribute("current");
        ReferenceMapping referenceMapping = (ReferenceMapping)hasRefAliasMapping;
        if (root == null) {
            if (!refMapping.isSupportUnmarshall()) {
                return false;
            }
            if (!context.handleNulls()) {
                return false;
            }
            ResourcePropertyMapping[] ids = refMapping.getResourceIdMappings();
            boolean store = false;
            for (ResourcePropertyMapping id : ids) {
                store |= id.getConverter().marshall(resource, context.getResourceFactory().getNullValue(), id, context);
            }
            return store;
        }
        if (refMapping.isSupportUnmarshall()) {
            ResourceFactory resourceFactory = context.getResourceFactory();
            if (refMapping.isPoly() && refMapping.getPolyClass() == null) {
                String className = root.getClass().getName();
                Property p = resourceFactory.createProperty(refMapping.getClassPath().getPath(), className, Property.Store.YES, Property.Index.NOT_ANALYZED);
                p.setOmitNorms(true);
                p.setOmitTf(true);
                resource.addProperty(p);
            }
        }
        context.setAttribute("$disableUID", DISABLE_UID_MARK);
        boolean stored = context.getMarshallingStrategy().marshallIds(resource, refMapping, root, context);
        context.removeAttribute("$disableUID");
        if (referenceMapping.getRefCompMapping() != null) {
            context.setAttribute("parent", current);
            stored |= referenceMapping.getRefCompMapping().getConverter().marshall(resource, root, referenceMapping.getRefCompMapping(), context);
        }
        return stored;
    }

    protected Object doUnmarshall(Resource resource, RefAliasObjectMapping hasRefAliasMapping, ClassMapping refMapping, MarshallingContext context) throws ConversionException {
        Object[] ids = context.getMarshallingStrategy().unmarshallIds(refMapping, resource, context);
        if (ids == null) {
            return null;
        }
        ReferenceMapping referenceMapping = (ReferenceMapping)hasRefAliasMapping;
        if (referenceMapping.isLazy().booleanValue()) {
            return new LazyReferenceEntry(refMapping.getAlias(), ids);
        }
        Map<Object, Object> attributes = context.removeAttributes();
        Object retVal = context.getSession().get(refMapping.getAlias(), (Object)ids, context);
        context.restoreAttributes(attributes);
        return retVal;
    }

    protected boolean rollbackClassNameOnPoly() {
        return false;
    }
}

