/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.json;

import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.json.AbstractDynamicJsonMappingConverter;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.json.JsonArray;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.json.JsonArrayMapping;
import org.compass.core.mapping.json.Naming;
import org.compass.core.marshall.MarshallingContext;

public class JsonArrayMappingConverter
extends AbstractDynamicJsonMappingConverter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        if (root == null) {
            return false;
        }
        JsonArray jsonArray = (JsonArray)root;
        JsonArrayMapping jsonArrayMapping = (JsonArrayMapping)mapping;
        Mapping elementMapping = jsonArrayMapping.getElementMapping();
        PropertyPath path = jsonArrayMapping.getPath();
        String propertyName = path == null ? (String)context.getAttribute("$jsonDynamicPath") : path.getPath();
        boolean store = false;
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.opt(i);
            if (value != null && jsonArray.isNull(i)) {
                value = null;
            }
            if (jsonArrayMapping.isDynamic()) {
                Naming oldNaming = null;
                if (jsonArrayMapping.getDynamicNaming() != null) {
                    oldNaming = (Naming)((Object)context.setAttribute("$jsonDynamicNaming", (Object)jsonArrayMapping.getDynamicNaming()));
                }
                store |= this.doConvertDynamicValue(resource, propertyName, value, context);
                if (jsonArrayMapping.getDynamicNaming() == null) continue;
                context.setAttribute("$jsonDynamicNaming", (Object)oldNaming);
                continue;
            }
            store |= elementMapping.getConverter().marshall(resource, value, elementMapping, context);
        }
        return store;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        throw new ConversionException("Not supported, please use json-content mapping");
    }
}

