/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;

public abstract class ConfigurableBufferedIndexInput
extends IndexInput {
    public static final int BUFFER_SIZE = 1024;
    protected int bufferSize = 1024;
    protected byte[] buffer;
    protected long bufferStart = 0L;
    protected int bufferLength = 0;
    protected int bufferPosition = 0;

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public ConfigurableBufferedIndexInput() {
    }

    public ConfigurableBufferedIndexInput(int bufferSize) {
        this.checkBufferSize(bufferSize);
        this.bufferSize = bufferSize;
    }

    public void setBufferSize(int newSize) {
        assert (this.buffer == null || this.bufferSize == this.buffer.length);
        if (newSize != this.bufferSize) {
            this.checkBufferSize(newSize);
            this.bufferSize = newSize;
            if (this.buffer != null) {
                byte[] newBuffer = new byte[newSize];
                int leftInBuffer = this.bufferLength - this.bufferPosition;
                int numToCopy = leftInBuffer > newSize ? newSize : leftInBuffer;
                System.arraycopy(this.buffer, this.bufferPosition, newBuffer, 0, numToCopy);
                this.bufferStart += (long)this.bufferPosition;
                this.bufferPosition = 0;
                this.bufferLength = numToCopy;
                this.buffer = newBuffer;
            }
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private void checkBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than 0 (got " + bufferSize + ")");
        }
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len <= this.bufferLength - this.bufferPosition) {
            if (len > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, len);
            }
            this.bufferPosition += len;
        } else {
            int available = this.bufferLength - this.bufferPosition;
            if (available > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, available);
                offset += available;
                len -= available;
                this.bufferPosition += available;
            }
            if (len < this.bufferSize) {
                this.refill();
                if (this.bufferLength < len) {
                    System.arraycopy(this.buffer, 0, b, offset, this.bufferLength);
                    throw new IOException("read past EOF");
                }
                System.arraycopy(this.buffer, 0, b, offset, len);
                this.bufferPosition = len;
            } else {
                long after = this.bufferStart + (long)this.bufferPosition + (long)len;
                if (after > this.length()) {
                    throw new IOException("read past EOF");
                }
                this.readInternal(b, offset, len);
                this.bufferStart = after;
                this.bufferPosition = 0;
                this.bufferLength = 0;
            }
        }
    }

    protected void refill() throws IOException {
        long start = this.bufferStart + (long)this.bufferPosition;
        long end = start + (long)this.bufferSize;
        if (end > this.length()) {
            end = this.length();
        }
        this.bufferLength = (int)(end - start);
        if (this.bufferLength <= 0) {
            throw new IOException("read past EOF");
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
            this.seekInternal(this.bufferStart);
        }
        this.readInternal(this.buffer, 0, this.bufferLength);
        this.bufferStart = start;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(pos - this.bufferStart);
        } else {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public Object clone() {
        ConfigurableBufferedIndexInput clone = (ConfigurableBufferedIndexInput)((Object)super.clone());
        clone.buffer = null;
        clone.bufferLength = 0;
        clone.bufferPosition = 0;
        clone.bufferStart = this.getFilePointer();
        return clone;
    }
}

