/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassException;
import org.compass.core.CompassTemplate;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassSettings;
import org.compass.core.events.RebuildEventListener;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.gps.CompassGpsException;
import org.compass.gps.IndexPlan;
import org.compass.gps.impl.AbstractCompassGps;
import org.compass.gps.impl.DefaultReplaceIndexCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleCompassGps
extends AbstractCompassGps {
    private Compass compass;
    private CompassTemplate compassTemplate;
    private volatile Compass indexCompass;
    private volatile CompassTemplate indexCompassTemplate;
    private volatile CompassTransaction.TransactionIsolation indexTransactionIsolation = CompassTransaction.TransactionIsolation.LUCENE;
    private Map<String, Object> indexSettings;
    private CompassSettings indexCompassSettings;

    public SingleCompassGps() {
    }

    public SingleCompassGps(Compass compass) {
        this.compass = compass;
    }

    @Override
    protected void doStart() throws CompassGpsException {
        if (this.compass == null) {
            throw new IllegalArgumentException("Must set the compass property");
        }
        CompassTransaction.TransactionIsolation defaultIsolation = ((LuceneSearchEngineFactory)((InternalCompass)this.compass).getSearchEngineFactory()).getLuceneSettings().getTransactionIsolation();
        if (defaultIsolation == CompassTransaction.TransactionIsolation.BATCH_INSERT) {
            throw new IllegalArgumentException("The compass instance is configured with transaction isolation of batch_insert, there is no need since this CompassGps will execute the index operation with batch_index automatically,  and mirroring with the configured transaction isolation");
        }
        this.indexCompassSettings = new CompassSettings();
        if (this.indexSettings != null) {
            this.indexCompassSettings.addSettings(this.indexSettings);
        }
        if (this.indexCompassSettings.getSetting("compass.engine.connection.subContext") == null) {
            this.indexCompassSettings.setSetting("compass.engine.connection.subContext", "gpsindex");
        }
        if (this.indexCompassSettings.getSetting("compass.engine.disableLocalCache") == null) {
            this.indexCompassSettings.setBooleanSetting("compass.engine.disableLocalCache", true);
        }
        if (this.indexCompassSettings.getSetting("compass.transaction.disableThreadBoundLocalTransaction") == null) {
            this.indexCompassSettings.setBooleanSetting("compass.transaction.disableThreadBoundLocalTransaction", false);
        }
        if (this.indexCompassSettings.getSetting("compass.cascade.disable") == null) {
            this.indexCompassSettings.setBooleanSetting("compass.cascade.disable", true);
        }
        this.indexCompassSettings.setBooleanSetting("compass.transaction.disableAutoJoinSession", true);
        this.compassTemplate = new CompassTemplate(this.compass);
        ((InternalCompass)this.compass).addRebuildEventListener(new RebuildEventListener(){

            public void onCompassRebuild(Compass compass) {
                if (SingleCompassGps.this.log.isDebugEnabled()) {
                    SingleCompassGps.this.log.debug((Object)"Rebuild detected, restarting");
                }
                SingleCompassGps.this.refresh();
            }
        });
    }

    @Override
    protected void doStop() throws CompassGpsException {
    }

    @Override
    protected void doIndex(IndexPlan indexPlan) throws CompassGpsException {
        ((InternalCompass)this.compass).stop();
        this.indexCompass = this.compass.clone(this.indexCompassSettings);
        this.indexCompass.getSearchEngineIndexManager().cleanIndex();
        this.indexCompassTemplate = new CompassTemplate(this.indexCompass);
        this.indexCompass.getSearchEngineIndexManager().clearCache();
        this.compass.getSearchEngineIndexManager().replaceIndex(this.indexCompass.getSearchEngineIndexManager(), new DefaultReplaceIndexCallback(this.devices.values(), indexPlan));
        this.indexCompass.getSearchEngineIndexManager().clearCache();
        try {
            this.indexCompass.getSearchEngineIndexManager().deleteIndex();
        }
        catch (CompassException e) {
            this.log.debug((Object)"Failed to delete gps index after indexing, ignoring", (Throwable)e);
        }
        this.indexCompass.close();
        this.indexCompass = null;
        this.indexCompassTemplate = null;
        ((InternalCompass)this.compass).start();
        if (this.compass.getSpellCheckManager() != null) {
            this.log.info((Object)"Rebulding spell check index ...");
            try {
                this.compass.getSpellCheckManager().concurrentRebuild();
                this.log.info((Object)"Spell check index rebuilt");
            }
            catch (Exception e) {
                this.log.info((Object)"Spell check index failed, will rebuilt it next time", (Throwable)e);
            }
        }
    }

    @Override
    public void executeForIndex(CompassCallback callback) throws CompassException {
        if (this.indexCompassTemplate == null) {
            this.compassTemplate.execute(this.indexTransactionIsolation, callback);
            return;
        }
        this.indexCompassTemplate.execute(this.indexTransactionIsolation, callback);
    }

    @Override
    public void executeForMirror(CompassCallback callback) throws CompassException {
        this.compassTemplate.execute(callback);
    }

    @Override
    public boolean hasMappingForEntityForIndex(Class clazz) throws CompassException {
        return this.hasRootMappingForEntity(clazz, this.getIndexCompass());
    }

    @Override
    public boolean hasMappingForEntityForIndex(String name) throws CompassException {
        return this.hasRootMappingForEntity(name, this.getIndexCompass());
    }

    @Override
    public boolean hasMappingForEntityForMirror(Class clazz, CascadeMapping.Cascade cascade) throws CompassException {
        return this.hasMappingForEntity(clazz, this.compass, cascade);
    }

    @Override
    public boolean hasMappingForEntityForMirror(String name, CascadeMapping.Cascade cascade) throws CompassException {
        return this.hasMappingForEntity(name, this.compass, cascade);
    }

    @Override
    public ResourceMapping getMappingForEntityForIndex(String name) throws CompassException {
        return this.getRootMappingForEntity(name, this.getIndexCompass());
    }

    @Override
    public ResourceMapping getMappingForEntityForIndex(Class clazz) throws CompassException {
        return this.getRootMappingForEntity(clazz, this.getIndexCompass());
    }

    @Override
    public Compass getIndexCompass() {
        if (this.indexCompass == null) {
            return this.compass;
        }
        return this.indexCompass;
    }

    @Override
    public Compass getMirrorCompass() {
        return this.compass;
    }

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    public void setIndexTransactionIsolation(CompassTransaction.TransactionIsolation indexTransactionIsolation) {
        this.indexTransactionIsolation = indexTransactionIsolation;
    }

    public void setIndexSettings(Properties indexSettings) {
        if (this.indexSettings == null) {
            this.indexSettings = new HashMap<String, Object>();
        }
        for (Map.Entry<Object, Object> entry : indexSettings.entrySet()) {
            this.indexSettings.put((String)entry.getKey(), entry.getValue());
        }
    }

    public void setIndexSettings(Map<String, Object> indexSettings) {
        if (this.indexSettings == null) {
            this.indexSettings = new HashMap<String, Object>();
        }
        this.indexSettings.putAll(indexSettings);
    }

    public void setIndexProperties(Properties indexSettings) {
        this.setIndexSettings(indexSettings);
    }

    public void setIndexSettings(CompassSettings indexSettings) {
        if (this.indexSettings == null) {
            this.indexSettings = new HashMap<String, Object>();
        }
        this.indexSettings.putAll(indexSettings.getUnderlyingMap());
    }
}

