/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.impl;

import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassException;
import org.compass.core.CompassTemplate;
import org.compass.core.events.RebuildEventListener;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.gps.CompassGpsException;
import org.compass.gps.IndexPlan;
import org.compass.gps.impl.AbstractCompassGps;
import org.compass.gps.impl.DefaultReplaceIndexCallback;

public class DualCompassGps
extends AbstractCompassGps {
    private Compass indexCompass;
    private CompassTemplate indexCompassTemplate;
    private Compass mirrorCompass;
    private CompassTemplate mirrorCompassTemplate;

    public DualCompassGps() {
    }

    public DualCompassGps(Compass indexCompass, Compass mirrorCompass) {
        this.indexCompass = indexCompass;
        this.mirrorCompass = mirrorCompass;
    }

    protected void doStart() throws CompassGpsException {
        if (this.indexCompass == null) {
            throw new IllegalArgumentException("Must set the indexCompass property (for batch indexing)");
        }
        this.indexCompassTemplate = new CompassTemplate(this.indexCompass);
        if (this.mirrorCompass != null) {
            this.mirrorCompassTemplate = new CompassTemplate(this.mirrorCompass);
        }
    }

    protected void doStop() throws CompassGpsException {
    }

    protected void doIndex(IndexPlan indexPlan) throws CompassGpsException {
        if (this.mirrorCompass != null) {
            ((InternalCompass)this.mirrorCompass).stop();
        }
        ((InternalCompass)this.indexCompass).stop();
        this.indexCompass.getSearchEngineIndexManager().clearCache();
        this.indexCompass.getSearchEngineIndexManager().deleteIndex();
        this.indexCompass.getSearchEngineIndexManager().createIndex();
        this.mirrorCompass.getSearchEngineIndexManager().replaceIndex(this.indexCompass.getSearchEngineIndexManager(), new DefaultReplaceIndexCallback(this.devices.values(), indexPlan));
        if (this.mirrorCompass != null) {
            ((InternalCompass)this.mirrorCompass).start();
        }
        ((InternalCompass)this.indexCompass).start();
        if (this.mirrorCompass.getSpellCheckManager() != null) {
            this.log.info((Object)"Rebulding spell check index ...");
            try {
                this.mirrorCompass.getSpellCheckManager().concurrentRebuild();
                this.log.info((Object)"Spell check index rebuilt");
            }
            catch (Exception e) {
                this.log.info((Object)"Spell check index failed, will rebuilt it next time", (Throwable)e);
            }
        }
        ((InternalCompass)this.indexCompass).addRebuildEventListener(new RebuildEventListener(){

            public void onCompassRebuild(Compass compass) {
                if (DualCompassGps.this.log.isDebugEnabled()) {
                    DualCompassGps.this.log.debug((Object)"Rebuild detected, restarting");
                }
                DualCompassGps.this.refresh();
            }
        });
        ((InternalCompass)this.mirrorCompass).addRebuildEventListener(new RebuildEventListener(){

            public void onCompassRebuild(Compass compass) {
                if (DualCompassGps.this.log.isDebugEnabled()) {
                    DualCompassGps.this.log.debug((Object)"Rebuild detected, restarting");
                }
                DualCompassGps.this.refresh();
            }
        });
    }

    public void executeForIndex(CompassCallback callback) throws CompassException {
        this.indexCompassTemplate.execute(callback);
    }

    public void executeForMirror(CompassCallback callback) throws CompassException {
        this.mirrorCompassTemplate.execute(callback);
    }

    public boolean hasMappingForEntityForIndex(Class clazz) throws CompassException {
        return this.hasRootMappingForEntity(clazz, this.indexCompass);
    }

    public boolean hasMappingForEntityForIndex(String name) throws CompassException {
        return this.hasRootMappingForEntity(name, this.indexCompass);
    }

    public boolean hasMappingForEntityForMirror(Class clazz, CascadeMapping.Cascade cascade) throws CompassException {
        return this.hasMappingForEntity(clazz, this.mirrorCompass, cascade);
    }

    public boolean hasMappingForEntityForMirror(String name, CascadeMapping.Cascade cascade) throws CompassException {
        return this.hasMappingForEntity(name, this.mirrorCompass, cascade);
    }

    public ResourceMapping getMappingForEntityForIndex(String name) throws CompassException {
        return this.getRootMappingForEntity(name, this.indexCompass);
    }

    public ResourceMapping getMappingForEntityForIndex(Class clazz) throws CompassException {
        return this.getRootMappingForEntity(clazz, this.indexCompass);
    }

    public Compass getIndexCompass() {
        return this.indexCompass;
    }

    public void setIndexCompass(Compass indexCompass) {
        this.indexCompass = indexCompass;
    }

    public Compass getMirrorCompass() {
        return this.mirrorCompass;
    }

    public void setMirrorCompass(Compass mirrorCompass) {
        this.mirrorCompass = mirrorCompass;
    }

    public CompassTemplate getIndexCompassTemplate() {
        return this.indexCompassTemplate;
    }

    public CompassTemplate getMirrorCompassTemplate() {
        return this.mirrorCompassTemplate;
    }
}

