/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.reflection.asm;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.compass.core.util.asm.ClassWriter;
import org.compass.core.util.asm.MethodVisitor;
import org.compass.core.util.asm.Type;
import org.compass.core.util.reflection.ReflectionMethod;
import org.compass.core.util.reflection.asm.Boxer;
import org.compass.core.util.reflection.plain.PlainReflectionMethod;

public class AsmReflectionMethodGenerator {
    private static final String PLAIN_PROCEDURE_INTERNAL_NAME = Type.getInternalName(PlainReflectionMethod.class);

    public static synchronized ReflectionMethod generateMethod(Method refMethod) throws SecurityException, NoSuchMethodException {
        return AsmReflectionMethodGenerator.generateMethod(refMethod, "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", ReflectionMethod.class, true, true);
    }

    private static synchronized ReflectionMethod generateMethod(Method refMethod, String name, String desc, Class interfaceClass, boolean argsParams, boolean returnValue) throws SecurityException, NoSuchMethodException {
        int methodIndex;
        Class<?> declaringClass = refMethod.getDeclaringClass();
        String ownerClassName = declaringClass.getName();
        Method[] declaredMethods = declaringClass.getDeclaredMethods();
        for (methodIndex = 0; methodIndex < declaredMethods.length && !declaredMethods[methodIndex].equals(refMethod); ++methodIndex) {
        }
        String className = ownerClassName + "MethodReflection" + name + methodIndex;
        try {
            Class definedClass;
            try {
                definedClass = declaringClass.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                String classInternalName = className.replace('.', '/');
                ClassWriter cw = new ClassWriter(1);
                cw.visit(48, 1, classInternalName, null, PLAIN_PROCEDURE_INTERNAL_NAME, new String[]{Type.getInternalName(interfaceClass)});
                AsmReflectionMethodGenerator.createCtor(cw);
                AsmReflectionMethodGenerator.createMethod(refMethod.getDeclaringClass(), refMethod.getName(), refMethod, cw, name, desc, argsParams, returnValue, refMethod.getParameterTypes());
                cw.visitEnd();
                byte[] b = cw.toByteArray();
                definedClass = AsmReflectionMethodGenerator.defineClass(declaringClass.getClassLoader(), className, b);
            }
            return (ReflectionMethod)definedClass.getConstructor(Method.class).newInstance(refMethod);
        }
        catch (Exception e) {
            NoSuchMethodException ex = new NoSuchMethodException("Can't create ASM method reflection helper for [" + refMethod + "]");
            ex.initCause(e);
            throw ex;
        }
    }

    private static void createCtor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/reflect/Method;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(PlainReflectionMethod.class), "<init>", "(Ljava/lang/reflect/Method;)V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void createMethod(Class clazz, String name, Method refMethod, ClassWriter cw, String methodName, String desc, boolean argsParams, boolean returnValue, Class ... parameterTypes) {
        int invokeCode;
        MethodVisitor mv = cw.visitMethod(129, methodName, desc, null, null);
        boolean isStatic = Modifier.isStatic(refMethod.getModifiers());
        boolean isInteface = Modifier.isInterface(refMethod.getDeclaringClass().getModifiers());
        if (isStatic) {
            invokeCode = 184;
        } else {
            invokeCode = isInteface ? 185 : 182;
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, Type.getInternalName(clazz));
        }
        if (argsParams) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                mv.visitVarInsn(25, 2);
                mv.visitIntInsn(16, i);
                mv.visitInsn(50);
                AsmReflectionMethodGenerator.prepareParameter(mv, Type.getType(parameterTypes[i]));
            }
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                mv.visitVarInsn(25, i + 2);
                AsmReflectionMethodGenerator.prepareParameter(mv, Type.getType(parameterTypes[i]));
            }
        }
        mv.visitMethodInsn(invokeCode, Type.getInternalName(clazz), name, Type.getMethodDescriptor(refMethod));
        if (returnValue) {
            AsmReflectionMethodGenerator.prepareResult(mv, refMethod);
            mv.visitInsn(176);
        } else {
            mv.visitInsn(177);
        }
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void prepareResult(MethodVisitor mv, Method refMethod) {
        Type type = Type.getReturnType(refMethod);
        switch (type.getSort()) {
            case 0: {
                mv.visitInsn(1);
                break;
            }
            case 1: {
                AsmReflectionMethodGenerator.callBoxer(mv, "(Z)Ljava/lang/Object;");
                break;
            }
            case 3: {
                AsmReflectionMethodGenerator.callBoxer(mv, "(B)Ljava/lang/Object;");
                break;
            }
            case 2: {
                AsmReflectionMethodGenerator.callBoxer(mv, "(C)Ljava/lang/Object;");
                break;
            }
            case 4: {
                AsmReflectionMethodGenerator.callBoxer(mv, "(S)Ljava/lang/Object;");
                break;
            }
            case 5: {
                AsmReflectionMethodGenerator.callBoxer(mv, "(I)Ljava/lang/Object;");
                break;
            }
            case 7: {
                AsmReflectionMethodGenerator.callBoxer(mv, "(J)Ljava/lang/Object;");
                break;
            }
            case 6: {
                AsmReflectionMethodGenerator.callBoxer(mv, "(F)Ljava/lang/Object;");
                break;
            }
            case 8: {
                AsmReflectionMethodGenerator.callBoxer(mv, "(D)Ljava/lang/Object;");
            }
        }
    }

    private static void callBoxer(MethodVisitor mv, String desc) {
        mv.visitMethodInsn(184, Boxer.INTERNAL_NAME, "box", desc);
    }

    private static void prepareParameter(MethodVisitor mv, Type type) {
        switch (type.getSort()) {
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Byte");
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Short");
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Integer");
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Float");
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Double");
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            default: {
                mv.visitTypeInsn(192, type.getInternalName());
            }
        }
    }

    private static Class defineClass(ClassLoader loader, String name, byte[] b) throws Exception {
        Method defineMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        defineMethod.setAccessible(true);
        return (Class)defineMethod.invoke((Object)loader, name, b, 0, b.length);
    }
}

