/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.asm.util;

import org.compass.core.util.asm.AnnotationVisitor;
import org.compass.core.util.asm.Attribute;
import org.compass.core.util.asm.FieldVisitor;
import org.compass.core.util.asm.util.CheckAnnotationAdapter;
import org.compass.core.util.asm.util.CheckMethodAdapter;

public class CheckFieldAdapter
implements FieldVisitor {
    private final FieldVisitor fv;
    private boolean end;

    public CheckFieldAdapter(FieldVisitor fv) {
        this.fv = fv;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkEnd();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.fv.visitAnnotation(desc, visible));
    }

    public void visitAttribute(Attribute attr) {
        this.checkEnd();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.fv.visitAttribute(attr);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        this.fv.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

