/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.internal.InternalOverrideByNameMapping;
import org.compass.core.mapping.osem.AbstractAccessorMapping;
import org.compass.core.util.Parameter;

public abstract class AbstractCollectionMapping
extends AbstractAccessorMapping
implements InternalOverrideByNameMapping {
    private PropertyPath collectionTypePath;
    private PropertyPath colSizePath;
    private Mapping elementMapping;
    private boolean overrideByName;
    private CollectionType collectionType;

    public void copy(AbstractCollectionMapping copy) {
        super.copy(copy);
        copy.setElementMapping(this.getElementMapping());
        copy.setCollectionTypePath(this.getCollectionTypePath());
        copy.setColSizePath(this.getColSizePath());
        copy.setOverrideByName(this.isOverrideByName());
        copy.setCollectionType(this.getCollectionType());
    }

    public boolean canBeCollectionWrapped() {
        return false;
    }

    public Mapping getElementMapping() {
        return this.elementMapping;
    }

    public void setElementMapping(Mapping elementMapping) {
        this.elementMapping = elementMapping;
    }

    public PropertyPath getCollectionTypePath() {
        return this.collectionTypePath;
    }

    public void setCollectionTypePath(PropertyPath collectionTypePath) {
        this.collectionTypePath = collectionTypePath;
    }

    public PropertyPath getColSizePath() {
        return this.colSizePath;
    }

    public void setColSizePath(PropertyPath colSizePath) {
        this.colSizePath = colSizePath;
    }

    public boolean isOverrideByName() {
        return this.overrideByName;
    }

    public void setOverrideByName(boolean overrideByName) {
        this.overrideByName = overrideByName;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public static final class CollectionType
    extends Parameter {
        private static final long serialVersionUID = 5419036751959715652L;
        public static final CollectionType NOT_REQUIRED = new CollectionType("NOT_REQUIRED");
        public static final CollectionType UNKNOWN = new CollectionType("UNKNOWN");
        public static final CollectionType SET = new CollectionType("SET");
        public static final CollectionType LIST = new CollectionType("LIST");
        public static final CollectionType ENUM_SET = new CollectionType("ESET");
        public static final CollectionType SORTED_SET = new CollectionType("SORTED_SET");
        public static final CollectionType LINKED_HASH_SET = new CollectionType("LINKED_HASH_SET");

        private CollectionType(String name) {
            super(name);
        }

        public static String toString(CollectionType collectionType) {
            if (collectionType == NOT_REQUIRED) {
                return "na";
            }
            if (collectionType == UNKNOWN) {
                return "unknown";
            }
            if (collectionType == SET) {
                return "set";
            }
            if (collectionType == LIST) {
                return "list";
            }
            if (collectionType == SORTED_SET) {
                return "sortset";
            }
            if (collectionType == LINKED_HASH_SET) {
                return "linkedset";
            }
            if (collectionType == ENUM_SET) {
                return "eset";
            }
            throw new IllegalArgumentException("Can't find collection type for [" + collectionType + "]");
        }

        public static CollectionType fromString(String collectionType) {
            if ("na".equalsIgnoreCase(collectionType)) {
                return NOT_REQUIRED;
            }
            if ("unknown".equalsIgnoreCase(collectionType)) {
                return UNKNOWN;
            }
            if ("set".equalsIgnoreCase(collectionType)) {
                return SET;
            }
            if ("list".equalsIgnoreCase(collectionType)) {
                return LIST;
            }
            if ("sortset".equalsIgnoreCase(collectionType)) {
                return SORTED_SET;
            }
            if ("linkedset".equalsIgnoreCase(collectionType)) {
                return LINKED_HASH_SET;
            }
            if ("eset".equalsIgnoreCase(collectionType)) {
                return ENUM_SET;
            }
            throw new IllegalArgumentException("Can't find collection type for [" + collectionType + "]");
        }
    }
}

