/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.json;

import org.compass.core.Resource;
import org.compass.core.converter.Converter;
import org.compass.core.converter.json.SimpleJsonValueConverter;
import org.compass.core.converter.mapping.json.JsonArrayMappingConverter;
import org.compass.core.converter.mapping.json.JsonPropertyMappingConverter;
import org.compass.core.converter.mapping.json.PlainJsonObjectMappingConverter;
import org.compass.core.json.JsonArray;
import org.compass.core.json.JsonObject;
import org.compass.core.mapping.json.JsonArrayMapping;
import org.compass.core.mapping.json.JsonPropertyMapping;
import org.compass.core.mapping.json.PlainJsonObjectMapping;
import org.compass.core.marshall.MarshallingContext;

public abstract class AbstractDynamicJsonMappingConverter
implements Converter {
    public static final String DYNAMIC_PATH_CONTEXT_KEY = "$jsonDynamicPath";
    private JsonPropertyMappingConverter propertyMappingConverter;
    private JsonPropertyMapping propertyMapping;
    private PlainJsonObjectMappingConverter objectMappingConverter;
    private PlainJsonObjectMapping objectMapping;
    private JsonArrayMappingConverter arrayMappingConverter;
    private JsonArrayMapping arrayMapping;

    protected boolean doConvertDynamicValue(Resource resource, String name, Object value, MarshallingContext context) {
        boolean store = false;
        if (value == null) {
            return store;
        }
        if (value instanceof JsonArray) {
            if (this.arrayMappingConverter == null) {
                this.arrayMappingConverter = new JsonArrayMappingConverter();
                this.arrayMapping = new JsonArrayMapping();
                this.arrayMapping.setDynamic(true);
            }
            Object oldValue = context.setAttribute(DYNAMIC_PATH_CONTEXT_KEY, name);
            store = this.arrayMappingConverter.marshall(resource, value, this.arrayMapping, context);
            context.setAttribute(DYNAMIC_PATH_CONTEXT_KEY, oldValue);
        } else if (value instanceof JsonObject) {
            if (this.objectMappingConverter == null) {
                this.objectMappingConverter = new PlainJsonObjectMappingConverter();
                this.objectMapping = new PlainJsonObjectMapping();
                this.objectMapping.setDynamic(true);
            }
            Object oldValue = context.setAttribute(DYNAMIC_PATH_CONTEXT_KEY, name);
            this.objectMappingConverter.marshall(resource, value, this.objectMapping, context);
            context.setAttribute(DYNAMIC_PATH_CONTEXT_KEY, oldValue);
        } else {
            if (this.propertyMappingConverter == null) {
                this.propertyMappingConverter = new JsonPropertyMappingConverter();
                this.propertyMapping = new JsonPropertyMapping();
                this.propertyMapping.setDynamic(true);
                this.propertyMapping.setValueConverter(new SimpleJsonValueConverter());
            }
            Object oldValue = context.setAttribute(DYNAMIC_PATH_CONTEXT_KEY, name);
            store = this.propertyMappingConverter.marshall(resource, value, this.propertyMapping, context);
            context.setAttribute(DYNAMIC_PATH_CONTEXT_KEY, oldValue);
        }
        return store;
    }
}

