/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.compass.core.Property;
import org.compass.core.config.CommonMetaDataLookup;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.binding.AbstractConfigurationHelperMappingBinding;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.engine.subindex.ConstantSubIndexHash;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.SpellCheckType;
import org.compass.core.mapping.internal.DefaultAllMapping;
import org.compass.core.mapping.internal.DefaultContractMapping;
import org.compass.core.mapping.internal.InternalAliasMapping;
import org.compass.core.mapping.internal.InternalCascadeMapping;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.mapping.internal.InternalContractMapping;
import org.compass.core.mapping.internal.InternalMapping;
import org.compass.core.mapping.internal.InternalResourceMapping;
import org.compass.core.mapping.internal.InternalResourcePropertyMapping;
import org.compass.core.mapping.json.JsonArrayMapping;
import org.compass.core.mapping.json.JsonBoostPropertyMapping;
import org.compass.core.mapping.json.JsonContentMapping;
import org.compass.core.mapping.json.JsonIdMapping;
import org.compass.core.mapping.json.JsonPropertyAnalyzerController;
import org.compass.core.mapping.json.JsonPropertyMapping;
import org.compass.core.mapping.json.PlainJsonObjectMapping;
import org.compass.core.mapping.json.RootJsonObjectMapping;
import org.compass.core.mapping.osem.ClassBoostPropertyMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyAnalyzerController;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.IdComponentMapping;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.PlainCascadeMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.mapping.rsem.RawBoostPropertyMapping;
import org.compass.core.mapping.rsem.RawResourceMapping;
import org.compass.core.mapping.rsem.RawResourcePropertyAnalyzerController;
import org.compass.core.mapping.rsem.RawResourcePropertyIdMapping;
import org.compass.core.mapping.rsem.RawResourcePropertyMapping;
import org.compass.core.mapping.support.AbstractResourceMapping;
import org.compass.core.mapping.xsem.XmlBoostPropertyMapping;
import org.compass.core.mapping.xsem.XmlContentMapping;
import org.compass.core.mapping.xsem.XmlIdMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.mapping.xsem.XmlPropertyAnalyzerController;
import org.compass.core.mapping.xsem.XmlPropertyMapping;
import org.compass.core.metadata.Alias;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;
import org.compass.core.util.config.ConfigurationHelper;

public abstract class PlainMappingBinding
extends AbstractConfigurationHelperMappingBinding {
    private CommonMetaDataLookup valueLookup;

    public void setUpBinding(InternalCompassMapping mapping, CompassMetaData metaData, CompassSettings settings) {
        super.setUpBinding(mapping, metaData, settings);
        this.valueLookup = new CommonMetaDataLookup(metaData);
    }

    protected boolean doAddConfiguration(ConfigurationHelper doc) throws ConfigurationException, MappingException {
        ConfigurationHelper[] classArr;
        ConfigurationHelper[] resourceContractArr;
        ConfigurationHelper[] contractArr;
        if (!doc.getName().equals("compass-core-mapping")) {
            return false;
        }
        String defaultPackage = doc.getAttribute("package", null);
        defaultPackage = defaultPackage != null ? defaultPackage + "." : "";
        for (ConfigurationHelper aContractArr : contractArr = doc.getChildren("contract")) {
            DefaultContractMapping contractMapping = new DefaultContractMapping();
            this.bindContract(aContractArr, contractMapping);
            this.mapping.addMapping(contractMapping);
        }
        for (ConfigurationHelper aResourceContractArr : resourceContractArr = doc.getChildren("resource-contract")) {
            DefaultContractMapping contractMapping = new DefaultContractMapping();
            this.bindResourceContract(aResourceContractArr, contractMapping);
            this.mapping.addMapping(contractMapping);
        }
        for (ConfigurationHelper classConf : classArr = doc.getChildren("class")) {
            ClassMapping classMapping;
            String alias = classConf.getAttribute("alias");
            boolean newClassMapping = false;
            AliasMapping aliasMapping = this.mapping.getAliasMapping(alias);
            if (aliasMapping != null) {
                if (!(aliasMapping instanceof ClassMapping)) {
                    throw new MappingException("Defined searchable annotation on a class with alias [" + alias + "] but it" + " not of type class mapping");
                }
                classMapping = (ClassMapping)aliasMapping;
            } else {
                classMapping = new ClassMapping();
                newClassMapping = true;
            }
            this.bindClass(classConf, classMapping, defaultPackage);
            if (!newClassMapping) continue;
            this.mapping.addMapping(classMapping);
        }
        for (ConfigurationHelper conf : doc.getChildren("resource")) {
            RawResourceMapping rawResourceMapping = new RawResourceMapping();
            this.bindResource(conf, rawResourceMapping);
            this.mapping.addMapping(rawResourceMapping);
        }
        for (ConfigurationHelper conf : doc.getChildren("xml-object", "xml")) {
            XmlObjectMapping xmlObjectMapping = new XmlObjectMapping();
            this.bindXmlObject(conf, xmlObjectMapping);
            this.mapping.addMapping(xmlObjectMapping);
        }
        for (ConfigurationHelper conf : doc.getChildren("root-json-object", "json-object", "json")) {
            RootJsonObjectMapping rootJsonObjectMapping = new RootJsonObjectMapping();
            this.bindJsonRootObject(conf, rootJsonObjectMapping);
            this.mapping.addMapping(rootJsonObjectMapping);
        }
        return true;
    }

    private void bindJsonRootObject(ConfigurationHelper jsonObjectConf, RootJsonObjectMapping rootJsonObjectMapping) throws ConfigurationException {
        ConfigurationHelper boostConf;
        String aliasValue = jsonObjectConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            rootJsonObjectMapping.setAlias(aliasValue);
        } else {
            rootJsonObjectMapping.setAlias(alias.getName());
        }
        this.bindSubIndexHash(jsonObjectConf, rootJsonObjectMapping);
        this.bindExtends(jsonObjectConf, rootJsonObjectMapping);
        this.bindAll(jsonObjectConf, rootJsonObjectMapping);
        this.bindSpellCheck(jsonObjectConf, rootJsonObjectMapping);
        String analyzer = jsonObjectConf.getAttribute("analyzer", null);
        rootJsonObjectMapping.setAnalyzer(analyzer);
        rootJsonObjectMapping.setRoot(true);
        rootJsonObjectMapping.setBoost(PlainMappingBinding.getBoost(jsonObjectConf));
        this.bindConverter(jsonObjectConf, rootJsonObjectMapping);
        rootJsonObjectMapping.setDynamic(jsonObjectConf.getAttributeAsBoolean("dynamic", false));
        for (ConfigurationHelper id : jsonObjectConf.getChildren("json-id", "id")) {
            JsonIdMapping jsonIdMapping = new JsonIdMapping();
            this.bindJsonProperty(id, jsonIdMapping, rootJsonObjectMapping);
            rootJsonObjectMapping.addMapping(jsonIdMapping);
        }
        for (ConfigurationHelper prop : jsonObjectConf.getChildren("json-property", "property")) {
            JsonPropertyMapping jsonPropertyMapping = new JsonPropertyMapping();
            this.bindJsonProperty(prop, jsonPropertyMapping, rootJsonObjectMapping);
            rootJsonObjectMapping.addMapping(jsonPropertyMapping);
        }
        ConfigurationHelper jsonContentConf = jsonObjectConf.getChild("json-content", false);
        if (jsonContentConf == null) {
            jsonContentConf = jsonObjectConf.getChild("content", false);
        }
        if (jsonContentConf != null) {
            JsonContentMapping jsonContentMapping = new JsonContentMapping();
            this.bindJsonContent(jsonContentConf, jsonContentMapping);
            rootJsonObjectMapping.addMapping(jsonContentMapping);
        }
        for (ConfigurationHelper obj : jsonObjectConf.getChildren("json-object", "object")) {
            PlainJsonObjectMapping jsonObjectMapping = new PlainJsonObjectMapping();
            this.bindJsonPlainObject(obj, jsonObjectMapping, rootJsonObjectMapping);
            rootJsonObjectMapping.addMapping(jsonObjectMapping);
        }
        for (ConfigurationHelper arr : jsonObjectConf.getChildren("json-array", "array")) {
            JsonArrayMapping jsonArrayMapping = new JsonArrayMapping();
            this.bindJsonArray(arr, jsonArrayMapping, rootJsonObjectMapping);
            rootJsonObjectMapping.addMapping(jsonArrayMapping);
        }
        ConfigurationHelper analyzerConf = jsonObjectConf.getChild("json-analyzer", false);
        if (analyzerConf == null) {
            analyzerConf = jsonObjectConf.getChild("analyzer", false);
        }
        if (analyzerConf != null) {
            JsonPropertyAnalyzerController analyzerController = new JsonPropertyAnalyzerController();
            this.bindJsonProperty(analyzerConf, analyzerController, rootJsonObjectMapping);
            analyzerController.setNullAnalyzer(analyzerConf.getAttribute("null-analyzer", null));
            rootJsonObjectMapping.addMapping(analyzerController);
        }
        if ((boostConf = jsonObjectConf.getChild("json-boost", false)) == null) {
            boostConf = jsonObjectConf.getChild("boost", false);
        }
        if (boostConf != null) {
            JsonBoostPropertyMapping boostPropertyMapping = new JsonBoostPropertyMapping();
            this.bindJsonProperty(boostConf, boostPropertyMapping, rootJsonObjectMapping);
            String defaultBoost = boostConf.getAttribute("default", null);
            if (defaultBoost != null) {
                boostPropertyMapping.setDefaultBoost(Float.parseFloat(defaultBoost));
            }
            rootJsonObjectMapping.addMapping(boostPropertyMapping);
        }
    }

    private void bindJsonArray(ConfigurationHelper jsonArrayConf, JsonArrayMapping jsonArrayMapping, RootJsonObjectMapping rootJsonObjectMapping) {
        String name = jsonArrayConf.getAttribute("name", null);
        if (name != null) {
            name = this.valueLookup.lookupMetaDataName(name);
        }
        jsonArrayMapping.setName(name);
        String indexName = jsonArrayConf.getAttribute("index-name", name);
        jsonArrayMapping.setPath(indexName == null ? null : new StaticPropertyPath(indexName));
        jsonArrayMapping.setDynamic(jsonArrayConf.getAttributeAsBoolean("dynamic", false));
        this.bindConverter(jsonArrayConf, jsonArrayMapping);
        ConfigurationHelper conf = jsonArrayConf.getChild("json-property", false);
        if (conf != null) {
            JsonPropertyMapping jsonPropertyMapping = new JsonPropertyMapping();
            this.bindJsonProperty(conf, jsonPropertyMapping, rootJsonObjectMapping);
            if (jsonPropertyMapping.getName() == null) {
                jsonPropertyMapping.setName(jsonArrayMapping.getName());
            }
            if (jsonPropertyMapping.getPath() == null) {
                jsonPropertyMapping.setPath(jsonArrayMapping.getPath());
            }
            jsonArrayMapping.setElementMapping(jsonPropertyMapping);
        }
        if ((conf = jsonArrayConf.getChild("json-object", false)) != null) {
            PlainJsonObjectMapping jsonObjectMapping = new PlainJsonObjectMapping();
            this.bindJsonPlainObject(conf, jsonObjectMapping, rootJsonObjectMapping);
            if (jsonObjectMapping.getName() == null) {
                jsonObjectMapping.setName(jsonArrayMapping.getName());
            }
            if (jsonObjectMapping.getPath() == null) {
                jsonObjectMapping.setPath(jsonArrayMapping.getPath());
            }
            jsonArrayMapping.setElementMapping(jsonObjectMapping);
        }
        if ((conf = jsonArrayConf.getChild("json-array", false)) != null) {
            JsonArrayMapping intenralJsonArrayMapping = new JsonArrayMapping();
            this.bindJsonArray(conf, intenralJsonArrayMapping, rootJsonObjectMapping);
            if (intenralJsonArrayMapping.getName() == null) {
                intenralJsonArrayMapping.setName(jsonArrayMapping.getName());
            }
            if (intenralJsonArrayMapping.getPath() == null) {
                intenralJsonArrayMapping.setPath(jsonArrayMapping.getPath());
            }
            jsonArrayMapping.setElementMapping(intenralJsonArrayMapping);
        }
    }

    private void bindJsonPlainObject(ConfigurationHelper jsonObjectConf, PlainJsonObjectMapping jsonObjectMapping, RootJsonObjectMapping rootJsonObjectMapping) {
        String name = jsonObjectConf.getAttribute("name", null);
        if (name != null) {
            name = this.valueLookup.lookupMetaDataName(name);
        }
        jsonObjectMapping.setName(name);
        jsonObjectMapping.setPath(new StaticPropertyPath(name));
        this.bindConverter(jsonObjectConf, jsonObjectMapping);
        jsonObjectMapping.setDynamic(jsonObjectConf.getAttributeAsBoolean("dynamic", false));
        for (ConfigurationHelper prop : jsonObjectConf.getChildren("json-property")) {
            JsonPropertyMapping jsonPropertyMapping = new JsonPropertyMapping();
            this.bindJsonProperty(prop, jsonPropertyMapping, rootJsonObjectMapping);
            jsonObjectMapping.addMapping(jsonPropertyMapping);
        }
        for (ConfigurationHelper obj : jsonObjectConf.getChildren("json-object")) {
            PlainJsonObjectMapping intenralJsonObjectMapping = new PlainJsonObjectMapping();
            this.bindJsonPlainObject(obj, intenralJsonObjectMapping, rootJsonObjectMapping);
            jsonObjectMapping.addMapping(jsonObjectMapping);
        }
        for (ConfigurationHelper arr : jsonObjectConf.getChildren("json-array")) {
            JsonArrayMapping jsonArrayMapping = new JsonArrayMapping();
            this.bindJsonArray(arr, jsonArrayMapping, rootJsonObjectMapping);
            jsonObjectMapping.addMapping(jsonArrayMapping);
        }
    }

    private void bindJsonContent(ConfigurationHelper jsonContentConf, JsonContentMapping jsonContentMapping) {
        String name = jsonContentConf.getAttribute("name", null);
        if (name != null) {
            name = this.valueLookup.lookupMetaDataName(name);
        }
        jsonContentMapping.setName(name);
        jsonContentMapping.setPath(new StaticPropertyPath(name));
        this.bindConverter(jsonContentConf, jsonContentMapping);
        String storeType = jsonContentConf.getAttribute("store", null);
        if (storeType != null) {
            jsonContentMapping.setStore(Property.Store.fromString(storeType));
        }
        jsonContentMapping.setInternal(true);
    }

    private void bindJsonProperty(ConfigurationHelper jsonPropConf, JsonPropertyMapping jsonPropertyMapping, AliasMapping aliasMapping) {
        String name = jsonPropConf.getAttribute("name", null);
        if (name != null) {
            name = this.valueLookup.lookupMetaDataName(name);
        }
        jsonPropertyMapping.setBoost(PlainMappingBinding.getBoost(jsonPropConf));
        jsonPropertyMapping.setName(name);
        String indexName = jsonPropConf.getAttribute("index-name", name);
        jsonPropertyMapping.setPath(indexName == null ? null : new StaticPropertyPath(indexName));
        this.bindConverter(jsonPropConf, jsonPropertyMapping);
        String format = jsonPropConf.getAttribute("format", null);
        if (format != null) {
            jsonPropertyMapping.setFormat(format);
            jsonPropertyMapping.setValueConverter(new FormatDelegateConverter(format));
        }
        String namingType = jsonPropConf.getAttribute("naming-type", JsonPropertyMapping.NamingType.PLAIN.toString());
        jsonPropertyMapping.setNamingType(JsonPropertyMapping.NamingType.fromString(namingType));
        this.bindResourcePropertyMapping(jsonPropConf, jsonPropertyMapping, aliasMapping);
        boolean override = jsonPropConf.getAttributeAsBoolean("override", false);
        jsonPropertyMapping.setOverrideByName(override);
        jsonPropertyMapping.setValueConverterName(jsonPropConf.getAttribute("value-converter", null));
        this.bindSpellCheck(jsonPropConf, jsonPropertyMapping);
    }

    private void bindXmlObject(ConfigurationHelper xmlObjectConf, XmlObjectMapping xmlObjectMapping) throws ConfigurationException {
        String aliasValue = xmlObjectConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            xmlObjectMapping.setAlias(aliasValue);
        } else {
            xmlObjectMapping.setAlias(alias.getName());
        }
        this.bindSubIndexHash(xmlObjectConf, xmlObjectMapping);
        this.bindExtends(xmlObjectConf, xmlObjectMapping);
        this.bindAll(xmlObjectConf, xmlObjectMapping);
        this.bindSpellCheck(xmlObjectConf, xmlObjectMapping);
        String analyzer = xmlObjectConf.getAttribute("analyzer", null);
        xmlObjectMapping.setAnalyzer(analyzer);
        xmlObjectMapping.setRoot(true);
        xmlObjectMapping.setBoost(PlainMappingBinding.getBoost(xmlObjectConf));
        xmlObjectMapping.setXPath(xmlObjectConf.getAttribute("xpath", null));
        this.bindConverter(xmlObjectConf, xmlObjectMapping);
        this.bindXmlObjectChildren(xmlObjectConf, xmlObjectMapping);
    }

    private void bindXmlObjectChildren(ConfigurationHelper resourceConf, InternalAliasMapping resourceMapping) {
        ConfigurationHelper boostConf;
        ConfigurationHelper analyzerConf;
        ConfigurationHelper[] properties;
        ConfigurationHelper[] ids;
        for (ConfigurationHelper id : ids = resourceConf.getChildren("xml-id", "id")) {
            XmlIdMapping xmlIdMapping = new XmlIdMapping();
            this.bindXmlProperty(id, xmlIdMapping, resourceMapping);
            resourceMapping.addMapping(xmlIdMapping);
        }
        for (ConfigurationHelper property : properties = resourceConf.getChildren("xml-property", "property")) {
            XmlPropertyMapping xmlPropertyMapping = new XmlPropertyMapping();
            this.bindXmlProperty(property, xmlPropertyMapping, resourceMapping);
            resourceMapping.addMapping(xmlPropertyMapping);
        }
        ConfigurationHelper xmlContentConf = resourceConf.getChild("xml-content", false);
        if (xmlContentConf == null) {
            xmlContentConf = resourceConf.getChild("content", false);
        }
        if (xmlContentConf != null) {
            XmlContentMapping xmlContentMapping = new XmlContentMapping();
            this.bindXmlContent(xmlContentConf, xmlContentMapping);
            resourceMapping.addMapping(xmlContentMapping);
        }
        if ((analyzerConf = resourceConf.getChild("xml-analyzer", false)) == null) {
            analyzerConf = resourceConf.getChild("analyzer", false);
        }
        if (analyzerConf != null) {
            XmlPropertyAnalyzerController analyzerController = new XmlPropertyAnalyzerController();
            this.bindXmlProperty(analyzerConf, analyzerController, resourceMapping);
            analyzerController.setNullAnalyzer(analyzerConf.getAttribute("null-analyzer", null));
            resourceMapping.addMapping(analyzerController);
        }
        if ((boostConf = resourceConf.getChild("xml-boost", false)) == null) {
            boostConf = resourceConf.getChild("boost", false);
        }
        if (boostConf != null) {
            XmlBoostPropertyMapping boostPropertyMapping = new XmlBoostPropertyMapping();
            this.bindXmlProperty(boostConf, boostPropertyMapping, resourceMapping);
            String defaultBoost = boostConf.getAttribute("default", null);
            if (defaultBoost != null) {
                boostPropertyMapping.setDefaultBoost(Float.parseFloat(defaultBoost));
            }
            resourceMapping.addMapping(boostPropertyMapping);
        }
    }

    private void bindXmlContent(ConfigurationHelper xmlContentConf, XmlContentMapping xmlContentMapping) {
        String name = xmlContentConf.getAttribute("name", null);
        if (name != null) {
            name = this.valueLookup.lookupMetaDataName(name);
        }
        xmlContentMapping.setName(name);
        xmlContentMapping.setPath(new StaticPropertyPath(name));
        this.bindConverter(xmlContentConf, xmlContentMapping);
        String storeType = xmlContentConf.getAttribute("store", null);
        xmlContentMapping.setStore(Property.Store.fromString(storeType));
        xmlContentMapping.setInternal(true);
    }

    private void bindXmlProperty(ConfigurationHelper xmlPropConf, XmlPropertyMapping xmlPropertyMapping, AliasMapping aliasMapping) {
        String name = xmlPropConf.getAttribute("name", null);
        if (name != null) {
            name = this.valueLookup.lookupMetaDataName(name);
        }
        xmlPropertyMapping.setBoost(PlainMappingBinding.getBoost(xmlPropConf));
        xmlPropertyMapping.setName(name);
        xmlPropertyMapping.setPath(name == null ? null : new StaticPropertyPath(name));
        this.bindConverter(xmlPropConf, xmlPropertyMapping);
        String format = xmlPropConf.getAttribute("format", null);
        if (format != null) {
            xmlPropertyMapping.setValueConverter(new FormatDelegateConverter(format));
        }
        this.bindResourcePropertyMapping(xmlPropConf, xmlPropertyMapping, aliasMapping);
        boolean override = xmlPropConf.getAttributeAsBoolean("override", true);
        xmlPropertyMapping.setOverrideByName(override);
        xmlPropertyMapping.setXPath(xmlPropConf.getAttribute("xpath"));
        xmlPropertyMapping.setValueConverterName(xmlPropConf.getAttribute("value-converter", null));
        this.bindSpellCheck(xmlPropConf, xmlPropertyMapping);
    }

    private void bindResourceContract(ConfigurationHelper contractConf, InternalContractMapping contractMapping) throws ConfigurationException {
        String aliasValue = contractConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            contractMapping.setAlias(aliasValue);
        } else {
            contractMapping.setAlias(alias.getName());
        }
        this.bindExtends(contractConf, contractMapping);
        this.bindResourceMappingChildren(contractConf, contractMapping);
    }

    private void bindResource(ConfigurationHelper resourceConf, RawResourceMapping rawResourceMapping) throws ConfigurationException {
        String aliasValue = resourceConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            rawResourceMapping.setAlias(aliasValue);
        } else {
            rawResourceMapping.setAlias(alias.getName());
        }
        this.bindSubIndexHash(resourceConf, rawResourceMapping);
        this.bindExtends(resourceConf, rawResourceMapping);
        String analyzer = resourceConf.getAttribute("analyzer", null);
        rawResourceMapping.setAnalyzer(analyzer);
        this.bindAll(resourceConf, rawResourceMapping);
        this.bindSpellCheck(resourceConf, rawResourceMapping);
        rawResourceMapping.setRoot(true);
        rawResourceMapping.setBoost(PlainMappingBinding.getBoost(resourceConf));
        this.bindResourceMappingChildren(resourceConf, rawResourceMapping);
    }

    private void bindResourceMappingChildren(ConfigurationHelper resourceConf, InternalAliasMapping resourceMapping) {
        ConfigurationHelper boostConf;
        ConfigurationHelper[] properties;
        ConfigurationHelper[] ids;
        for (ConfigurationHelper id : ids = resourceConf.getChildren("resource-id", "id")) {
            RawResourcePropertyIdMapping rawIdPropertyMapping = new RawResourcePropertyIdMapping();
            this.bindResourceProperty(id, rawIdPropertyMapping, resourceMapping);
            resourceMapping.addMapping(rawIdPropertyMapping);
        }
        for (ConfigurationHelper property : properties = resourceConf.getChildren("resource-property", "property")) {
            RawResourcePropertyMapping rawPropertyMapping = new RawResourcePropertyMapping();
            this.bindResourceProperty(property, rawPropertyMapping, resourceMapping);
            resourceMapping.addMapping(rawPropertyMapping);
        }
        ConfigurationHelper analyzerConf = resourceConf.getChild("resource-analyzer", false);
        if (analyzerConf == null) {
            analyzerConf = resourceConf.getChild("analyzer", false);
        }
        if (analyzerConf != null) {
            RawResourcePropertyAnalyzerController analyzerController = new RawResourcePropertyAnalyzerController();
            this.bindResourceProperty(analyzerConf, analyzerController, resourceMapping);
            analyzerController.setNullAnalyzer(analyzerConf.getAttribute("null-analyzer", null));
            resourceMapping.addMapping(analyzerController);
        }
        if ((boostConf = resourceConf.getChild("resource-boost", false)) == null) {
            boostConf = resourceConf.getChild("boost", false);
        }
        if (boostConf != null) {
            RawBoostPropertyMapping boostPropertyMapping = new RawBoostPropertyMapping();
            this.bindResourceProperty(boostConf, boostPropertyMapping, resourceMapping);
            String defaultBoost = boostConf.getAttribute("default", null);
            if (defaultBoost != null) {
                boostPropertyMapping.setDefaultBoost(Float.parseFloat(defaultBoost));
            }
            resourceMapping.addMapping(boostPropertyMapping);
        }
    }

    private void bindResourceProperty(ConfigurationHelper resourcePropConf, RawResourcePropertyMapping propertyMapping, AliasMapping aliasMapping) {
        String name = this.valueLookup.lookupMetaDataName(resourcePropConf.getAttribute("name"));
        propertyMapping.setBoost(PlainMappingBinding.getBoost(resourcePropConf));
        propertyMapping.setName(name);
        propertyMapping.setPath(new StaticPropertyPath(name));
        this.bindConverter(resourcePropConf, propertyMapping);
        String format = resourcePropConf.getAttribute("format", null);
        if (format != null) {
            propertyMapping.setConverter(new FormatDelegateConverter(format));
        }
        boolean override = resourcePropConf.getAttributeAsBoolean("override", true);
        propertyMapping.setOverrideByName(override);
        this.bindResourcePropertyMapping(resourcePropConf, propertyMapping, aliasMapping);
        this.bindSpellCheck(resourcePropConf, propertyMapping);
    }

    private void bindContract(ConfigurationHelper contractConf, InternalContractMapping contractMapping) throws ConfigurationException {
        String aliasValue = contractConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            contractMapping.setAlias(aliasValue);
        } else {
            contractMapping.setAlias(alias.getName());
        }
        this.bindExtends(contractConf, contractMapping);
        this.bindClassMappingChildren(contractConf, contractMapping);
    }

    private void bindClass(ConfigurationHelper classConf, ClassMapping classMapping, String defaultPackage) throws ConfigurationException {
        String filterDuplicates;
        String polyClassName;
        String className = classConf.getAttribute("name");
        classMapping.setName(defaultPackage + className);
        try {
            Class clazz = ClassUtils.forName(classMapping.getName(), this.settings.getClassLoader());
            classMapping.setClazz(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to find class [" + classMapping.getName() + "] and class loader [" + this.settings.getClassLoader() + "]");
        }
        String aliasValue = classConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            classMapping.setAlias(aliasValue);
        } else {
            classMapping.setAlias(alias.getName());
        }
        this.bindExtends(classConf, classMapping);
        this.bindSubIndexHash(classConf, classMapping);
        String analyzer = classConf.getAttribute("analyzer", null);
        classMapping.setAnalyzer(analyzer);
        this.bindAll(classConf, classMapping);
        this.bindSpellCheck(classConf, classMapping);
        boolean poly = classConf.getAttributeAsBoolean("poly", false);
        classMapping.setPoly(poly);
        String managedId = classConf.getAttribute("managed-id", null);
        if (managedId != null) {
            classMapping.setManagedId(ClassPropertyMapping.ManagedId.fromString(managedId));
        }
        if ((polyClassName = classConf.getAttribute("poly-class", null)) != null) {
            try {
                classMapping.setPolyClass(ClassUtils.forName(polyClassName, this.settings.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Failed to load polyClass [" + polyClassName + "]", e);
            }
        }
        boolean root = classConf.getAttributeAsBoolean("root", true);
        classMapping.setRoot(root);
        classMapping.setBoost(PlainMappingBinding.getBoost(classConf));
        String supportUnmarshall = classConf.getAttribute("support-unmarshall", null);
        if (supportUnmarshall != null) {
            if (supportUnmarshall.equalsIgnoreCase("true")) {
                classMapping.setSupportUnmarshall(true);
            } else {
                classMapping.setSupportUnmarshall(false);
            }
        }
        if ((filterDuplicates = classConf.getAttribute("filter-duplicates", null)) != null) {
            classMapping.setFilterDuplicates(filterDuplicates.equalsIgnoreCase("true"));
        }
        this.bindConverter(classConf, classMapping);
        this.bindClassMappingChildren(classConf, classMapping);
    }

    private void bindClassMappingChildren(ConfigurationHelper classConf, InternalAliasMapping classMapping) {
        ConfigurationHelper[] cascadeConfs;
        ConfigurationHelper[] dynamicConfs;
        ConfigurationHelper boostConf;
        ConfigurationHelper analyzerConf;
        ConfigurationHelper[] constants;
        ConfigurationHelper[] references;
        ConfigurationHelper[] components;
        ConfigurationHelper[] properties;
        ConfigurationHelper[] idComponents;
        ConfigurationHelper[] ids;
        for (ConfigurationHelper id : ids = classConf.getChildren("id")) {
            ClassIdPropertyMapping idMapping = new ClassIdPropertyMapping();
            this.bindClassProperty(id, classMapping, idMapping);
            classMapping.addMapping(idMapping);
        }
        for (ConfigurationHelper idComponent : idComponents = classConf.getChildren("id-component")) {
            IdComponentMapping idMapping = new IdComponentMapping();
            this.bindComponent(idComponent, classMapping, idMapping);
            classMapping.addMapping(idMapping);
        }
        for (ConfigurationHelper property : properties = classConf.getChildren("property")) {
            ClassPropertyMapping classPropertyMapping = new ClassPropertyMapping();
            this.bindClassProperty(property, classMapping, classPropertyMapping);
            classMapping.addMapping(classPropertyMapping);
        }
        for (ConfigurationHelper component : components = classConf.getChildren("component")) {
            ComponentMapping compMapping = new ComponentMapping();
            this.bindComponent(component, classMapping, compMapping);
            classMapping.addMapping(compMapping);
        }
        for (ConfigurationHelper reference : references = classConf.getChildren("reference")) {
            ReferenceMapping referenceMapping = new ReferenceMapping();
            this.bindReference(reference, classMapping, referenceMapping);
            classMapping.addMapping(referenceMapping);
        }
        for (ConfigurationHelper constant : constants = classConf.getChildren("constant")) {
            ConstantMetaDataMapping constantMapping = new ConstantMetaDataMapping();
            this.bindConstant(constant, classMapping, constantMapping);
            classMapping.addMapping(constantMapping);
        }
        ConfigurationHelper parentConf = classConf.getChild("parent", false);
        if (parentConf != null) {
            ParentMapping parentMapping = new ParentMapping();
            this.bindParent(parentConf, classMapping, parentMapping);
            classMapping.addMapping(parentMapping);
        }
        if ((analyzerConf = classConf.getChild("analyzer", false)) != null) {
            ClassPropertyAnalyzerController analyzerController = new ClassPropertyAnalyzerController();
            this.bindClassProperty(analyzerConf, classMapping, analyzerController);
            analyzerController.setNullAnalyzer(analyzerConf.getAttribute("null-analyzer", null));
            classMapping.addMapping(analyzerController);
        }
        if ((boostConf = classConf.getChild("boost", false)) != null) {
            ClassBoostPropertyMapping boostPropertyMapping = new ClassBoostPropertyMapping();
            this.bindClassProperty(boostConf, classMapping, boostPropertyMapping);
            String defaultBoost = boostConf.getAttribute("default", null);
            if (defaultBoost != null) {
                boostPropertyMapping.setDefaultBoost(Float.parseFloat(defaultBoost));
            }
            classMapping.addMapping(boostPropertyMapping);
        }
        for (ConfigurationHelper dynamicConf : dynamicConfs = classConf.getChildren("dynamic-meta-data")) {
            DynamicMetaDataMapping dynamicMetaDataMapping = new DynamicMetaDataMapping();
            this.bindDynamicMetaData(dynamicConf, classMapping, dynamicMetaDataMapping);
            classMapping.addMapping(dynamicMetaDataMapping);
        }
        for (ConfigurationHelper cascadeConf : cascadeConfs = classConf.getChildren("cascade")) {
            PlainCascadeMapping cascadeMapping = new PlainCascadeMapping();
            this.bindPlainCascading(cascadeConf, classMapping, cascadeMapping);
            classMapping.addMapping(cascadeMapping);
        }
    }

    private void bindPlainCascading(ConfigurationHelper conf, AliasMapping aliasMapping, PlainCascadeMapping cascadeMapping) {
        String name = conf.getAttribute("name");
        cascadeMapping.setName(name);
        cascadeMapping.setAccessor(conf.getAttribute("accessor", null));
        cascadeMapping.setPropertyName(name);
        cascadeMapping.setDefinedInAlias(aliasMapping.getAlias());
        this.bindConverter(conf, cascadeMapping);
        this.bindCascade(conf, cascadeMapping, "all");
    }

    private void bindDynamicMetaData(ConfigurationHelper dynamicConf, AliasMapping aliasMapping, DynamicMetaDataMapping dynamicMetaDataMapping) {
        String name = this.valueLookup.lookupMetaDataName(dynamicConf.getAttribute("name"));
        dynamicMetaDataMapping.setBoost(PlainMappingBinding.getBoost(dynamicConf));
        dynamicMetaDataMapping.setName(name);
        dynamicMetaDataMapping.setPath(new StaticPropertyPath(name));
        dynamicMetaDataMapping.setExpression(dynamicConf.getAttributeOrValue("expression").trim());
        dynamicMetaDataMapping.setFormat(dynamicConf.getAttribute("format", null));
        String type = dynamicConf.getAttribute("type", null);
        if (type != null) {
            try {
                dynamicMetaDataMapping.setType(ClassUtils.forName(type, this.settings.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Failed to find class [" + type + "]", e);
            }
        }
        this.bindConverter(dynamicConf, dynamicMetaDataMapping);
        this.bindSpellCheck(dynamicConf, dynamicMetaDataMapping);
        this.bindResourcePropertyMapping(dynamicConf, dynamicMetaDataMapping, aliasMapping);
        boolean override = dynamicConf.getAttributeAsBoolean("override", true);
        dynamicMetaDataMapping.setOverrideByName(override);
    }

    private void bindReference(ConfigurationHelper referenceConf, AliasMapping aliasMapping, ReferenceMapping referenceMapping) {
        String name = referenceConf.getAttribute("name");
        referenceMapping.setName(name);
        String refAlias = referenceConf.getAttribute("ref-alias", null);
        referenceMapping.setRefAliases(this.getAliases(refAlias));
        referenceMapping.setDefinedInAlias(aliasMapping.getAlias());
        String refCompAlias = referenceConf.getAttribute("ref-comp-alias", null);
        if (refCompAlias != null) {
            referenceMapping.setRefCompAlias(this.valueLookup.lookupAliasName(refCompAlias));
        }
        this.bindConverter(referenceConf, referenceMapping);
        referenceMapping.setAccessor(referenceConf.getAttribute("accessor", null));
        referenceMapping.setPropertyName(name);
        String sLazy = referenceConf.getAttribute("lazy", null);
        if (sLazy != null) {
            referenceMapping.setLazy(sLazy.equalsIgnoreCase("true"));
        }
        this.bindCascade(referenceConf, referenceMapping, null);
    }

    private void bindComponent(ConfigurationHelper componentConf, AliasMapping aliasMapping, ComponentMapping compMapping) {
        String name = componentConf.getAttribute("name");
        compMapping.setName(name);
        String refAlias = componentConf.getAttribute("ref-alias", null);
        compMapping.setRefAliases(this.getAliases(refAlias));
        compMapping.setDefinedInAlias(aliasMapping.getAlias());
        int maxDepth = componentConf.getAttributeAsInteger("max-depth", 1);
        compMapping.setMaxDepth(maxDepth);
        compMapping.setPrefix(componentConf.getAttribute("prefix", null));
        this.bindConverter(componentConf, compMapping);
        compMapping.setAccessor(componentConf.getAttribute("accessor", null));
        compMapping.setPropertyName(name);
        boolean override = componentConf.getAttributeAsBoolean("override", true);
        compMapping.setOverrideByName(override);
        this.bindCascade(componentConf, compMapping, null);
    }

    private void bindCascade(ConfigurationHelper refConf, InternalCascadeMapping cascadeMapping, String defaultValue) {
        String commaSeparatedCascades = refConf.getAttribute("cascade", defaultValue);
        if (commaSeparatedCascades == null) {
            return;
        }
        if ("none".equals(commaSeparatedCascades)) {
            return;
        }
        ArrayList<CascadeMapping.Cascade> cascades = new ArrayList<CascadeMapping.Cascade>();
        StringTokenizer st = new StringTokenizer(commaSeparatedCascades, ",");
        while (st.hasMoreTokens()) {
            String cascade = st.nextToken().trim();
            cascades.add(CascadeMapping.Cascade.fromString(cascade));
        }
        if (cascades.size() > 0) {
            cascadeMapping.setCascades(cascades.toArray(new CascadeMapping.Cascade[cascades.size()]));
        }
    }

    private void bindParent(ConfigurationHelper parentConf, AliasMapping aliasMapping, ParentMapping parentMapping) {
        String name = parentConf.getAttribute("name");
        parentMapping.setName(name);
        this.bindConverter(parentConf, parentMapping);
        parentMapping.setAccessor(parentConf.getAttribute("accessor", null));
        parentMapping.setPropertyName(name);
        parentMapping.setDefinedInAlias(aliasMapping.getAlias());
        this.bindCascade(parentConf, parentMapping, null);
    }

    private void bindClassProperty(ConfigurationHelper classPropertyConf, AliasMapping aliasMapping, ClassPropertyMapping classPropertyMapping) {
        ConfigurationHelper[] metadatas;
        String managedIdIndex;
        String name = classPropertyConf.getAttribute("name");
        classPropertyMapping.setName(name);
        String sClass = classPropertyConf.getAttribute("class", null);
        classPropertyMapping.setClassName(sClass);
        classPropertyMapping.setDefinedInAlias(aliasMapping.getAlias());
        classPropertyMapping.setBoost(PlainMappingBinding.getBoost(classPropertyConf));
        classPropertyMapping.setColClassName(classPropertyConf.getAttribute("col-class", null));
        classPropertyMapping.setAccessor(classPropertyConf.getAttribute("accessor", null));
        classPropertyMapping.setPropertyName(name);
        classPropertyMapping.setAnalyzer(classPropertyConf.getAttribute("analyzer", aliasMapping.getAnalyzer()));
        String excludeFromAll = classPropertyConf.getAttribute("exclude-from-all", "no");
        classPropertyMapping.setExcludeFromAll(ResourcePropertyMapping.ExcludeFromAllType.fromString(excludeFromAll));
        String managedId = classPropertyConf.getAttribute("managed-id", null);
        if (managedId != null) {
            classPropertyMapping.setManagedId(ClassPropertyMapping.ManagedId.fromString(managedId));
        }
        if ((managedIdIndex = classPropertyConf.getAttribute("managed-id-index", null)) != null) {
            classPropertyMapping.setManagedIdIndex(Property.Index.fromString(managedIdIndex));
        }
        classPropertyMapping.setManagedIdConverterName(classPropertyConf.getAttribute("managed-id-converter", null));
        boolean override = classPropertyConf.getAttributeAsBoolean("override", true);
        classPropertyMapping.setOverrideByName(override);
        this.bindConverter(classPropertyConf, classPropertyMapping);
        for (ConfigurationHelper metadata : metadatas = classPropertyConf.getChildren("meta-data")) {
            ClassPropertyMetaDataMapping mdMapping = new ClassPropertyMetaDataMapping();
            this.bindMetaData(metadata, aliasMapping, classPropertyMapping, mdMapping);
            classPropertyMapping.addMapping(mdMapping);
        }
    }

    private void bindConstant(ConfigurationHelper constantConf, AliasMapping classMapping, ConstantMetaDataMapping constantMapping) {
        ConfigurationHelper[] values;
        ConfigurationHelper metadataConf = constantConf.getChild("meta-data");
        if (!StringUtils.hasText(metadataConf.getAttributeOrValue("name"))) {
            throw new MappingException("Alias mapping [" + classMapping.getAlias() + "] has a constant mapping with an empty meta-data value");
        }
        String metaDataValue = metadataConf.getAttributeOrValue("name").trim();
        constantMapping.setName(this.valueLookup.lookupMetaDataName(metaDataValue));
        String excludeFromAll = constantConf.getAttribute("exclude-from-all", "no");
        constantMapping.setExcludeFromAll(ResourcePropertyMapping.ExcludeFromAllType.fromString(excludeFromAll));
        this.bindResourcePropertyMapping(metadataConf, constantMapping, 1.0f, constantMapping.getExcludeFromAll(), classMapping.getAnalyzer());
        this.bindSpellCheck(constantConf, constantMapping);
        boolean override = constantConf.getAttributeAsBoolean("override", true);
        constantMapping.setOverrideByName(override);
        for (ConfigurationHelper value : values = constantConf.getChildren("meta-data-value")) {
            String metaDataValueValue = value.getValue().trim();
            constantMapping.addMetaDataValue(this.valueLookup.lookupMetaDataValue(metaDataValueValue));
        }
    }

    private void bindMetaData(ConfigurationHelper metadataConf, AliasMapping aliasMapping, ClassPropertyMapping classPropertyMapping, ClassPropertyMetaDataMapping mdMapping) {
        String value = metadataConf.getAttributeOrValue("name").trim();
        if (!StringUtils.hasText(value)) {
            throw new MappingException("Alias mapping [" + aliasMapping.getAlias() + "] and property [" + classPropertyMapping.getName() + "] has a meta-data mapping with no value");
        }
        String name = this.valueLookup.lookupMetaDataName(value);
        mdMapping.setName(name);
        mdMapping.setPath(new StaticPropertyPath(name));
        mdMapping.setAccessor(classPropertyMapping.getAccessor());
        mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
        this.bindConverter(metadataConf, mdMapping);
        String format = metadataConf.getAttribute("format", null);
        if (mdMapping.getConverter() == null) {
            if (format == null) {
                format = this.valueLookup.lookupMetaDataFormat(value);
            }
            if (format != null) {
                mdMapping.setConverter(new FormatDelegateConverter(format));
            }
        } else if (format != null) {
            throw new ConfigurationException("Both converter and format are set for property [" + classPropertyMapping.getName() + "], you should choose one or the other (since converter will" + "not use the format defined)");
        }
        this.bindResourcePropertyMapping(metadataConf, mdMapping, classPropertyMapping.getBoost(), classPropertyMapping.getExcludeFromAll(), classPropertyMapping.getAnalyzer());
        this.bindSpellCheck(metadataConf, mdMapping);
    }

    private void bindExtends(ConfigurationHelper conf, InternalAliasMapping mapping) throws ConfigurationException {
        String extendsAliases = conf.getAttribute("extends", null);
        if (extendsAliases != null) {
            mapping.setExtendedAliases(this.getAliases(extendsAliases));
        }
    }

    private String[] getAliases(String commaSeparatedAliases) {
        if (commaSeparatedAliases == null) {
            return null;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(commaSeparatedAliases, ",");
        while (st.hasMoreTokens()) {
            String extendedAlias = st.nextToken().trim();
            Alias alias = this.valueLookup.lookupAlias(extendedAlias);
            if (alias == null) {
                aliases.add(extendedAlias);
                continue;
            }
            aliases.add(alias.getName());
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    private void bindConverter(ConfigurationHelper conf, InternalMapping mapping) {
        String converterName = conf.getAttribute("converter", null);
        mapping.setConverterName(converterName);
    }

    private void bindAll(ConfigurationHelper conf, AbstractResourceMapping resourceMapping) {
        ConfigurationHelper allConf = conf.getChild("all", false);
        DefaultAllMapping allMapping = new DefaultAllMapping();
        if (allConf != null) {
            String sIncludeUnmappedProperties;
            String sExcludeAlias;
            String sOmitTf;
            String sOmitNorms;
            String termVectorType;
            String sAllSupported = allConf.getAttribute("enable", null);
            if (sAllSupported != null) {
                allMapping.setSupported(sAllSupported.equalsIgnoreCase("true"));
            }
            if ((termVectorType = allConf.getAttribute("term-vector", null)) != null) {
                allMapping.setTermVector(Property.TermVector.fromString(termVectorType));
            }
            if ((sOmitNorms = allConf.getAttribute("omit-norms", null)) != null) {
                allMapping.setOmitNorms(sOmitNorms.equalsIgnoreCase("true"));
            }
            if ((sOmitTf = allConf.getAttribute("omit-tf", null)) != null) {
                allMapping.setOmitTf(sOmitTf.equalsIgnoreCase("true"));
            }
            if ((sExcludeAlias = allConf.getAttribute("exclude-alias", null)) != null) {
                allMapping.setExcludeAlias(sExcludeAlias.equalsIgnoreCase("true"));
            }
            if ((sIncludeUnmappedProperties = allConf.getAttribute("include-unmapped-properties", null)) != null) {
                allMapping.setIncludePropertiesWithNoMappings(sIncludeUnmappedProperties.equalsIgnoreCase("true"));
            }
            allMapping.setProperty(allConf.getAttribute("name", null));
            allMapping.setSpellCheck(SpellCheckType.fromString(allConf.getAttribute("spell-check", "na")));
        }
        resourceMapping.setAllMapping(allMapping);
    }

    private void bindSpellCheck(ConfigurationHelper conf, InternalResourcePropertyMapping mapping) {
        mapping.setSpellCheck(SpellCheckType.fromString(conf.getAttribute("spell-check", "na")));
    }

    private void bindSpellCheck(ConfigurationHelper conf, InternalResourceMapping mapping) {
        mapping.setSpellCheck(SpellCheckType.fromString(conf.getAttribute("spell-check", "na")));
    }

    private void bindSubIndexHash(ConfigurationHelper conf, AbstractResourceMapping resourceMapping) {
        SubIndexHash subIndexHash;
        ConfigurationHelper subIndexHashConf = conf.getChild("sub-index-hash", false);
        if (subIndexHashConf == null) {
            String subIndex = conf.getAttribute("sub-index", resourceMapping.getAlias());
            resourceMapping.setSubIndexHash(new ConstantSubIndexHash(subIndex));
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Alias [" + resourceMapping.getAlias() + "] is mapped to sub index hash [" + resourceMapping.getSubIndexHash() + "]"));
            }
            return;
        }
        String type = subIndexHashConf.getAttribute("type", null);
        try {
            subIndexHash = (SubIndexHash)ClassUtils.forName(type, this.settings.getClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create sub index hash of type [" + type + "]", e);
        }
        CompassSettings settings = this.settings.copy().clear();
        ConfigurationHelper[] settingsConf = subIndexHashConf.getChildren("setting");
        if (subIndexHash instanceof CompassConfigurable) {
            for (ConfigurationHelper aSettingsConf : settingsConf) {
                settings.setSetting(aSettingsConf.getAttribute("name"), aSettingsConf.getAttribute("value"));
            }
            ((CompassConfigurable)((Object)subIndexHash)).configure(settings);
        } else if (settingsConf.length < 0) {
            throw new ConfigurationException("Sub index hash [" + subIndexHash + "] does not implement " + "CompassConfigurable, but settings have been set for it");
        }
        resourceMapping.setSubIndexHash(subIndexHash);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Alias [" + resourceMapping.getAlias() + "] is mapped to sub index hash [" + resourceMapping.getSubIndexHash() + "]"));
        }
    }

    private void bindResourcePropertyMapping(ConfigurationHelper conf, InternalResourcePropertyMapping mapping, AliasMapping aliasMapping) {
        this.bindResourcePropertyMapping(conf, mapping, 1.0f, ResourcePropertyMapping.ExcludeFromAllType.NO, aliasMapping.getAnalyzer());
    }

    private void bindResourcePropertyMapping(ConfigurationHelper conf, InternalResourcePropertyMapping mapping, float defaultBoost, ResourcePropertyMapping.ExcludeFromAllType excludeFromAllType, String analyzer) {
        String omitTf;
        String omitNorms;
        String termVectorType;
        String indexType;
        mapping.setBoost(PlainMappingBinding.getBoost(conf, defaultBoost));
        String storeType = conf.getAttribute("store", null);
        if (storeType != null) {
            mapping.setStore(Property.Store.fromString(storeType));
        }
        if ((indexType = conf.getAttribute("index", null)) != null) {
            mapping.setIndex(Property.Index.fromString(indexType));
        }
        if ((termVectorType = conf.getAttribute("term-vector", null)) != null) {
            mapping.setTermVector(Property.TermVector.fromString(termVectorType));
        }
        if ((omitNorms = conf.getAttribute("omit-norms", null)) != null) {
            mapping.setOmitNorms(Boolean.valueOf(omitNorms));
        }
        if ((omitTf = conf.getAttribute("omit-tf", null)) != null) {
            mapping.setOmitTf(Boolean.valueOf(omitTf));
        }
        String reverseType = conf.getAttribute("reverse", "no");
        mapping.setReverse(ResourcePropertyMapping.ReverseType.fromString(reverseType));
        mapping.setAnalyzer(conf.getAttribute("analyzer", analyzer));
        mapping.setNullValue(conf.getAttribute("null-value", null));
        String excludeFromAll = conf.getAttribute("exclude-from-all", ResourcePropertyMapping.ExcludeFromAllType.toString(excludeFromAllType));
        mapping.setExcludeFromAll(ResourcePropertyMapping.ExcludeFromAllType.fromString(excludeFromAll));
        mapping.setInternal(false);
    }

    private static float getBoost(ConfigurationHelper conf) {
        return PlainMappingBinding.getBoost(conf, 1.0f);
    }

    private static float getBoost(ConfigurationHelper conf, float defaultBoost) {
        return conf.getAttributeAsFloat("boost", defaultBoost);
    }
}

