/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.InputStreamMappingResolver;
import org.compass.core.config.binding.MappingBinding;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.metadata.CompassMetaData;

public class CompassMappingBinding
implements MappingBinding {
    private List<MappingBinding> mappingBindings = new ArrayList<MappingBinding>();
    private InternalCompassMapping mapping;
    private String[] suffixes;

    public void addMappingBinding(MappingBinding mappingBinding) {
        this.mappingBindings.add(mappingBinding);
    }

    public void setUpBinding(InternalCompassMapping mapping, CompassMetaData metaData, CompassSettings settings) {
        this.mapping = mapping;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            mappingBinding.setUpBinding(mapping, metaData, settings);
        }
        HashSet<String> suffixes = new HashSet<String>();
        for (MappingBinding mappingBinding : this.mappingBindings) {
            if (mappingBinding.getSuffixes() == null) continue;
            suffixes.addAll(Arrays.asList(mappingBinding.getSuffixes()));
        }
        this.suffixes = suffixes.toArray(new String[suffixes.size()]);
    }

    public boolean addResourceMapping(ResourceMapping resourceMapping) throws ConfigurationException, MappingException {
        this.mapping.addMapping(resourceMapping);
        return true;
    }

    public boolean addResource(String path) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addResource(path);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addResource(String path, ClassLoader classLoader) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addResource(path, classLoader);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addURL(URL url) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addURL(url);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addDirectory(File dir) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addDirectory(dir);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addJar(File jar) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addJar(jar);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addFile(String filePath) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addFile(filePath);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addFile(File file) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addFile(file);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addPackage(String packageName) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addPackage(packageName);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addClass(Class clazz) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addClass(clazz);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addMappingResolver(InputStreamMappingResolver mappingResolver) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addMappingResolver(mappingResolver);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public boolean addInputStream(InputStream is, String resourceName) throws ConfigurationException, MappingException {
        boolean hasAddedResource = false;
        for (MappingBinding mappingBinding : this.mappingBindings) {
            boolean retVal = mappingBinding.addInputStream(is, resourceName);
            if (!retVal) continue;
            hasAddedResource = true;
        }
        return hasAddedResource;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }
}

