/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.accessor;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.accessor.BasicPropertyAccessor;
import org.compass.core.accessor.DirectPropertyAccessor;
import org.compass.core.accessor.PropertyAccessor;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.mapping.MappingException;
import org.compass.core.util.ClassUtils;

public class PropertyAccessorFactory
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog(PropertyAccessorFactory.class);
    private Map<String, PropertyAccessor> propertyAccessorsRegistry = new HashMap<String, PropertyAccessor>();

    public void configure(CompassSettings settings) throws CompassException {
        PropertyAccessor propertyAccessor = new BasicPropertyAccessor();
        if (propertyAccessor instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)propertyAccessor)).configure(settings);
        }
        this.propertyAccessorsRegistry.put("property", propertyAccessor);
        propertyAccessor = new DirectPropertyAccessor();
        if (propertyAccessor instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)propertyAccessor)).configure(settings);
        }
        this.propertyAccessorsRegistry.put("field", propertyAccessor);
        Map<String, CompassSettings> paGroups = settings.getSettingGroups("compass.propertyAccessor");
        for (Map.Entry<String, CompassSettings> entry : paGroups.entrySet()) {
            CompassSettings paSettings;
            String paName = entry.getKey();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property Accessor [" + paName + "] building..."));
            }
            if ((propertyAccessor = (PropertyAccessor)(paSettings = entry.getValue()).getSettingAsInstance("type")) == null) {
                throw new ConfigurationException("Must define type for property accessor [" + paName + "]");
            }
            if (propertyAccessor instanceof CompassConfigurable) {
                ((CompassConfigurable)((Object)propertyAccessor)).configure(settings);
            }
            this.propertyAccessorsRegistry.put(paName, propertyAccessor);
        }
    }

    public PropertyAccessor getPropertyAccessor(String type, CompassSettings settings) throws MappingException {
        Class accessorClass;
        if (type == null) {
            PropertyAccessor propertyAccessor = this.propertyAccessorsRegistry.get("default");
            if (propertyAccessor != null) {
                return propertyAccessor;
            }
            return this.propertyAccessorsRegistry.get("property");
        }
        PropertyAccessor propertyAccessor = this.propertyAccessorsRegistry.get(type);
        if (propertyAccessor != null) {
            return propertyAccessor;
        }
        try {
            accessorClass = ClassUtils.forName(type, settings.getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("Could not find PropertyAccessor class [" + type + "]", cnfe);
        }
        try {
            propertyAccessor = (PropertyAccessor)accessorClass.newInstance();
            if (propertyAccessor instanceof CompassConfigurable) {
                ((CompassConfigurable)((Object)propertyAccessor)).configure(settings);
            }
            return propertyAccessor;
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate PropertyAccessor class [" + type + "]", e);
        }
    }
}

