/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.compass.needle.gigaspaces.service.SearchResourceResult;

public class SearchResourceResults
implements Externalizable {
    private SearchResourceResult[] results;
    private long totalLength;

    public SearchResourceResults() {
    }

    public SearchResourceResults(SearchResourceResult[] results, long totalLength) {
        this.results = results;
        this.totalLength = totalLength;
    }

    public SearchResourceResult[] getResults() {
        return this.results;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public float getHighestScore() {
        if (this.results.length > 0) {
            return this.results[0].getScore();
        }
        return -1.0f;
    }

    public float getLowestScore() {
        if (this.results.length > 0) {
            return this.results[this.results.length - 1].getScore();
        }
        return -1.0f;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.results.length);
        for (int i = 0; i < this.results.length; ++i) {
            out.writeObject(this.results[i]);
        }
        out.writeLong(this.totalLength);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int resultCount = in.readInt();
        this.results = new SearchResourceResult[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            this.results[i] = (SearchResourceResult)in.readObject();
        }
        this.totalLength = in.readLong();
    }
}

