/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalPut;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.compass.needle.coherence.FileLockKey;

public class InvocableCoherenceLockFactory
extends LockFactory {
    private static final Log log = LogFactory.getLog(InvocableCoherenceLockFactory.class);
    private NamedCache cache;
    private String indexName;

    public InvocableCoherenceLockFactory(NamedCache cache, String indexName) {
        this.cache = cache;
        this.indexName = indexName;
    }

    public void clearLock(String lockName) throws IOException {
        this.cache.remove((Object)new FileLockKey(this.indexName, lockName));
    }

    public Lock makeLock(String lockName) {
        return new CoherenceLock(lockName);
    }

    public class CoherenceLock
    extends Lock {
        private FileLockKey fileLock;

        public CoherenceLock(String lockName) {
            this.fileLock = new FileLockKey(InvocableCoherenceLockFactory.this.indexName, lockName);
        }

        public boolean isLocked() {
            return InvocableCoherenceLockFactory.this.cache.containsKey((Object)this.fileLock);
        }

        public boolean obtain() throws IOException {
            Integer isLocked = (Integer)InvocableCoherenceLockFactory.this.cache.invoke((Object)this.fileLock, (InvocableMap.EntryProcessor)new ConditionalPut((Filter)new NotFilter((Filter)PresentFilter.INSTANCE), (Object)1, true));
            return isLocked == null;
        }

        public void release() {
            block2: {
                try {
                    InvocableCoherenceLockFactory.this.cache.remove((Object)this.fileLock);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block2;
                    log.warn((Object)("Failed to release lock on index [" + InvocableCoherenceLockFactory.this.indexName + "]"), (Throwable)e);
                }
            }
        }
    }
}

