/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import com.tangosol.io.ExternalizableLite;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.compass.needle.coherence.FileKey;

public class FileHeaderKey
implements FileKey,
ExternalizableLite {
    private String indexName;
    private String fileName;

    public FileHeaderKey() {
    }

    public FileHeaderKey(String indexName, String fileName) {
        this.indexName = indexName;
        this.fileName = fileName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte getType() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (((FileKey)o).getType() != this.getType()) {
            return false;
        }
        FileHeaderKey that = (FileHeaderKey)o;
        if (!this.fileName.equals(that.fileName)) {
            return false;
        }
        return this.indexName.equals(that.indexName);
    }

    public int hashCode() {
        int result = this.getType();
        result = 31 * result + this.indexName.hashCode();
        result = 31 * result + this.fileName.hashCode();
        return result;
    }

    public void readExternal(DataInput in) throws IOException {
        this.indexName = in.readUTF();
        this.fileName = in.readUTF();
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.indexName);
        out.writeUTF(this.fileName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("fileHeaderKey: indexName[").append(this.indexName).append("]");
        sb.append(" fileName[").append(this.fileName).append("]");
        return sb.toString();
    }
}

