/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.embedded.toplink;

import java.util.Properties;
import java.util.Vector;
import javax.persistence.EntityManagerFactory;
import oracle.toplink.essentials.ejb.cmp3.EntityManager;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.essentials.sessions.UnitOfWork;
import oracle.toplink.essentials.threetier.ServerSession;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.embedded.DefaultJpaCompassGps;
import org.compass.gps.device.jpa.embedded.JpaCompassGps;
import org.compass.gps.device.jpa.embedded.toplink.CompassSessionEventListener;
import org.compass.gps.device.jpa.support.NativeJpaHelper;

public abstract class TopLinkHelper {
    private TopLinkHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Compass getCompass(EntityManagerFactory emf) {
        javax.persistence.EntityManager em = emf.createEntityManager();
        try {
            Compass compass = TopLinkHelper.getCompass(em);
            return compass;
        }
        finally {
            em.close();
        }
    }

    public static Compass getCompass(javax.persistence.EntityManager em) {
        return TopLinkHelper.findCompassSessionEventListener(em).getCompass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getIndexSettings(EntityManagerFactory emf) {
        javax.persistence.EntityManager em = emf.createEntityManager();
        try {
            Properties properties = TopLinkHelper.getIndexSettings(em);
            return properties;
        }
        finally {
            em.close();
        }
    }

    public static Properties getIndexSettings(javax.persistence.EntityManager em) {
        return TopLinkHelper.findCompassSessionEventListener(em).getIndexSettings();
    }

    public static CompassSession getCurrentCompassSession(javax.persistence.EntityManager em) {
        ServerSession serverSession = ((EntityManager)NativeJpaHelper.extractNativeJpa(em)).getServerSession();
        UnitOfWork session = ((EntityManager)em).getUnitOfWork();
        return TopLinkHelper.findCompassSessionEventListener((Session)serverSession).getCurrentCompassSession((Session)session);
    }

    public static CompassSession getCurrentCompassSession(Session session) {
        return TopLinkHelper.findCompassSessionEventListener(session).getCurrentCompassSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JpaCompassGps getCompassGps(EntityManagerFactory emf) {
        javax.persistence.EntityManager em = emf.createEntityManager();
        try {
            JpaCompassGps jpaCompassGps = TopLinkHelper.getCompassGps(em);
            return jpaCompassGps;
        }
        finally {
            em.close();
        }
    }

    public static JpaCompassGps getCompassGps(javax.persistence.EntityManager em) {
        return TopLinkHelper.findCompassSessionEventListener(em).getJpaCompassGps();
    }

    public static JpaCompassGps createCompassGps(JpaGpsDevice device) {
        DefaultJpaCompassGps gps = new DefaultJpaCompassGps(TopLinkHelper.getCompass(device.getEntityManagerFactory()));
        device.setMirrorDataChanges(false);
        gps.setIndexProperties(TopLinkHelper.getIndexSettings(device.getEntityManagerFactory()));
        gps.addGpsDevice(device);
        return gps;
    }

    private static CompassSessionEventListener findCompassSessionEventListener(javax.persistence.EntityManager em) throws CompassException {
        return TopLinkHelper.findCompassSessionEventListener((Session)((EntityManager)NativeJpaHelper.extractNativeJpa(em)).getServerSession());
    }

    private static CompassSessionEventListener findCompassSessionEventListener(Session session) throws CompassException {
        Vector listeners = session.getEventManager().getListeners();
        for (Object o : listeners) {
            if (!(o instanceof CompassSessionEventListener)) continue;
            return (CompassSessionEventListener)((Object)o);
        }
        throw new CompassException("Failed to find CompassSessionEventListener, have you configured Compass with TopLink?");
    }
}

