/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate;

import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransaction;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.TransactionFactory;
import org.compass.gps.device.hibernate.HibernateSyncTransactionFactory;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.SessionImplementor;

public class HibernateSyncTransaction
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog(HibernateSyncTransaction.class);
    private SessionFactory sessionFactory;
    private boolean newTransaction;
    private boolean controllingNewTransaction = false;
    private InternalCompassSession session;
    private boolean commitFailed;
    private boolean commitBeforeCompletion;
    private Transaction transaction;

    public HibernateSyncTransaction(SessionFactory sessionFactory, boolean commitBeforeCompletion, TransactionFactory transactionFactory) {
        super(transactionFactory);
        this.sessionFactory = sessionFactory;
        this.commitBeforeCompletion = commitBeforeCompletion;
    }

    public void begin(InternalCompassSession session, CompassTransaction.TransactionIsolation transactionIsolation) throws CompassException {
        this.session = session;
        try {
            this.controllingNewTransaction = true;
            this.newTransaction = !((SessionImplementor)this.sessionFactory.getCurrentSession()).isTransactionInProgress();
            this.transaction = this.sessionFactory.getCurrentSession().getTransaction();
            if (this.newTransaction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Beginning new Hibernate transaction, and a new compass transaction on thread [" + Thread.currentThread().getName() + "] with isolation [" + transactionIsolation + "]"));
                }
                session.getSearchEngine().begin(transactionIsolation);
                this.transaction.begin();
            } else {
                session.getSearchEngine().begin(transactionIsolation);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Joining an existing Hibernate transaction, starting a new compass transaction on thread [" + Thread.currentThread().getName() + "] with isolation [" + transactionIsolation + "]"));
                }
            }
            this.transaction.registerSynchronization((Synchronization)new HibernateTransactionSynchronization(session, this.transaction, this.newTransaction, this.commitBeforeCompletion, this.transactionFactory));
        }
        catch (Exception e) {
            throw new TransactionException("Begin failed with exception", e);
        }
        this.setBegun(true);
    }

    public void join(InternalCompassSession session) throws CompassException {
        this.session = session;
        this.controllingNewTransaction = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Joining an existing compass transcation on thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    protected void doCommit() throws CompassException {
        if (!this.controllingNewTransaction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not committing Hibernate transaction since compass does not control it on thread [" + Thread.currentThread().getName() + "]"));
            }
            return;
        }
        if (this.newTransaction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing Hibernate transaction controlled by compass on thread [" + Thread.currentThread().getName() + "]"));
            }
            try {
                this.transaction.commit();
            }
            catch (Exception e) {
                this.commitFailed = true;
                throw new TransactionException("Commit failed", e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Commit called, let Hibernate synchronization commit the transaciton on thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    protected void doRollback() throws CompassException {
        try {
            if (this.newTransaction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rolling back Hibernate transaction controlled by compass on thread [" + Thread.currentThread().getName() + "]"));
                }
                if (!this.commitFailed) {
                    this.transaction.rollback();
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Marking Hibernate transaction as rolled back since compass controlls it on thread [" + Thread.currentThread().getName() + "]"));
            }
        }
        catch (Exception e) {
            throw new TransactionException("Rollback failed with exception", e);
        }
    }

    public boolean wasRolledBack() throws TransactionException {
        if (!this.isBegun()) {
            return false;
        }
        if (this.commitFailed) {
            return true;
        }
        return this.transaction.wasRolledBack();
    }

    public boolean wasCommitted() throws TransactionException {
        if (!this.isBegun() || this.commitFailed) {
            return false;
        }
        return this.transaction.wasCommitted();
    }

    public CompassSession getSession() {
        return this.session;
    }

    private static class HibernateTransactionSynchronization
    implements Synchronization {
        private static final Log log = LogFactory.getLog(HibernateTransactionSynchronization.class);
        private InternalCompassSession session;
        private Transaction tx;
        private boolean compassControlledHibernateTransaction;
        private boolean commitBeforeCompletion;
        private TransactionFactory transactionFactory;

        public HibernateTransactionSynchronization(InternalCompassSession session, Transaction tx, boolean compassControlledHibernateTransaction, boolean commitBeforeCompletion, TransactionFactory transactionFactory) {
            this.transactionFactory = transactionFactory;
            this.session = session;
            this.tx = tx;
            this.compassControlledHibernateTransaction = compassControlledHibernateTransaction;
            this.commitBeforeCompletion = commitBeforeCompletion;
        }

        public void beforeCompletion() {
            if (!this.commitBeforeCompletion) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing compass transaction using Hibernate synchronization beforeCompletion on thread [" + Thread.currentThread().getName() + "]"));
            }
            this.session.getSearchEngine().commit(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (!this.commitBeforeCompletion) {
                    if (status == 3) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Committing compass transaction using Hibernate synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                        }
                        this.session.getSearchEngine().commit(true);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Rolling back compass transaction using Hibernate synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                        }
                        this.session.getSearchEngine().rollback();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured when sync with transaction", (Throwable)e);
            }
            finally {
                this.session.evictAll();
                ((HibernateSyncTransactionFactory)this.transactionFactory).unbindSessionFromTransaction(this.tx);
                if (!this.compassControlledHibernateTransaction) {
                    this.session.close();
                }
            }
        }
    }
}

