/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.reflection.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.compass.core.util.asm.ClassWriter;
import org.compass.core.util.asm.MethodVisitor;
import org.compass.core.util.asm.Type;
import org.compass.core.util.reflection.ReflectionConstructor;

public class AsmReflectionConstructorGenerator {
    private static final String OBJECT_INTERNAL_NAME = Type.getInternalName(Object.class);
    private static final String[] REFLECTIONCONSTRUCTOR_INTERNAL_NAME = new String[]{Type.getInternalName(ReflectionConstructor.class)};

    public static synchronized ReflectionConstructor generateConstructor(Constructor originalCtor) throws NoSuchMethodException {
        int ctorIndex;
        Class declaringClass = originalCtor.getDeclaringClass();
        String ownerClassName = declaringClass.getName();
        Constructor<?>[] declaredCtors = declaringClass.getDeclaredConstructors();
        for (ctorIndex = 0; ctorIndex < declaredCtors.length && !declaredCtors[ctorIndex].equals(originalCtor); ++ctorIndex) {
        }
        String className = ownerClassName + "ConstReflection" + ctorIndex;
        try {
            Class definedClass;
            try {
                definedClass = declaringClass.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                String classInternalName = className.replace('.', '/');
                ClassWriter cw = new ClassWriter(1);
                cw.visit(48, 33, classInternalName, null, OBJECT_INTERNAL_NAME, REFLECTIONCONSTRUCTOR_INTERNAL_NAME);
                AsmReflectionConstructorGenerator.createConstructor(cw);
                AsmReflectionConstructorGenerator.createNewInstanceMethod(cw, declaringClass);
                cw.visitEnd();
                byte[] b = cw.toByteArray();
                definedClass = AsmReflectionConstructorGenerator.defineClass(declaringClass.getClassLoader(), className, b);
            }
            return (ReflectionConstructor)definedClass.newInstance();
        }
        catch (Exception e) {
            NoSuchMethodException ex = new NoSuchMethodException("Can't create ASM constructor reflection helper for [" + originalCtor + "]");
            ex.initCause(e);
            throw ex;
        }
    }

    private static void createConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void createNewInstanceMethod(ClassWriter cw, Class clz) {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(clz));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(clz), "<init>", "()V");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private static Class defineClass(ClassLoader loader, String name, byte[] b) throws Exception {
        Method defineMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        defineMethod.setAccessible(true);
        return (Class)defineMethod.invoke((Object)loader, name, b, 0, b.length);
    }
}

