/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.readcommitted;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;

public class TransIndex
implements CompassConfigurable {
    private static Random transId = new Random();
    private static final String DEFAULT_LOCATION = System.getProperty("java.io.tmpdir") + "/compass/translog";
    private LuceneSearchEngineFactory searchEngineFactory;
    private String subIndex;
    private Directory directory;
    private IndexWriter indexWriter;
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private boolean flushRequired = false;
    private boolean optimize;

    public TransIndex(LuceneSearchEngineFactory searchEngineFactory, String subIndex) {
        this.searchEngineFactory = searchEngineFactory;
        this.subIndex = subIndex;
    }

    public void configure(CompassSettings settings) throws CompassException {
        try {
            String transLogConnection = settings.getSetting("compass.transaction.readcommitted.translog.connection", "ram://");
            if ("ram://".equals(transLogConnection)) {
                this.directory = new RAMDirectory();
            } else {
                if (transLogConnection.equals("file://")) {
                    transLogConnection = DEFAULT_LOCATION;
                } else if (transLogConnection.startsWith("file://")) {
                    transLogConnection = transLogConnection.substring("file://".length());
                }
                transLogConnection = transLogConnection + "/" + transId.nextLong();
                this.directory = FSDirectory.getDirectory((String)transLogConnection);
            }
            this.directory.setLockFactory((LockFactory)NoLockFactory.getNoLockFactory());
            this.indexWriter = this.searchEngineFactory.getLuceneIndexManager().openIndexWriter(settings, this.directory, true, true, (IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
            this.optimize = settings.getSettingAsBoolean("compass.transaction.readcommitted.translog.optimize", true);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open transactional index for sub index [" + this.subIndex + "]", e);
        }
    }

    public void create(InternalResource resource, Analyzer analyzer) throws IOException {
        this.indexWriter.addDocument(((LuceneResource)resource).getDocument(), analyzer);
        this.flushRequired = true;
    }

    public void update(InternalResource resource, Analyzer analyzer) throws IOException {
        this.indexWriter.updateDocument(new Term(resource.resourceKey().getUIDPath(), resource.resourceKey().buildUID()), ((LuceneResource)resource).getDocument(), analyzer);
        this.flushRequired = true;
    }

    public void delete(ResourceKey resourceKey) throws IOException {
        this.indexWriter.deleteDocuments(new Term(resourceKey.getUIDPath(), resourceKey.buildUID()));
        this.flushRequired = true;
    }

    public IndexReader getReader() throws IOException {
        this.refreshIfNeeded();
        return this.indexReader;
    }

    public IndexSearcher getSearcher() throws IOException {
        this.refreshIfNeeded();
        return this.indexSearcher;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void commit() throws IOException {
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
        }
        if (this.indexReader != null) {
            this.indexReader.close();
        }
        if (this.optimize) {
            this.indexWriter.optimize();
        }
        this.indexWriter.close();
        this.indexWriter = null;
    }

    public void close() throws IOException {
        this.directory.close();
    }

    private void refreshIfNeeded() throws IOException {
        if (this.flushRequired) {
            if (this.indexWriter != null) {
                this.indexWriter.commit();
            }
            if (this.indexReader == null) {
                this.indexReader = IndexReader.open((Directory)this.directory, (boolean)true);
                this.indexSearcher = this.searchEngineFactory.getLuceneIndexManager().openIndexSearcher(this.indexReader);
            } else {
                IndexReader tmpReader = this.indexReader.reopen();
                if (tmpReader != this.indexReader) {
                    this.indexReader.close();
                    this.indexSearcher.close();
                    this.indexSearcher = this.searchEngineFactory.getLuceneIndexManager().openIndexSearcher(tmpReader);
                }
                this.indexReader = tmpReader;
            }
            this.flushRequired = false;
        }
    }
}

