/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import java.io.IOException;
import org.apache.lucene.index.LuceneSubIndexInfo;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.AbstractOptimizer;

public abstract class AbstractIndexInfoOptimizer
extends AbstractOptimizer {
    protected void doOptimize(String subIndex) throws SearchEngineException {
        LuceneSubIndexInfo indexInfo = this.doGetIndexInfo(subIndex);
        if (indexInfo == null) {
            return;
        }
        this.doOptimize(subIndex, indexInfo);
    }

    protected void doForceOptimize(String subIndex) throws SearchEngineException {
        LuceneSubIndexInfo indexInfo = this.doGetIndexInfo(subIndex);
        if (indexInfo == null) {
            return;
        }
        this.doForceOptimize(subIndex, indexInfo);
    }

    protected LuceneSubIndexInfo doGetIndexInfo(String subIndex) {
        LuceneSubIndexInfo indexInfo;
        LuceneSearchEngineIndexManager indexManager = this.getSearchEngineFactory().getLuceneIndexManager();
        try {
            indexInfo = LuceneSubIndexInfo.getIndexInfo(subIndex, indexManager);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to read index info for sub index [" + subIndex + "]", e);
        }
        if (indexInfo == null) {
            return null;
        }
        if (!this.isRunning()) {
            return null;
        }
        return indexInfo;
    }

    protected abstract void doOptimize(String var1, LuceneSubIndexInfo var2) throws SearchEngineException;

    protected abstract void doForceOptimize(String var1, LuceneSubIndexInfo var2) throws SearchEngineException;
}

