/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneUtils;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.executor.ExecutorManager;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.merge.policy.MergePolicyFactory;
import org.compass.core.lucene.engine.merge.scheduler.MergeSchedulerFactory;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.transaction.context.TransactionContext;
import org.compass.core.transaction.context.TransactionContextCallback;

public class DefaultLuceneSearchEngineIndexManager
implements LuceneSearchEngineIndexManager {
    private static Log log = LogFactory.getLog(DefaultLuceneSearchEngineIndexManager.class);
    public static final String CLEAR_CACHE_NAME = "clearcache";
    private LuceneSearchEngineFactory searchEngineFactory;
    private LuceneSearchEngineStore searchEngineStore;
    private LuceneSettings luceneSettings;
    private Map<String, LuceneIndexHolder> indexHolders = new ConcurrentHashMap<String, LuceneIndexHolder>();
    private Map<String, Object> subIndexLocks = new HashMap<String, Object>();
    private long[] lastModifiled;
    private long waitForCacheInvalidationBeforeSecondStep = 0L;
    private boolean cacheAsyncInvalidation;
    private volatile boolean isRunning = false;
    private ScheduledFuture scheduledIndexManagerFuture;
    private ScheduledFuture scheduledRefreshCacheFuture;

    public DefaultLuceneSearchEngineIndexManager(LuceneSearchEngineFactory searchEngineFactory, LuceneSearchEngineStore searchEngineStore) {
        String[] subIndexes;
        this.searchEngineFactory = searchEngineFactory;
        this.searchEngineStore = searchEngineStore;
        this.luceneSettings = searchEngineFactory.getLuceneSettings();
        for (String subIndex : subIndexes = searchEngineStore.getSubIndexes()) {
            this.subIndexLocks.put(subIndex, new Object());
        }
    }

    public void createIndex() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating index " + this.searchEngineStore));
        }
        this.clearCache();
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.createIndex();
                return null;
            }
        });
    }

    public void deleteIndex() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting index " + this.searchEngineStore));
        }
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.clearCache();
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.deleteIndex();
                return null;
            }
        });
    }

    public void cleanIndex() throws SearchEngineException {
        for (String subIndex : this.getSubIndexes()) {
            this.cleanIndex(subIndex);
        }
    }

    public void cleanIndex(final String subIndex) throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean doInTransaction() throws CompassException {
                Object v = DefaultLuceneSearchEngineIndexManager.this.subIndexLocks.get(subIndex);
                synchronized (v) {
                    DefaultLuceneSearchEngineIndexManager.this.clearCache(subIndex);
                    DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.cleanIndex(subIndex);
                    return null;
                }
            }
        });
    }

    public boolean verifyIndex() throws SearchEngineException {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.clearCache();
                return DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.verifyIndex();
            }
        });
    }

    public boolean indexExists() throws SearchEngineException {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                return DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.indexExists();
            }
        });
    }

    public void operate(final SearchEngineIndexManager.IndexOperationCallback callback) throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.doOperate(callback);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOperate(SearchEngineIndexManager.IndexOperationCallback callback) throws SearchEngineException {
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        if (callback instanceof SearchEngineIndexManager.IndexOperationPlan) {
            SearchEngineIndexManager.IndexOperationPlan plan = (SearchEngineIndexManager.IndexOperationPlan)((Object)callback);
            subIndexes = this.searchEngineStore.polyCalcSubIndexes(plan.getSubIndexes(), plan.getAliases(), plan.getTypes());
        }
        Lock[] writerLocks = new Lock[subIndexes.length];
        try {
            boolean continueToSecondStep;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to obtain write locks");
                }
                for (int i = 0; i < subIndexes.length; ++i) {
                    Directory dir = this.getDirectory(subIndexes[i]);
                    writerLocks[i] = dir.makeLock("write.lock");
                    writerLocks[i].obtain(this.luceneSettings.getTransactionLockTimout());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Obtained write locks");
                }
            }
            catch (Exception e) {
                throw new SearchEngineException("Failed to retrieve dirty transaction locks", e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling callback first step");
            }
            if (!(continueToSecondStep = callback.firstStep())) {
                return;
            }
            this.clearCache();
            this.notifyAllToClearCache();
            if (this.waitForCacheInvalidationBeforeSecondStep != 0L && this.luceneSettings.isWaitForCacheInvalidationOnIndexOperation()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Waiting [" + this.waitForCacheInvalidationBeforeSecondStep + "ms] for global cache invalidation"));
                    }
                    Thread.sleep(this.waitForCacheInvalidationBeforeSecondStep);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Interrupted while waiting for cache invalidation", (Throwable)e);
                    throw new SearchEngineException("Interrupted while waiting for cache invalidation", e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling callback second step");
            }
            callback.secondStep();
        }
        finally {
            org.compass.core.lucene.util.LuceneUtils.clearLocks(writerLocks);
        }
    }

    public void replaceIndex(final SearchEngineIndexManager indexManager, final SearchEngineIndexManager.ReplaceIndexCallback callback) throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.doReplaceIndex(indexManager, callback);
                return null;
            }
        });
    }

    protected void doReplaceIndex(SearchEngineIndexManager indexManager, SearchEngineIndexManager.ReplaceIndexCallback callback) throws SearchEngineException {
        LuceneSearchEngineIndexManager luceneIndexManager = (LuceneSearchEngineIndexManager)indexManager;
        this.doOperate(new ReplaceIndexOperationCallback(luceneIndexManager, callback));
    }

    public void notifyAllToClearCache() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Global notification to clear cache");
        }
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                for (String subIndex : DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.getSubIndexes()) {
                    Directory dir = DefaultLuceneSearchEngineIndexManager.this.getDirectory(subIndex);
                    try {
                        if (!dir.fileExists(DefaultLuceneSearchEngineIndexManager.CLEAR_CACHE_NAME)) {
                            dir.createOutput(DefaultLuceneSearchEngineIndexManager.CLEAR_CACHE_NAME).close();
                            continue;
                        }
                        dir.touchFile(DefaultLuceneSearchEngineIndexManager.CLEAR_CACHE_NAME);
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to update/generate global invalidation cahce", e);
                    }
                }
                return null;
            }
        });
    }

    public boolean isCached(String subIndex) throws SearchEngineException {
        return this.indexHolders.containsKey(subIndex);
    }

    public boolean isCached() throws SearchEngineException {
        String[] subIndexes;
        for (String subIndex : subIndexes = this.searchEngineStore.getSubIndexes()) {
            if (!this.isCached(subIndex)) continue;
            return true;
        }
        return false;
    }

    public void clearCache() throws SearchEngineException {
        for (String subIndex : this.searchEngineStore.getSubIndexes()) {
            this.clearCache(subIndex);
        }
    }

    public void clearCache(String subIndex) throws SearchEngineException {
        LuceneIndexHolder indexHolder = this.indexHolders.remove(subIndex);
        if (indexHolder != null) {
            indexHolder.markForClose();
        }
    }

    public void refreshCache() throws SearchEngineException {
        for (String subIndex : this.searchEngineStore.getSubIndexes()) {
            this.refreshCache(subIndex);
        }
    }

    public void refreshCache(final String subIndex) throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.internalRefreshCache(subIndex);
                return null;
            }
        });
    }

    private LuceneIndexHolder internalRefreshCache(String subIndex) throws SearchEngineException {
        LuceneIndexHolder indexHolder;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Refreshing cache for sub index [" + subIndex + "]"));
        }
        if ((indexHolder = this.indexHolders.get(subIndex)) != null) {
            IndexReader reader;
            try {
                reader = indexHolder.getIndexReader().reopen();
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to refresh sub index cache [" + subIndex + "]", e);
            }
            if (reader != indexHolder.getIndexReader()) {
                indexHolder.markForClose();
                indexHolder = new LuceneIndexHolder(subIndex, this.openIndexSearcher(reader));
                LuceneIndexHolder oldHolder = this.indexHolders.put(subIndex, indexHolder);
                if (oldHolder != null) {
                    oldHolder.markForClose();
                }
            }
        } else {
            try {
                IndexReader reader = IndexReader.open((Directory)this.getDirectory(subIndex), (boolean)true);
                indexHolder = new LuceneIndexHolder(subIndex, this.openIndexSearcher(reader));
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to open sub index cache [" + subIndex + "]", e);
            }
            LuceneIndexHolder oldHolder = this.indexHolders.put(subIndex, indexHolder);
            if (oldHolder != null) {
                oldHolder.markForClose();
            }
        }
        return indexHolder;
    }

    public void refreshCache(String subIndex, IndexSearcher indexSearcher) throws SearchEngineException {
        LuceneIndexHolder indexHolder = new LuceneIndexHolder(subIndex, indexSearcher);
        LuceneIndexHolder oldHolder = this.indexHolders.put(subIndex, indexHolder);
        if (oldHolder != null) {
            oldHolder.markForClose();
        }
    }

    public LuceneIndexHolder openIndexHolderBySubIndex(String subIndex) throws SearchEngineException {
        try {
            LuceneIndexHolder indexHolder = this.indexHolders.get(subIndex);
            if (this.cacheAsyncInvalidation) {
                if (indexHolder == null) {
                    indexHolder = this.internalRefreshCache(subIndex);
                }
            } else if (this.shouldInvalidateCache(indexHolder)) {
                indexHolder = this.internalRefreshCache(subIndex);
            }
            while (!indexHolder.acquire()) {
                indexHolder = this.indexHolders.get(subIndex);
            }
            return indexHolder;
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to open index searcher for sub-index [" + subIndex + "]", e);
        }
    }

    protected boolean shouldInvalidateCache(LuceneIndexHolder indexHolder) throws IOException {
        long currentTime = System.currentTimeMillis();
        if (indexHolder == null) {
            return true;
        }
        if (this.luceneSettings.getCacheInvalidationInterval() == -1L) {
            return false;
        }
        if (currentTime - indexHolder.getLastCacheInvalidation() > this.luceneSettings.getCacheInvalidationInterval()) {
            indexHolder.setLastCacheInvalidation(currentTime);
            try {
                if (!indexHolder.getIndexReader().isCurrent()) {
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public synchronized void close() {
        this.stop();
        this.clearCache();
        this.searchEngineStore.close();
    }

    public IndexWriter openIndexWriter(CompassSettings settings, String subIndex) throws IOException {
        return this.openIndexWriter(settings, this.searchEngineStore.openDirectory(subIndex), false);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, String subIndex, boolean autoCommit) throws IOException {
        return this.openIndexWriter(settings, this.searchEngineStore.openDirectory(subIndex), autoCommit, false);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, boolean create) throws IOException {
        return this.openIndexWriter(settings, dir, true, create);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, IndexDeletionPolicy deletionPolicy) throws IOException {
        return this.openIndexWriter(settings, dir, true, false, deletionPolicy);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, boolean autoCommit, boolean create) throws IOException {
        return this.openIndexWriter(settings, dir, autoCommit, create, null);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, boolean autoCommit, boolean create, IndexDeletionPolicy deletionPolicy) throws IOException {
        return this.openIndexWriter(settings, dir, autoCommit, create, deletionPolicy, null);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, boolean autoCommit, boolean create, IndexDeletionPolicy deletionPolicy, Analyzer analyzer) throws IOException {
        if (deletionPolicy == null) {
            deletionPolicy = this.searchEngineFactory.getIndexDeletionPolicyManager().createIndexDeletionPolicy(dir);
        }
        if (analyzer == null) {
            analyzer = this.searchEngineFactory.getAnalyzerManager().getDefaultAnalyzer();
        }
        IndexWriter indexWriter = new IndexWriter(dir, analyzer, create, deletionPolicy, new IndexWriter.MaxFieldLength(this.luceneSettings.getMaxFieldLength()));
        indexWriter.setMergePolicy(MergePolicyFactory.createMergePolicy(settings));
        indexWriter.setMergeScheduler(MergeSchedulerFactory.create(this, settings));
        indexWriter.setMaxMergeDocs(settings.getSettingAsInt("compass.engine.maxMergeDocs", this.luceneSettings.getMaxMergeDocs()));
        indexWriter.setMergeFactor(settings.getSettingAsInt("compass.engine.mergeFactor", this.luceneSettings.getMergeFactor()));
        indexWriter.setRAMBufferSizeMB(settings.getSettingAsDouble("compass.engine.ramBufferSize", this.luceneSettings.getRamBufferSize()));
        indexWriter.setMaxBufferedDocs(settings.getSettingAsInt("compass.engine.maxBufferedDocs", this.luceneSettings.getMaxBufferedDocs()));
        indexWriter.setMaxBufferedDeleteTerms(settings.getSettingAsInt("compass.engine.maxBufferedDeletedTerms", this.luceneSettings.getMaxBufferedDeletedTerms()));
        indexWriter.setUseCompoundFile(this.searchEngineStore.isUseCompoundFile());
        indexWriter.setMaxFieldLength(this.luceneSettings.getMaxFieldLength());
        indexWriter.setTermIndexInterval(this.luceneSettings.getTermIndexInterval());
        indexWriter.setSimilarity(this.searchEngineFactory.getSimilarityManager().getIndexSimilarity());
        return indexWriter;
    }

    public IndexSearcher openIndexSearcher(IndexReader reader) {
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setSimilarity(this.searchEngineFactory.getSimilarityManager().getSearchSimilarity());
        return searcher;
    }

    public MultiSearcher openMultiSearcher(Searchable[] searchers) throws IOException {
        MultiSearcher searcher = new MultiSearcher(searchers);
        searcher.setSimilarity(this.searchEngineFactory.getSimilarityManager().getSearchSimilarity());
        return searcher;
    }

    public LuceneSearchEngineStore getStore() {
        return this.searchEngineStore;
    }

    protected Directory getDirectory(String subIndex) {
        return this.searchEngineStore.openDirectory(subIndex);
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        long indexManagerScheduleInterval = this.luceneSettings.getSettings().getSettingAsTimeInMillis("compass.engine.indexManagerScheduleInterval", 60000L);
        if (indexManagerScheduleInterval > 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting scheduled index manager with period [" + indexManagerScheduleInterval + "ms]"));
            }
        } else {
            log.info((Object)"Not starting scheduled index manager");
            return;
        }
        ScheduledIndexManagerRunnable scheduledIndexManagerRunnable = new ScheduledIndexManagerRunnable(this);
        this.scheduledIndexManagerFuture = this.searchEngineFactory.getExecutorManager().scheduleWithFixedDelay(scheduledIndexManagerRunnable, indexManagerScheduleInterval, indexManagerScheduleInterval, TimeUnit.MILLISECONDS);
        this.setWaitForCacheInvalidationBeforeSecondStep((long)((double)indexManagerScheduleInterval * 1.1));
        this.cacheAsyncInvalidation = this.luceneSettings.getSettings().getSettingAsBoolean("compass.engine.cacheAsyncInvalidation", true);
        long cacheInvalidationInterval = this.luceneSettings.getCacheInvalidationInterval();
        if (cacheInvalidationInterval > 0L && this.cacheAsyncInvalidation) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting scheduled refresh cache with period [" + cacheInvalidationInterval + "ms]"));
            }
        } else {
            log.info((Object)"Not starting scheduled refresh cache");
            return;
        }
        ScheduledRefreshCacheRunnable scheduledRefreshCacheRunnable = new ScheduledRefreshCacheRunnable();
        this.scheduledRefreshCacheFuture = this.searchEngineFactory.getExecutorManager().scheduleWithFixedDelay(scheduledRefreshCacheRunnable, cacheInvalidationInterval, cacheInvalidationInterval, TimeUnit.MILLISECONDS);
        this.isRunning = true;
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        if (this.scheduledIndexManagerFuture != null) {
            this.scheduledIndexManagerFuture.cancel(true);
            this.scheduledIndexManagerFuture = null;
        }
        if (this.scheduledRefreshCacheFuture != null) {
            this.scheduledRefreshCacheFuture.cancel(true);
            this.scheduledRefreshCacheFuture = null;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void checkAndClearIfNotifiedAllToClearCache() throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.doCheckAndClearIfNotifiedAllToClearCache();
                return null;
            }
        });
    }

    protected void doCheckAndClearIfNotifiedAllToClearCache() throws SearchEngineException {
        int i;
        String[] subIndexes;
        if (this.lastModifiled == null) {
            for (String subIndex : subIndexes = this.searchEngineStore.getSubIndexes()) {
                Directory dir = this.getDirectory(subIndex);
                try {
                    if (dir.fileExists(CLEAR_CACHE_NAME)) {
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to check if global clear cache exists", e);
                }
                try {
                    dir.createOutput(CLEAR_CACHE_NAME).close();
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to update/generate global invalidation cahce", e);
                }
            }
            this.lastModifiled = new long[subIndexes.length];
            for (i = 0; i < subIndexes.length; ++i) {
                Directory dir = this.getDirectory(subIndexes[i]);
                try {
                    this.lastModifiled[i] = dir.fileModified(CLEAR_CACHE_NAME);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        subIndexes = this.searchEngineStore.getSubIndexes();
        for (i = 0; i < subIndexes.length; ++i) {
            long lastMod;
            Directory dir = this.getDirectory(subIndexes[i]);
            try {
                lastMod = dir.fileModified(CLEAR_CACHE_NAME);
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to check last modified on global index chache on sub index [" + subIndexes[i] + "]", e);
            }
            if (this.lastModifiled[i] >= lastMod) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Global notification to clear cache detected on sub index [" + subIndexes[i] + "]"));
            }
            this.lastModifiled[i] = lastMod;
            this.clearCache(subIndexes[i]);
        }
    }

    public boolean isIndexCompound() throws SearchEngineException {
        String[] subIndexes;
        for (String subIndexe : subIndexes = this.searchEngineStore.getSubIndexes()) {
            Directory dir = this.getDirectory(subIndexe);
            try {
                if (LuceneUtils.isCompound(dir)) continue;
                return false;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to check if index is compound", e);
            }
        }
        return true;
    }

    public boolean isIndexUnCompound() throws SearchEngineException {
        String[] subIndexes;
        for (String subIndex : subIndexes = this.searchEngineStore.getSubIndexes()) {
            Directory dir = this.getDirectory(subIndex);
            try {
                if (LuceneUtils.isUnCompound(dir)) continue;
                return false;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to check if index is unCompound", e);
            }
        }
        return true;
    }

    public void performScheduledTasks() throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.doCheckAndClearIfNotifiedAllToClearCache();
                DefaultLuceneSearchEngineIndexManager.this.getStore().performScheduledTasks();
                return null;
            }
        });
    }

    public String[] getSubIndexes() {
        return this.searchEngineStore.getSubIndexes();
    }

    public boolean subIndexExists(String subIndex) {
        return this.searchEngineStore.subIndexExists(subIndex);
    }

    public boolean isLocked() throws SearchEngineException {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                return DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.isLocked();
            }
        });
    }

    public boolean isLocked(final String subIndex) throws SearchEngineException {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                return DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.isLocked(subIndex);
            }
        });
    }

    public void releaseLocks() throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.releaseLocks();
                return null;
            }
        });
    }

    public void releaseLock(final String subIndex) throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.releaseLock(subIndex);
                return null;
            }
        });
    }

    public String[] calcSubIndexes(String[] subIndexes, String[] aliases, Class[] types) {
        return this.searchEngineStore.calcSubIndexes(subIndexes, aliases, types);
    }

    public String[] polyCalcSubIndexes(String[] subIndexes, String[] aliases, Class[] types) {
        return this.searchEngineStore.polyCalcSubIndexes(subIndexes, aliases, types);
    }

    public boolean requiresAsyncTransactionalContext() {
        return this.searchEngineStore.requiresAsyncTransactionalContext();
    }

    public boolean supportsConcurrentOperations() {
        return this.searchEngineStore.supportsConcurrentOperations();
    }

    public void setWaitForCacheInvalidationBeforeSecondStep(long timeToWaitInMillis) {
        this.waitForCacheInvalidationBeforeSecondStep = timeToWaitInMillis;
    }

    public LuceneSettings getSettings() {
        return this.luceneSettings;
    }

    public ExecutorManager getExecutorManager() {
        return this.searchEngineFactory.getExecutorManager();
    }

    public TransactionContext getTransactionContext() {
        return this.searchEngineFactory.getTransactionContext();
    }

    private class ScheduledRefreshCacheRunnable
    implements Runnable {
        private ScheduledRefreshCacheRunnable() {
        }

        public void run() {
            DefaultLuceneSearchEngineIndexManager.this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

                @Override
                public Object doInTransaction() throws CompassException {
                    for (String subIndex : DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.getSubIndexes()) {
                        try {
                            if (DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.indexExists(subIndex)) {
                                LuceneIndexHolder indexHolder = (LuceneIndexHolder)DefaultLuceneSearchEngineIndexManager.this.indexHolders.get(subIndex);
                                if (!DefaultLuceneSearchEngineIndexManager.this.shouldInvalidateCache(indexHolder)) continue;
                                DefaultLuceneSearchEngineIndexManager.this.internalRefreshCache(subIndex);
                                continue;
                            }
                            log.trace((Object)("Sub index [" + subIndex + "] does not exists, no refresh perfomed"));
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to perform background refresh of cache for for sub-index [" + subIndex + "]"), (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private static class ScheduledIndexManagerRunnable
    implements Runnable {
        private LuceneSearchEngineIndexManager indexManager;

        public ScheduledIndexManagerRunnable(LuceneSearchEngineIndexManager indexManager) {
            this.indexManager = indexManager;
        }

        public void run() {
            block2: {
                try {
                    this.indexManager.performScheduledTasks();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug((Object)"Failed to perform schedule task", (Throwable)e);
                }
            }
        }
    }

    private final class ReplaceIndexOperationCallback
    implements SearchEngineIndexManager.IndexOperationCallback,
    SearchEngineIndexManager.IndexOperationPlan {
        private SearchEngineIndexManager.ReplaceIndexCallback callback;
        private LuceneSearchEngineIndexManager indexManager;

        private ReplaceIndexOperationCallback(LuceneSearchEngineIndexManager indexManager, SearchEngineIndexManager.ReplaceIndexCallback callback) {
            this.indexManager = indexManager;
            this.callback = callback;
        }

        public boolean firstStep() throws SearchEngineException {
            this.callback.buildIndexIfNeeded();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void secondStep() throws SearchEngineException {
            String[] subIndexes;
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Replace Index] Replacing index [" + DefaultLuceneSearchEngineIndexManager.this.searchEngineStore + "] with [" + this.indexManager.getStore() + "]"));
            }
            for (String subIndex : subIndexes = DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.polyCalcSubIndexes(this.getSubIndexes(), this.getAliases(), this.getTypes())) {
                Object v = DefaultLuceneSearchEngineIndexManager.this.subIndexLocks.get(subIndex);
                synchronized (v) {
                    DefaultLuceneSearchEngineIndexManager.this.clearCache(subIndex);
                    this.indexManager.clearCache(subIndex);
                    DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.copyFrom(subIndex, this.indexManager.getStore());
                    DefaultLuceneSearchEngineIndexManager.this.refreshCache(subIndex);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Replace Index] Index [" + DefaultLuceneSearchEngineIndexManager.this.searchEngineStore + "] replaced from [" + this.indexManager.getStore() + "]"));
            }
        }

        public String[] getSubIndexes() {
            if (this.callback instanceof SearchEngineIndexManager.IndexOperationPlan) {
                return ((SearchEngineIndexManager.IndexOperationPlan)((Object)this.callback)).getSubIndexes();
            }
            return null;
        }

        public String[] getAliases() {
            if (this.callback instanceof SearchEngineIndexManager.IndexOperationPlan) {
                return ((SearchEngineIndexManager.IndexOperationPlan)((Object)this.callback)).getAliases();
            }
            return null;
        }

        public Class[] getTypes() {
            if (this.callback instanceof SearchEngineIndexManager.IndexOperationPlan) {
                return ((SearchEngineIndexManager.IndexOperationPlan)((Object)this.callback)).getTypes();
            }
            return null;
        }
    }
}

