/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.config.process.MappingProcessorUtils;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.mapping.internal.InternalMapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.IdComponentMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.mapping.osem.OsemMappingIterator;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.PlainCascadeMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.util.IdentityHashSet;

public class LateBindingOsemMappingProcessor
implements MappingProcessor {
    private CompassMapping compassMapping;
    private PropertyNamingStrategy namingStrategy;
    private ConverterLookup converterLookup;
    private CompassSettings settings;
    private List<ComponentMapping> chainedComponents = new ArrayList<ComponentMapping>();
    private LinkedList<String> prefixes = new LinkedList();
    private ClassPropertyMapping.ManagedId managedId = null;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.compassMapping = compassMapping;
        this.namingStrategy = namingStrategy;
        this.converterLookup = converterLookup;
        this.settings = settings;
        ArrayList<AliasMapping> mappings = new ArrayList<AliasMapping>();
        ((InternalCompassMapping)compassMapping).setPath(namingStrategy.getRootPath());
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            if (aliasMapping instanceof ClassMapping) {
                this.clearRootClassMappingState();
                ClassMapping classMapping = (ClassMapping)aliasMapping;
                if (classMapping.isSupportUnmarshall()) {
                    classMapping = (ClassMapping)classMapping.copy();
                    this.secondPass(classMapping, compassMapping);
                } else {
                    this.secondPassNoUnmarshalling(classMapping);
                }
                mappings.add(classMapping);
                continue;
            }
            mappings.add(aliasMapping);
        }
        ((InternalCompassMapping)compassMapping).clearMappings();
        for (AliasMapping aliasMapping : mappings) {
            ((InternalCompassMapping)compassMapping).addMapping(aliasMapping);
        }
        return compassMapping;
    }

    private void secondPassNoUnmarshalling(ClassMapping classMapping) {
        classMapping.setPath(this.namingStrategy.buildPath(this.compassMapping.getPath(), classMapping.getAlias()));
        classMapping.setClassPath(this.namingStrategy.buildPath(classMapping.getPath(), "class").hintStatic());
        classMapping.setEnumNamePath(this.namingStrategy.buildPath(classMapping.getPath(), "name").hintStatic());
        OsemMappingIterator.iterateMappings(new NoUnmarshallingCallback(classMapping), classMapping, true);
    }

    private void secondPass(ClassMapping classMapping, CompassMapping fatherMapping) {
        classMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), classMapping.getAlias()));
        this.secondPass(classMapping, false, true);
    }

    private void secondPass(ClassMapping classMapping, boolean onlyProperties, boolean topmost) {
        classMapping.setClassPath(this.namingStrategy.buildPath(classMapping.getPath(), "class").hintStatic());
        classMapping.setEnumNamePath(this.namingStrategy.buildPath(classMapping.getPath(), "name").hintStatic());
        ArrayList<Mapping> innerMappingsCopy = new ArrayList<Mapping>();
        Iterator<Mapping> it = classMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = it.next();
            Mapping copyMapping = m.copy();
            boolean removeMapping = false;
            if (copyMapping instanceof ObjectMapping && topmost) {
                PropertyPath aliasedPath = this.namingStrategy.buildPath(this.compassMapping.getPath(), ((ObjectMapping)copyMapping).getDefinedInAlias());
                ((InternalMapping)copyMapping).setPath(this.namingStrategy.buildPath(aliasedPath, copyMapping.getName()));
            } else {
                ((InternalMapping)copyMapping).setPath(this.namingStrategy.buildPath(classMapping.getPath(), copyMapping.getName()));
            }
            if (copyMapping instanceof ClassPropertyMapping) {
                removeMapping = this.secondPass((ClassPropertyMapping)copyMapping, (Mapping)classMapping);
            } else if (copyMapping instanceof IdComponentMapping) {
                removeMapping = this.secondPass((IdComponentMapping)copyMapping, (Mapping)classMapping);
            } else if (!onlyProperties) {
                if (copyMapping instanceof ComponentMapping) {
                    removeMapping = this.secondPass((ComponentMapping)copyMapping, (Mapping)classMapping);
                } else if (copyMapping instanceof ReferenceMapping) {
                    removeMapping = this.secondPass((ReferenceMapping)copyMapping, (Mapping)classMapping);
                } else if (copyMapping instanceof ConstantMetaDataMapping) {
                    removeMapping = this.secondPass((ConstantMetaDataMapping)copyMapping);
                } else if (!(copyMapping instanceof ParentMapping)) {
                    if (copyMapping instanceof AbstractCollectionMapping) {
                        removeMapping = this.secondPass((AbstractCollectionMapping)copyMapping, (Mapping)classMapping);
                    } else if (copyMapping instanceof DynamicMetaDataMapping) {
                        removeMapping = this.secondPass((DynamicMetaDataMapping)copyMapping);
                    }
                }
            }
            if (removeMapping) continue;
            innerMappingsCopy.add(copyMapping);
        }
        classMapping.clearMappings();
        it = innerMappingsCopy.iterator();
        while (it.hasNext()) {
            classMapping.addMapping(it.next());
        }
    }

    private boolean secondPass(AbstractCollectionMapping collectionMapping, Mapping fatherMapping) {
        Mapping elementMapping = collectionMapping.getElementMapping();
        Mapping elementMappingCopy = elementMapping.copy();
        ((InternalMapping)elementMappingCopy).setPath(collectionMapping.getPath());
        boolean removeMapping = false;
        if (elementMappingCopy instanceof ClassPropertyMapping) {
            removeMapping = this.secondPass((ClassPropertyMapping)elementMappingCopy, fatherMapping);
        } else if (elementMappingCopy instanceof ComponentMapping) {
            removeMapping = this.secondPass((ComponentMapping)elementMappingCopy, fatherMapping);
        } else if (elementMappingCopy instanceof ReferenceMapping) {
            removeMapping = this.secondPass((ReferenceMapping)elementMappingCopy, fatherMapping);
        }
        collectionMapping.setElementMapping(elementMappingCopy);
        collectionMapping.setCollectionTypePath(this.namingStrategy.buildPath(collectionMapping.getPath(), "colType").hintStatic());
        collectionMapping.setColSizePath(this.namingStrategy.buildPath(collectionMapping.getPath(), "colSize").hintStatic());
        return removeMapping;
    }

    private boolean secondPass(ReferenceMapping referenceMapping, Mapping fatherMapping) {
        this.secondPassJustReference(referenceMapping, fatherMapping);
        if (referenceMapping.getRefCompAlias() != null) {
            ClassMapping pointerClass = (ClassMapping)this.compassMapping.getMappingByAlias(referenceMapping.getRefCompAlias());
            if (pointerClass == null) {
                throw new MappingException("Failed to locate mapping for reference ref-comp-alias [" + referenceMapping.getRefCompAlias() + "]");
            }
            ClassMapping refClass = (ClassMapping)pointerClass.copy();
            refClass.setPath(this.namingStrategy.buildPath(referenceMapping.getPath(), referenceMapping.getRefCompAlias()));
            this.managedId = ClassPropertyMapping.ManagedId.FALSE;
            this.secondPass(refClass, false, false);
            this.managedId = null;
            refClass.setRoot(false);
            referenceMapping.setRefCompMapping(refClass);
        }
        return false;
    }

    private void secondPassJustReference(ReferenceMapping referenceMapping, Mapping fatherMapping) {
        ClassMapping[] refMappings = referenceMapping.getRefClassMappings();
        ClassMapping[] copyRefClassMappings = new ClassMapping[refMappings.length];
        for (int i = 0; i < refMappings.length; ++i) {
            List<Mapping> ids = refMappings[i].findIdMappings();
            ClassMapping refClass = (ClassMapping)refMappings[i].shallowCopy();
            for (Mapping id : ids) {
                refClass.addMapping(id.copy());
            }
            refClass.setPath(referenceMapping.getPath());
            this.secondPass(refClass, true, false);
            for (ClassIdPropertyMapping mapping : refClass.findClassPropertyIdMappings()) {
                mapping.clearMappings();
                MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, mapping, true);
            }
            refClass.postProcess();
            copyRefClassMappings[i] = refClass;
        }
        referenceMapping.setRefClassMappings(copyRefClassMappings);
    }

    private boolean secondPass(ComponentMapping compMapping, Mapping fatherMapping) {
        int numberOfComponentsWithTheSameAlias = 0;
        for (ComponentMapping tempComponentMapping : this.chainedComponents) {
            if (!compMapping.hasAtLeastOneRefAlias(tempComponentMapping.getRefAliases())) continue;
            ++numberOfComponentsWithTheSameAlias;
        }
        if (numberOfComponentsWithTheSameAlias >= compMapping.getMaxDepth()) {
            return true;
        }
        this.chainedComponents.add(compMapping);
        if (compMapping.getPrefix() != null) {
            this.prefixes.add(compMapping.getPrefix());
        }
        ClassMapping[] refClassMappings = compMapping.getRefClassMappings();
        ClassMapping[] copyRefClassMappings = new ClassMapping[refClassMappings.length];
        for (int i = 0; i < refClassMappings.length; ++i) {
            ClassMapping refClassMapping = (ClassMapping)refClassMappings[i].copy();
            refClassMapping.setPath(compMapping.getPath());
            this.secondPass(refClassMapping, false, false);
            refClassMapping.setRoot(false);
            copyRefClassMappings[i] = refClassMapping;
        }
        compMapping.setRefClassMappings(copyRefClassMappings);
        this.chainedComponents.remove(compMapping);
        if (compMapping.getPrefix() != null) {
            this.prefixes.removeLast();
        }
        return false;
    }

    private boolean secondPass(ClassPropertyMapping classPropertyMapping, Mapping fatherMapping) {
        if (this.managedId != null) {
            classPropertyMapping.setManagedId(this.managedId);
        }
        ArrayList<ClassPropertyMetaDataMapping> innerMappingsCopy = new ArrayList<ClassPropertyMetaDataMapping>();
        Iterator<Mapping> it = classPropertyMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = it.next();
            ClassPropertyMetaDataMapping metaDataMappingCopy = (ClassPropertyMetaDataMapping)m.copy();
            metaDataMappingCopy.setName(this.buildFullName(metaDataMappingCopy.getName()));
            MappingProcessorUtils.process(metaDataMappingCopy, classPropertyMapping, this.converterLookup);
            innerMappingsCopy.add(metaDataMappingCopy);
        }
        classPropertyMapping.clearMappings();
        it = innerMappingsCopy.iterator();
        while (it.hasNext()) {
            classPropertyMapping.addMapping(it.next());
        }
        return false;
    }

    private boolean secondPass(ConstantMetaDataMapping constantMapping) {
        constantMapping.setName(this.buildFullName(constantMapping.getName()));
        constantMapping.setPath(new StaticPropertyPath(constantMapping.getName()));
        return false;
    }

    private boolean secondPass(DynamicMetaDataMapping dynamicMetaDataMapping) {
        dynamicMetaDataMapping.setName(this.buildFullName(dynamicMetaDataMapping.getName()));
        dynamicMetaDataMapping.setPath(new StaticPropertyPath(dynamicMetaDataMapping.getName()));
        return false;
    }

    private void clearRootClassMappingState() {
        this.chainedComponents.clear();
        this.prefixes.clear();
    }

    private String buildFullName(String name) {
        if (this.prefixes.isEmpty()) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        for (String prefix : this.prefixes) {
            sb.append(prefix);
        }
        sb.append(name);
        return sb.toString();
    }

    private class NoUnmarshallingCallback
    implements OsemMappingIterator.ClassMappingCallback {
        private ClassMapping rootClassMapping;
        private IdentityHashSet<ClassMapping> idComponents = new IdentityHashSet();
        private Set<String> cyclicClassMappings = new HashSet<String>();
        private ClassPropertyMapping classPropertyMapping;

        private NoUnmarshallingCallback(ClassMapping rootClassMapping) {
            this.rootClassMapping = rootClassMapping;
        }

        public boolean onBeginClassMapping(ClassMapping classMapping) {
            if (this.cyclicClassMappings.contains(classMapping.getAlias())) {
                return false;
            }
            this.cyclicClassMappings.add(classMapping.getAlias());
            return true;
        }

        public void onEndClassMapping(ClassMapping classMapping) {
            if (classMapping.isSupportUnmarshall()) {
                return;
            }
            this.cyclicClassMappings.remove(classMapping.getAlias());
        }

        public boolean onBeginMultipleMapping(ClassMapping classMapping, Mapping mapping) {
            ComponentMapping componentMapping;
            if (mapping instanceof ReferenceMapping && classMapping != this.rootClassMapping) {
                return false;
            }
            if (mapping instanceof ComponentMapping && (componentMapping = (ComponentMapping)mapping).getPrefix() != null) {
                LateBindingOsemMappingProcessor.this.prefixes.add(componentMapping.getPrefix());
            }
            return true;
        }

        public void onEndMultiplMapping(ClassMapping classMapping, Mapping mapping) {
            ComponentMapping componentMapping;
            if (mapping instanceof ComponentMapping && (componentMapping = (ComponentMapping)mapping).getPrefix() != null) {
                LateBindingOsemMappingProcessor.this.prefixes.removeLast();
            }
        }

        public void onBeginCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onEndCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onClassPropertyMapping(ClassMapping classMapping, ClassPropertyMapping classPropertyMapping) {
            this.classPropertyMapping = classPropertyMapping;
            if (classMapping == this.rootClassMapping) {
                PropertyPath aliasedPath = LateBindingOsemMappingProcessor.this.namingStrategy.buildPath(LateBindingOsemMappingProcessor.this.compassMapping.getPath(), classPropertyMapping.getDefinedInAlias());
                classPropertyMapping.setPath(LateBindingOsemMappingProcessor.this.namingStrategy.buildPath(aliasedPath, classPropertyMapping.getName()));
            } else if (this.idComponents.contains(classMapping)) {
                classPropertyMapping.setPath(LateBindingOsemMappingProcessor.this.namingStrategy.buildPath(classMapping.getPath(), classPropertyMapping.getName()));
            }
        }

        public void onParentMapping(ClassMapping classMapping, ParentMapping parentMapping) {
        }

        public void onCascadeMapping(ClassMapping classMapping, PlainCascadeMapping cascadeMapping) {
        }

        public void onComponentMapping(ClassMapping classMapping, ComponentMapping componentMapping) {
            ClassMapping[] refClassMappings = componentMapping.getRefClassMappings();
            ClassMapping[] copyRefClassMappings = new ClassMapping[refClassMappings.length];
            for (int i = 0; i < refClassMappings.length; ++i) {
                ClassMapping refClassMapping;
                if (componentMapping.getPrefix() != null) {
                    refClassMapping = (ClassMapping)refClassMappings[i].copy();
                    refClassMapping.setPath(componentMapping.getPath());
                    refClassMapping.setSupportUnmarshall(classMapping.isSupportUnmarshall());
                } else if (componentMapping instanceof IdComponentMapping && classMapping == this.rootClassMapping) {
                    refClassMapping = (ClassMapping)refClassMappings[i].copy();
                    PropertyPath aliasedPath = LateBindingOsemMappingProcessor.this.namingStrategy.buildPath(LateBindingOsemMappingProcessor.this.compassMapping.getPath(), componentMapping.getDefinedInAlias());
                    refClassMapping.setPath(LateBindingOsemMappingProcessor.this.namingStrategy.buildPath(aliasedPath, componentMapping.getName()));
                    this.idComponents.add(refClassMapping);
                    refClassMapping.setSupportUnmarshall(true);
                } else {
                    refClassMapping = (ClassMapping)refClassMappings[i].shallowCopy();
                    refClassMapping.replaceMappings(refClassMappings[i]);
                    refClassMapping.setPath(componentMapping.getPath());
                    refClassMapping.setSupportUnmarshall(classMapping.isSupportUnmarshall());
                }
                refClassMapping.setRoot(false);
                copyRefClassMappings[i] = refClassMapping;
            }
            componentMapping.setRefClassMappings(copyRefClassMappings);
        }

        public void onReferenceMapping(ClassMapping classMapping, ReferenceMapping referenceMapping) {
            PropertyPath aliasedPath = LateBindingOsemMappingProcessor.this.namingStrategy.buildPath(LateBindingOsemMappingProcessor.this.compassMapping.getPath(), referenceMapping.getDefinedInAlias());
            referenceMapping.setPath(LateBindingOsemMappingProcessor.this.namingStrategy.buildPath(aliasedPath, referenceMapping.getName()));
            LateBindingOsemMappingProcessor.this.secondPassJustReference(referenceMapping, classMapping);
        }

        public void onConstantMetaDataMappaing(ClassMapping classMapping, ConstantMetaDataMapping constantMetaDataMapping) {
            constantMetaDataMapping.setName(LateBindingOsemMappingProcessor.this.buildFullName(constantMetaDataMapping.getName()));
            constantMetaDataMapping.setPath(new StaticPropertyPath(constantMetaDataMapping.getName()));
        }

        public void onDynamicMetaDataMapping(ClassMapping classMapping, DynamicMetaDataMapping dynamicMetaDataMapping) {
            dynamicMetaDataMapping.setName(LateBindingOsemMappingProcessor.this.buildFullName(dynamicMetaDataMapping.getName()));
            dynamicMetaDataMapping.setPath(new StaticPropertyPath(dynamicMetaDataMapping.getName()));
        }

        public void onClassPropertyMetaDataMapping(ClassPropertyMetaDataMapping classPropertyMetaDataMapping) {
            classPropertyMetaDataMapping.setName(LateBindingOsemMappingProcessor.this.buildFullName(classPropertyMetaDataMapping.getName()));
            MappingProcessorUtils.process(classPropertyMetaDataMapping, this.classPropertyMapping, LateBindingOsemMappingProcessor.this.converterLookup);
        }

        public void onResourcePropertyMapping(ResourcePropertyMapping resourcePropertyMapping) {
        }
    }
}

