/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.HashMap;
import java.util.List;
import org.compass.core.Property;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.config.process.MappingProcessorUtils;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.OsemMappingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalIdsMappingProcessor
implements MappingProcessor {
    private CompassSettings settings;
    private ConverterLookup converterLookup;

    @Override
    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.settings = settings;
        this.converterLookup = converterLookup;
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            if (!(aliasMapping instanceof ClassMapping)) continue;
            ClassMapping classMapping = (ClassMapping)aliasMapping;
            if (classMapping.isSupportUnmarshall()) {
                this.buildClassMetaDataIds(classMapping);
                continue;
            }
            this.buildInternalIdForIdProperties(classMapping);
        }
        return compassMapping;
    }

    private void buildInternalIdForIdProperties(ClassMapping classMapping) {
        List<ClassIdPropertyMapping> idMappings = classMapping.findClassPropertyIdMappings();
        for (ClassIdPropertyMapping idMapping : idMappings) {
            MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, idMapping, true);
        }
    }

    private void buildClassMetaDataIds(ClassMapping classMapping) {
        OsemMappingIterator.ClassPropertyAndResourcePropertyGatherer callback = new OsemMappingIterator.ClassPropertyAndResourcePropertyGatherer();
        OsemMappingIterator.iterateMappings(callback, classMapping);
        HashMap<String, Integer> propertyMappingsMap = new HashMap<String, Integer>();
        List<ResourcePropertyMapping> pMappings = callback.getResourcePropertyMappings();
        for (ResourcePropertyMapping pMapping : pMappings) {
            if (pMapping.getStore() == Property.Store.NO) continue;
            Integer count = (Integer)propertyMappingsMap.get(pMapping.getName());
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            propertyMappingsMap.put(pMapping.getName(), count);
        }
        List<ClassPropertyMapping> classPropertyMappings = callback.getClassPropertyMappings();
        for (ClassPropertyMapping classPropertyMapping : classPropertyMappings) {
            if (classPropertyMapping.getManagedId() == null) {
                if (classMapping.getManagedId() == null) {
                    String globalManagedId = this.settings.getSetting("compass.osem.managedId", ClassPropertyMapping.ManagedId.NO_STORE.toString());
                    classPropertyMapping.setManagedId(ClassPropertyMapping.ManagedId.fromString(globalManagedId));
                } else {
                    classPropertyMapping.setManagedId(classMapping.getManagedId());
                }
            }
            boolean mustBeUnTokenized = false;
            if (classPropertyMapping instanceof ClassIdPropertyMapping) {
                mustBeUnTokenized = true;
            }
            if (classPropertyMapping.isIdPropertySet()) continue;
            if (classPropertyMapping.getManagedId() == ClassPropertyMapping.ManagedId.TRUE || classPropertyMapping.mappingsSize() == 0) {
                MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, classPropertyMapping, mustBeUnTokenized);
                continue;
            }
            if (classPropertyMapping.getManagedId() == ClassPropertyMapping.ManagedId.AUTO) {
                this.autoAddIfRequiredInternalId(propertyMappingsMap, classPropertyMapping, mustBeUnTokenized);
                continue;
            }
            if (classPropertyMapping.getManagedId() == ClassPropertyMapping.ManagedId.NO_STORE) {
                boolean allMetaDataHasStoreNo = true;
                for (int i = 0; i < classPropertyMapping.mappingsSize(); ++i) {
                    ClassPropertyMetaDataMapping pMapping = (ClassPropertyMetaDataMapping)classPropertyMapping.getMapping(i);
                    if (!pMapping.canActAsPropertyId()) {
                        allMetaDataHasStoreNo = false;
                        break;
                    }
                    if (pMapping.getStore() == Property.Store.NO) continue;
                    allMetaDataHasStoreNo = false;
                    break;
                }
                if (allMetaDataHasStoreNo) continue;
                this.autoAddIfRequiredInternalId(propertyMappingsMap, classPropertyMapping, mustBeUnTokenized);
                continue;
            }
            if (classPropertyMapping.getManagedId() == ClassPropertyMapping.ManagedId.NO) continue;
            classPropertyMapping.setIdPropertyIndex(0);
        }
    }

    private void autoAddIfRequiredInternalId(HashMap<String, Integer> propertyMappingsMap, ClassPropertyMapping classPropertyMapping, boolean mustBeNotAnalyzed) {
        boolean foundPropertyId = false;
        for (int i = 0; i < classPropertyMapping.mappingsSize(); ++i) {
            ClassPropertyMetaDataMapping pMapping = (ClassPropertyMetaDataMapping)classPropertyMapping.getMapping(i);
            if (!pMapping.canActAsPropertyId() || !propertyMappingsMap.containsKey(pMapping.getName()) || propertyMappingsMap.get(pMapping.getName()) != 1 || pMapping.getStore() != Property.Store.YES && pMapping.getStore() != Property.Store.COMPRESS || mustBeNotAnalyzed && pMapping.getIndex() != Property.Index.UN_TOKENIZED && pMapping.getIndex() != Property.Index.NOT_ANALYZED) continue;
            classPropertyMapping.setIdPropertyIndex(i);
            foundPropertyId = true;
            break;
        }
        if (!foundPropertyId) {
            MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, classPropertyMapping, mustBeNotAnalyzed);
        }
    }
}

