/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.config.process.MappingProcessorUtils;
import org.compass.core.converter.Converter;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.DelegateConverter;
import org.compass.core.converter.basic.FormatConverter;
import org.compass.core.converter.dynamic.DynamicConverter;
import org.compass.core.converter.json.ResourcePropertyJsonValueConverter;
import org.compass.core.converter.json.SimpleJsonValueConverter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.converter.xsem.ResourcePropertyValueConverter;
import org.compass.core.converter.xsem.SimpleXmlValueConverter;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.json.JsonArrayMapping;
import org.compass.core.mapping.json.JsonContentMapping;
import org.compass.core.mapping.json.JsonMapping;
import org.compass.core.mapping.json.JsonMappingIterator;
import org.compass.core.mapping.json.JsonPropertyMapping;
import org.compass.core.mapping.json.PlainJsonObjectMapping;
import org.compass.core.mapping.json.RootJsonObjectMapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.OsemMappingIterator;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.PlainCascadeMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.mapping.rsem.RawResourceMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.mapping.xsem.XmlPropertyMapping;

public class ConverterLookupMappingProcessor
implements MappingProcessor {
    private ConverterLookup converterLookup;
    private CompassSettings settings;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.converterLookup = converterLookup;
        this.settings = settings;
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            if (aliasMapping instanceof RawResourceMapping) {
                this.lookupConverter((RawResourceMapping)aliasMapping);
                continue;
            }
            if (aliasMapping instanceof XmlObjectMapping) {
                this.lookupConverter((XmlObjectMapping)aliasMapping);
                continue;
            }
            if (aliasMapping instanceof ClassMapping) {
                this.lookupConverter((ClassMapping)aliasMapping);
                continue;
            }
            if (!(aliasMapping instanceof RootJsonObjectMapping)) continue;
            this.lookupConverter((RootJsonObjectMapping)aliasMapping);
        }
        return compassMapping;
    }

    private void lookupConverter(RawResourceMapping resourceMapping) throws MappingException {
        MappingProcessorUtils.lookupConverter(this.converterLookup, resourceMapping, true);
        Iterator<Mapping> it = resourceMapping.mappingsIt();
        while (it.hasNext()) {
            MappingProcessorUtils.lookupConverter(this.converterLookup, it.next(), false);
        }
    }

    private void lookupConverter(XmlObjectMapping xmlObjectMapping) throws MappingException {
        MappingProcessorUtils.lookupConverter(this.converterLookup, xmlObjectMapping);
        Iterator<Mapping> it = xmlObjectMapping.mappingsIt();
        while (it.hasNext()) {
            Converter converter;
            Mapping mapping = it.next();
            MappingProcessorUtils.lookupConverter(this.converterLookup, mapping, true);
            if (!(mapping instanceof XmlPropertyMapping)) continue;
            XmlPropertyMapping xmlPropertyMapping = (XmlPropertyMapping)mapping;
            if (xmlPropertyMapping.getValueConverterName() != null) {
                String converterName = xmlPropertyMapping.getValueConverterName();
                converter = this.converterLookup.lookupConverter(converterName);
                if (xmlPropertyMapping.getValueConverter() instanceof DelegateConverter) {
                    ((DelegateConverter)xmlPropertyMapping.getValueConverter()).setDelegatedConverter(converter);
                    converter = xmlPropertyMapping.getValueConverter();
                }
                if (converter instanceof ResourcePropertyConverter) {
                    converter = new ResourcePropertyValueConverter((ResourcePropertyConverter)converter);
                }
                if (converter == null) {
                    throw new ConfigurationException("Failed to find converter [" + converterName + "] for mapping " + "[" + xmlPropertyMapping.getName() + "]");
                }
            } else {
                converter = new SimpleXmlValueConverter();
            }
            xmlPropertyMapping.setValueConverter(converter);
        }
    }

    private void lookupConverter(ClassMapping classMapping) throws MappingException {
        MappingProcessorUtils.lookupConverter(this.converterLookup, classMapping);
        OsemMappingIterator.iterateMappings(new OsemConverterLookup(), classMapping, false);
    }

    private void lookupConverter(RootJsonObjectMapping jsonMapping) throws MappingException {
        MappingProcessorUtils.lookupConverter(this.converterLookup, jsonMapping);
        JsonMappingIterator.iterateMappings((JsonMappingIterator.JsonMappingCallback)new JsonConverterLookup(), jsonMapping, true);
    }

    private class OsemConverterLookup
    implements OsemMappingIterator.ClassMappingCallback {
        private ClassPropertyMapping classPropertyMapping;

        private OsemConverterLookup() {
        }

        public boolean onBeginClassMapping(ClassMapping classMapping) {
            return true;
        }

        public void onEndClassMapping(ClassMapping classMapping) {
        }

        public boolean onBeginMultipleMapping(ClassMapping classMapping, Mapping mapping) {
            return true;
        }

        public void onEndMultiplMapping(ClassMapping classMapping, Mapping mapping) {
        }

        public void onBeginCollectionMapping(AbstractCollectionMapping collectionMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, collectionMapping);
        }

        public void onEndCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onClassPropertyMapping(ClassMapping classMapping, ClassPropertyMapping classPropertyMapping) {
            this.classPropertyMapping = classPropertyMapping;
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, classPropertyMapping);
        }

        public void onComponentMapping(ClassMapping classMapping, ComponentMapping componentMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, componentMapping);
        }

        public void onReferenceMapping(ClassMapping classMapping, ReferenceMapping referenceMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, referenceMapping);
        }

        public void onParentMapping(ClassMapping classMapping, ParentMapping parentMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, parentMapping);
        }

        public void onCascadeMapping(ClassMapping classMapping, PlainCascadeMapping cascadeMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, cascadeMapping);
        }

        public void onConstantMetaDataMappaing(ClassMapping classMapping, ConstantMetaDataMapping constantMetaDataMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, constantMetaDataMapping);
        }

        public void onClassPropertyMetaDataMapping(ClassPropertyMetaDataMapping classPropertyMetaDataMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, classPropertyMetaDataMapping, this.classPropertyMapping);
        }

        public void onDynamicMetaDataMapping(ClassMapping classMapping, DynamicMetaDataMapping dynamicMetaDataMapping) {
            Converter converter = ConverterLookupMappingProcessor.this.converterLookup.lookupConverter(dynamicMetaDataMapping.getConverterName());
            if (!(converter instanceof DynamicConverter)) {
                throw new MappingException("Dynamic meta-data [" + dynamicMetaDataMapping + "] converter name [" + dynamicMetaDataMapping.getConverterName() + "] is not a dynamic converter");
            }
            DynamicConverter dynamicConverter = ((DynamicConverter)converter).copy();
            dynamicConverter.setType(dynamicMetaDataMapping.getType());
            dynamicConverter.setExpression(dynamicMetaDataMapping.getExpression());
            if (dynamicMetaDataMapping.getFormat() != null) {
                converter = ConverterLookupMappingProcessor.this.converterLookup.lookupConverter(dynamicMetaDataMapping.getType());
                if (!(converter instanceof FormatConverter)) {
                    throw new MappingException("Dynamic meta data [" + dynamicMetaDataMapping.getName() + "] type [" + dynamicMetaDataMapping.getType().getName() + "] is not a formattable type");
                }
                FormatConverter formatConverter = ((FormatConverter)converter).copy();
                formatConverter.setFormat(dynamicMetaDataMapping.getFormat());
                dynamicConverter.setFormatConverter(formatConverter);
            }
            dynamicMetaDataMapping.setConverter(dynamicConverter);
        }

        public void onResourcePropertyMapping(ResourcePropertyMapping resourcePropertyMapping) {
            MappingProcessorUtils.applyResourcePropertySettings(resourcePropertyMapping, ConverterLookupMappingProcessor.this.settings);
        }
    }

    private class JsonConverterLookup
    implements JsonMappingIterator.JsonMappingCallback {
        private JsonConverterLookup() {
        }

        public void onJsonRootObject(RootJsonObjectMapping jsonObjectMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, jsonObjectMapping);
        }

        public void onJsonObject(PlainJsonObjectMapping jsonObjectMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, jsonObjectMapping);
        }

        public void onJsonContent(JsonContentMapping jsonContentMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, jsonContentMapping);
        }

        public void onJsonProperty(JsonPropertyMapping mapping) {
            Converter converter;
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, mapping);
            if (mapping.getValueConverterName() != null) {
                String converterName = mapping.getValueConverterName();
                converter = ConverterLookupMappingProcessor.this.converterLookup.lookupConverter(converterName);
                if (mapping.getValueConverter() instanceof DelegateConverter) {
                    ((DelegateConverter)mapping.getValueConverter()).setDelegatedConverter(converter);
                    converter = mapping.getValueConverter();
                }
                if (converter instanceof ResourcePropertyConverter) {
                    converter = new ResourcePropertyJsonValueConverter((ResourcePropertyConverter)converter);
                }
                if (converter == null) {
                    throw new ConfigurationException("Failed to find converter [" + converterName + "] for mapping " + "[" + mapping.getName() + "]");
                }
            } else {
                converter = new SimpleJsonValueConverter();
            }
            mapping.setValueConverter(converter);
        }

        public void onJsonArray(JsonArrayMapping jsonArrayMapping) {
            MappingProcessorUtils.lookupConverter(ConverterLookupMappingProcessor.this.converterLookup, jsonArrayMapping);
        }

        public boolean onBeginMultipleMapping(JsonMapping mapping) {
            return true;
        }

        public void onEndMultipleMapping(JsonMapping mapping) {
        }
    }
}

