/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.context.TransactionContextCallback;

public class LuceneSubIndexInfo {
    private ArrayList segmentInfos;
    private long version;
    private String subIndex;

    protected LuceneSubIndexInfo(String subIndex, long version, ArrayList segmentInfos) {
        this.subIndex = subIndex;
        this.version = version;
        this.segmentInfos = segmentInfos;
    }

    public long version() {
        return this.version;
    }

    public int size() {
        return this.segmentInfos.size();
    }

    public LuceneSegmentInfo info(int segmentIndex) {
        return (LuceneSegmentInfo)this.segmentInfos.get(segmentIndex);
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public static LuceneSubIndexInfo getIndexInfo(final String subIndex, CompassSession session) throws IOException {
        LuceneSearchEngine searchEngine = (LuceneSearchEngine)((InternalCompassSession)session).getSearchEngine();
        final LuceneSearchEngineIndexManager indexManager = (LuceneSearchEngineIndexManager)searchEngine.getSearchEngineFactory().getIndexManager();
        return searchEngine.getSearchEngineFactory().getTransactionContext().execute(new TransactionContextCallback<LuceneSubIndexInfo>(){

            @Override
            public LuceneSubIndexInfo doInTransaction() throws CompassException {
                try {
                    return LuceneSubIndexInfo.getIndexInfo(subIndex, indexManager);
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to open index info for sub index [" + subIndex + "]", e);
                }
            }
        });
    }

    public static LuceneSubIndexInfo getIndexInfo(String subIndex, LuceneSearchEngineIndexManager indexManager) throws IOException {
        return LuceneSubIndexInfo.getIndexInfo(subIndex, indexManager.getStore());
    }

    public static LuceneSubIndexInfo getIndexInfo(String subIndex, LuceneSearchEngineStore store) throws IOException {
        Directory directory = store.openDirectory(subIndex);
        try {
            SegmentInfos segmentInfos = new SegmentInfos();
            segmentInfos.read(directory);
            ArrayList<LuceneSegmentInfo> segmentInfosList = new ArrayList<LuceneSegmentInfo>();
            for (int i = 0; i < segmentInfos.size(); ++i) {
                SegmentInfo segmentInfo = segmentInfos.info(i);
                LuceneSegmentInfo luceneSegmentInfo = new LuceneSegmentInfo(segmentInfo.name, segmentInfo.docCount);
                segmentInfosList.add(luceneSegmentInfo);
            }
            return new LuceneSubIndexInfo(subIndex, segmentInfos.getVersion(), segmentInfosList);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static class LuceneSegmentInfo {
        private String name;
        private int docCount;

        public LuceneSegmentInfo(String name, int docCount) {
            this.name = name;
            this.docCount = docCount;
        }

        public String name() {
            return this.name;
        }

        public int docCount() {
            return this.docCount;
        }
    }
}

