/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.footnotes.internal;

import java.util.Set;
import org.commonmark.ext.footnotes.FootnoteDefinition;
import org.commonmark.ext.footnotes.FootnoteReference;
import org.commonmark.ext.footnotes.InlineFootnote;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownWriter;

public class FootnoteMarkdownNodeRenderer
implements NodeRenderer {
    private final MarkdownWriter writer;
    private final MarkdownNodeRendererContext context;

    public FootnoteMarkdownNodeRenderer(MarkdownNodeRendererContext context) {
        this.writer = context.getWriter();
        this.context = context;
    }

    public Set<Class<? extends Node>> getNodeTypes() {
        return Set.of(FootnoteReference.class, InlineFootnote.class, FootnoteDefinition.class);
    }

    public void render(Node node) {
        if (node instanceof FootnoteReference) {
            this.renderReference((FootnoteReference)node);
        } else if (node instanceof InlineFootnote) {
            this.renderInline((InlineFootnote)node);
        } else if (node instanceof FootnoteDefinition) {
            this.renderDefinition((FootnoteDefinition)node);
        }
    }

    private void renderReference(FootnoteReference ref) {
        this.writer.raw("[^");
        this.writer.raw(ref.getLabel());
        this.writer.raw("]");
    }

    private void renderInline(InlineFootnote inlineFootnote) {
        this.writer.raw("^[");
        this.renderChildren((Node)inlineFootnote);
        this.writer.raw("]");
    }

    private void renderDefinition(FootnoteDefinition def) {
        this.writer.raw("[^");
        this.writer.raw(def.getLabel());
        this.writer.raw("]: ");
        this.writer.pushPrefix("    ");
        this.renderChildren((Node)def);
        this.writer.popPrefix();
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

