/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.footnotes.internal;

import org.commonmark.ext.footnotes.FootnoteDefinition;
import org.commonmark.ext.footnotes.FootnoteReference;
import org.commonmark.ext.footnotes.InlineFootnote;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.Node;
import org.commonmark.parser.InlineParserContext;
import org.commonmark.parser.beta.LinkInfo;
import org.commonmark.parser.beta.LinkProcessor;
import org.commonmark.parser.beta.LinkResult;
import org.commonmark.parser.beta.Position;
import org.commonmark.parser.beta.Scanner;

public class FootnoteLinkProcessor
implements LinkProcessor {
    public LinkResult process(LinkInfo linkInfo, Scanner scanner, InlineParserContext context) {
        if (linkInfo.marker() != null && linkInfo.marker().getLiteral().equals("^")) {
            return LinkResult.wrapTextIn((Node)new InlineFootnote(), (Position)linkInfo.afterTextBracket()).includeMarker();
        }
        if (linkInfo.destination() != null) {
            return LinkResult.none();
        }
        String text = linkInfo.text();
        if (!text.startsWith("^")) {
            return LinkResult.none();
        }
        if (linkInfo.label() != null && context.getDefinition(LinkReferenceDefinition.class, linkInfo.label()) != null) {
            return LinkResult.none();
        }
        String label = text.substring(1);
        FootnoteDefinition def = (FootnoteDefinition)((Object)context.getDefinition(FootnoteDefinition.class, label));
        if (def == null) {
            return LinkResult.none();
        }
        Position position = linkInfo.afterTextBracket();
        return LinkResult.replaceWith((Node)new FootnoteReference(label), (Position)position);
    }
}

