/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.autolink;

import java.util.EnumSet;
import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkType;
import org.commonmark.ext.autolink.internal.AutolinkPostProcessor;
import org.commonmark.parser.Parser;
import org.commonmark.parser.PostProcessor;

public class AutolinkExtension
implements Parser.ParserExtension {
    private final Set<AutolinkType> linkTypes;

    private AutolinkExtension(Builder builder) {
        this.linkTypes = builder.linkTypes;
    }

    public static Extension create() {
        return AutolinkExtension.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.postProcessor((PostProcessor)new AutolinkPostProcessor(this.linkTypes));
    }

    public static class Builder {
        private Set<AutolinkType> linkTypes = EnumSet.allOf(AutolinkType.class);

        public Builder linkTypes(AutolinkType ... linkTypes) {
            if (linkTypes == null) {
                throw new NullPointerException("linkTypes must not be null");
            }
            return this.linkTypes(Set.of(linkTypes));
        }

        public Builder linkTypes(Set<AutolinkType> linkTypes) {
            if (linkTypes == null) {
                throw new NullPointerException("linkTypes must not be null");
            }
            if (linkTypes.isEmpty()) {
                throw new IllegalArgumentException("linkTypes must not be empty");
            }
            this.linkTypes = EnumSet.copyOf(linkTypes);
            return this;
        }

        public Extension build() {
            return new AutolinkExtension(this);
        }
    }
}

