/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.execroot;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.plugins.execroot.AbstractDirectoryGoal;

public class HighestBasedirGoal
extends AbstractDirectoryGoal
implements Mojo,
ContextEnabled {
    protected static final String HIGHEST_DIR_CONTEXT_KEY = "directories.highestDir";
    protected List<MavenProject> projects;

    protected File findDirectory() throws MojoExecutionException {
        File next;
        Stack<MavenProject> toCheck = new Stack<MavenProject>();
        toCheck.addAll(this.projects);
        ArrayList<File> files = new ArrayList<File>();
        while (!toCheck.isEmpty()) {
            MavenProject p = (MavenProject)toCheck.pop();
            if (p.getBasedir() == null) continue;
            if (!files.contains(p.getBasedir())) {
                files.add(0, p.getBasedir());
            }
            if (p.getParent() == null) continue;
            toCheck.add(p.getParent());
        }
        if (files.isEmpty()) {
            throw new MojoExecutionException("No project base directories found! Are you sure you're executing this on a valid Maven project?");
        }
        Collections.sort(files, new PathComparator());
        File dir = (File)files.get(0);
        if (files.size() > 1 && !(next = (File)files.get(1)).getAbsolutePath().startsWith(dir.getAbsolutePath())) {
            throw new MojoExecutionException("Cannot find a single highest directory for this project set. First two candidates directories don't share a common root.");
        }
        return dir;
    }

    protected String getContextKey() {
        return HIGHEST_DIR_CONTEXT_KEY;
    }

    protected String getLogLabel() {
        return "Highest basedir";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PathComparator
    implements Comparator<File> {
        @Override
        public int compare(File first, File second) {
            return first.getAbsolutePath().compareTo(second.getAbsolutePath());
        }
    }
}

