/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.execroot;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDirectoryGoal
implements Mojo,
ContextEnabled {
    private Log log;
    protected String property;
    protected MavenProject currentProject;
    protected MavenSession session;
    protected boolean quiet;
    protected Map<String, Object> context;

    protected AbstractDirectoryGoal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        File execRoot;
        MavenSession mavenSession = this.session;
        synchronized (mavenSession) {
            String key = this.getContextKey();
            execRoot = (File)this.context.get(key);
            if (execRoot == null) {
                execRoot = this.findDirectory();
                this.context.put(key, execRoot);
            }
        }
        if (!this.quiet) {
            this.getLog().info((CharSequence)(this.getLogLabel() + " set to: " + execRoot));
        }
        this.currentProject.getProperties().setProperty(this.property, execRoot.getAbsolutePath());
        if (this.getLog().isDebugEnabled()) {
            StringWriter str = new StringWriter();
            this.currentProject.getProperties().list(new PrintWriter(str));
            this.getLog().debug((CharSequence)("After setting property '" + this.property + "', project properties are:\n\n" + str));
        }
    }

    protected abstract String getLogLabel();

    protected abstract File findDirectory() throws MojoExecutionException;

    protected abstract String getContextKey();

    public synchronized Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Map getPluginContext() {
        return this.context;
    }

    public void setPluginContext(Map context) {
        this.context = context;
    }
}

