/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.data;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.util.logging.Logger;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotCommitList;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitManager {
    private final Logger logger = new Logger(this.getClass());
    private FreekiConfig config;
    private Git git;
    private int basepathLength;
    private String username;
    private String email;
    private Repository repo;

    protected GitManager() {
    }

    public GitManager(FreekiConfig config) throws IOException, InvalidRemoteException, TransportException, GitAPIException {
        this.config = config;
        this.setupGit();
    }

    @PostConstruct
    public void setupGit() throws IOException, InvalidRemoteException, TransportException, GitAPIException {
        this.basepathLength = this.config.getContentDir().getPath().length() + 1;
        File gitDir = this.config.getContentDir();
        String cloneUrl = this.config.getCloneFrom();
        if (cloneUrl != null) {
            this.logger.info("Cloning: %s into: %s", cloneUrl, gitDir);
            if (gitDir.isDirectory()) {
                throw new IOException("Cannot clone into directory: " + gitDir + ". It already exists!");
            }
            Git.cloneRepository().setURI(cloneUrl).setDirectory(gitDir).setRemote("canonical").call();
        }
        File dotGitDir = new File(gitDir, ".git");
        boolean create = cloneUrl == null && !dotGitDir.isDirectory();
        this.logger.info("Setting up git manager for: %s", dotGitDir);
        this.repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).setGitDir(dotGitDir)).build();
        this.username = this.repo.getConfig().getString("user", null, "name");
        if (this.username == null) {
            this.username = System.getProperty("user.name");
        }
        this.email = this.repo.getConfig().getString("user", null, "email");
        if (this.email == null) {
            this.email = this.username + "@" + InetAddress.getLocalHost().getCanonicalHostName();
        }
        if (create) {
            this.repo.create();
        }
        this.git = new Git(this.repo);
    }

    public void addAndCommit(String message, File ... files) throws IOException {
        this.addAndCommit(message, Arrays.asList(files));
    }

    public void addAndCommit(String message, Collection<File> files) throws IOException {
        try {
            AddCommand add = this.git.add();
            CommitCommand commit = this.git.commit();
            for (File f : files) {
                String filepath = f.getPath().substring(this.basepathLength);
                add.addFilepattern(filepath);
            }
            add.call();
            commit.setMessage(message).setAuthor(this.username, this.email).call();
        }
        catch (NoFilepatternException e) {
            throw new IOException("Cannot add to git: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new IOException("Cannot add to git: " + e.getMessage(), e);
        }
    }

    public void deleteAndCommit(String message, File ... deleted) throws IOException {
        this.deleteAndCommit(message, Arrays.asList(deleted));
    }

    public void deleteAndCommit(String message, Collection<File> deleted) throws IOException {
        try {
            RmCommand rm = this.git.rm();
            CommitCommand commit = this.git.commit();
            for (File file : deleted) {
                String filepath = file.getPath().substring(this.basepathLength);
                rm = rm.addFilepattern(filepath);
                commit = commit.setOnly(filepath);
            }
            rm.call();
            commit.setMessage(message).setAuthor(this.username, this.email).call();
        }
        catch (NoFilepatternException e) {
            throw new IOException("Cannot remove from git: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new IOException("Cannot remove from git: " + e.getMessage(), e);
        }
    }

    public PlotCommit<PlotLane> getHeadCommit(File f) throws Exception {
        ObjectId oid = this.repo.resolve("HEAD");
        PlotWalk pw = new PlotWalk(this.repo);
        RevCommit rc = pw.parseCommit(oid);
        pw.markStart(rc);
        pw.setTreeFilter(AndTreeFilter.create(PathFilter.create(f.getPath().substring(this.basepathLength)), TreeFilter.ANY_DIFF));
        PlotCommitList cl = new PlotCommitList();
        cl.source(pw);
        cl.fillTo(1);
        return (PlotCommit)cl.get(0);
    }

    public void pullUpdates() throws IOException {
        try {
            this.git.pull().setRebase(true).call();
        }
        catch (GitAPIException e) {
            throw new IOException("Cannot pull content updates via git: " + e.getMessage(), e);
        }
    }

    public void pushUpdates(String user, String password) throws IOException {
        UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(user, password);
        try {
            ((PushCommand)this.git.push().setCredentialsProvider(cp)).call();
        }
        catch (GitAPIException e) {
            throw new IOException("Cannot push content updates via git: " + e.getMessage(), e);
        }
    }

    public String getOriginUrl() {
        return this.git.getRepository().getConfig().getString("remote", "origin", "url");
    }

    public String getCanonicalUrl() {
        return this.git.getRepository().getConfig().getString("remote", "canonical", "url");
    }
}

