/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.cli;

import groovy.text.GStringTemplateEngine;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.apache.commons.lang.StringUtils;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.conf.GTemplateConfig;
import org.commonjava.freeki.data.FreekiStore;
import org.commonjava.freeki.data.GitManager;
import org.commonjava.freeki.data.TemplateController;
import org.commonjava.freeki.infra.auth.Authorizer;
import org.commonjava.freeki.infra.render.ContentRenderer;
import org.commonjava.freeki.infra.render.RenderingEngine;
import org.commonjava.freeki.infra.render.json.JsonRenderer;
import org.commonjava.freeki.infra.render.tmpl.GTHtmlRenderer;
import org.commonjava.freeki.infra.render.tmpl.GTTextRenderer;
import org.commonjava.freeki.rest.ExportContentHandler;
import org.commonjava.freeki.rest.GroupContentHandler;
import org.commonjava.freeki.rest.PageContentHandler;
import org.commonjava.freeki.rest.StaticContentHandler;
import org.commonjava.freeki.rest.TemplateContentHandler;
import org.commonjava.freeki.rest.UpdateHandler;
import org.commonjava.freeki.util.ContentType;
import org.commonjava.vertx.vabr.ApplicationRouter;
import org.commonjava.vertx.vabr.RouteCollection;
import org.commonjava.vertx.vabr.RouteHandler;
import org.commonjava.web.json.ser.JsonSerializer;
import org.commonjava.web.json.ser.WebSerializationAdapter;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.vertx.java.core.impl.DefaultVertx;
import org.vertx.java.platform.Verticle;

public class Main
extends Verticle {
    private final GStringTemplateEngine templates;
    private boolean canStart = false;
    private final FreekiConfig config = new FreekiConfig();

    public static void main(String[] args) throws Exception {
        new Main(args).run();
    }

    public Main(String[] args) {
        CmdLineParser parser = new CmdLineParser(this.config);
        try {
            parser.parseArgument(args);
            this.canStart = true;
        }
        catch (CmdLineException e) {
            System.out.printf("ERROR: %s", e.getMessage());
            Main.printUsage(parser, e);
        }
        if (this.config.isHelp()) {
            Main.printUsage(parser, null);
            this.canStart = false;
        }
        this.templates = this.canStart ? new GStringTemplateEngine() : null;
    }

    private static void printUsage(CmdLineParser parser, Exception error) {
        if (error != null) {
            System.err.println("Invalid option(s): " + error.getMessage());
            System.err.println();
        }
        System.err.println("Usage: $0 [OPTIONS] [<target-path>]");
        System.err.println();
        System.err.println();
        parser.setUsageWidth(System.getenv("COLUMNS") == null ? 100 : Integer.valueOf(System.getenv("COLUMNS")));
        parser.printUsage(System.err);
        System.err.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException, InvalidRemoteException, TransportException, GitAPIException {
        if (!this.canStart) {
            return;
        }
        this.start();
        DefaultVertx v = new DefaultVertx();
        this.setVertx(v);
        final GitManager git = new GitManager(this.config);
        final FreekiStore store = new FreekiStore(this.config, git);
        HashMap<String, String> rawTemplateConf = new HashMap<String, String>();
        rawTemplateConf.put("group@" + ContentType.TEXT_HTML.value(), "groovy/html/group.groovy");
        rawTemplateConf.put("page@" + ContentType.TEXT_HTML.value(), "groovy/html/page.groovy");
        rawTemplateConf.put("group@" + ContentType.TEXT_PLAIN.value(), "groovy/plain/group.groovy");
        rawTemplateConf.put("page@" + ContentType.TEXT_PLAIN.value(), "groovy/plain/page.groovy");
        GTemplateConfig templateConfig = new GTemplateConfig(rawTemplateConf, this.config);
        HashSet<ContentRenderer> renderers = new HashSet<ContentRenderer>();
        renderers.add(new GTHtmlRenderer(this.templates, templateConfig));
        renderers.add(new GTTextRenderer(this.templates, templateConfig));
        final JsonSerializer serializer = new JsonSerializer(new WebSerializationAdapter[0]);
        renderers.add(new JsonRenderer(serializer));
        final RenderingEngine engine = new RenderingEngine(renderers);
        final Authorizer authorizer = new Authorizer(this.config);
        final StaticContentHandler staticContent = new StaticContentHandler(this.config);
        HashSet<RouteHandler> handlers = new HashSet<RouteHandler>(){
            private static final long serialVersionUID = 1L;
            {
                this.add(new GroupContentHandler(store, engine, authorizer));
                this.add(new PageContentHandler(store, engine, authorizer));
                this.add(staticContent);
                this.add(new UpdateHandler(git));
                this.add(new TemplateContentHandler(new TemplateController(store, Main.this.config), serializer));
                this.add(new ExportContentHandler(Main.this.config, store));
            }
        };
        ServiceLoader<RouteCollection> collections = ServiceLoader.load(RouteCollection.class);
        ApplicationRouter router = new ApplicationRouter((Collection<RouteHandler>)handlers, collections);
        router.noMatch(staticContent);
        String listen = this.config.getListen();
        this.vertx.createHttpServer().requestHandler(router).listen(this.config.getPort(), listen);
        this.printDiagnostics(git, this.config);
        System.out.printf("Listening for requests on %s:%s\n\n", this.config.getListen(), this.config.getPort());
        Main main = this;
        synchronized (main) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void printDiagnostics(GitManager git, FreekiConfig config) {
        System.out.printf("Classpath:\n  %s\n\nGit 'origin' URL:\n  %s\n\nGit 'canonical' URL:\n  %s\n\nContent Directory:\n  %s\n\n", StringUtils.join((Object[])System.getProperty("java.class.path").split(":"), "\n  "), git.getOriginUrl(), git.getCanonicalUrl(), config.getContentDir().getAbsolutePath());
    }

    @Override
    public void stop() {
        Thread.currentThread().interrupt();
        this.vertx.stop();
    }
}

