/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.java;

import org.vertx.java.core.Vertx;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.platform.Container;
import org.vertx.java.platform.Verticle;
import org.vertx.java.platform.VerticleFactory;
import org.vertx.java.platform.impl.java.CompilingClassLoader;

public class JavaVerticleFactory
implements VerticleFactory {
    private ClassLoader cl;
    private Vertx vertx;
    private Container container;

    @Override
    public void init(Vertx vertx, Container container, ClassLoader cl) {
        this.cl = cl;
        this.vertx = vertx;
        this.container = container;
    }

    private static boolean isJavaSource(String main) {
        return main.endsWith(".java");
    }

    @Override
    public Verticle createVerticle(String main) throws Exception {
        Class<?> clazz;
        String className = main;
        if (JavaVerticleFactory.isJavaSource(main)) {
            CompilingClassLoader compilingLoader = new CompilingClassLoader(this.cl, main);
            className = compilingLoader.resolveMainClassName();
            clazz = compilingLoader.loadClass(className);
        } else {
            clazz = this.cl.loadClass(className);
        }
        Verticle verticle = (Verticle)clazz.newInstance();
        verticle.setVertx(this.vertx);
        verticle.setContainer(this.container);
        return verticle;
    }

    @Override
    public void reportException(Logger logger, Throwable t) {
        logger.error("Exception in Java verticle", t);
    }

    @Override
    public void close() {
    }
}

