/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.infra.route.anno.proc;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.codehaus.groovy.control.CompilationFailedException;
import org.commonjava.freeki.infra.route.RouteCollection;
import org.commonjava.freeki.infra.route.anno.Route;
import org.commonjava.freeki.infra.route.anno.Routes;
import org.commonjava.freeki.infra.route.anno.proc.RoutingTemplateInfo;

@SupportedAnnotationTypes(value={"javax.ws.rs.CookieParam", "javax.ws.rs.HeaderParam", "javax.ws.rs.PathParam", "javax.ws.rs.QueryParam", "javax.ws.rs.core.Context", "org.commonjava.freeki.infra.route.anno.Routes", "org.commonjava.freeki.infra.route.anno.Route"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class RoutingAnnotationProcessor
extends AbstractProcessor {
    public static final String TEMPLATE = "groovy/routes.groovy";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        System.out.println("Starting Route Processing...");
        HashSet<RoutingTemplateInfo> infos = new HashSet<RoutingTemplateInfo>();
        String pkg = null;
        for (Element element : roundEnv.getElementsAnnotatedWith(Routes.class)) {
            System.out.printf("Processing: %s\n", element);
            pkg = this.selectShortestPackage(pkg, element);
            Routes routes = element.getAnnotation(Routes.class);
            if (routes == null) continue;
            for (Route route : routes.value()) {
                infos.add(new RoutingTemplateInfo(element, route));
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Route.class)) {
            Route route = element.getAnnotation(Route.class);
            infos.add(new RoutingTemplateInfo(element, route));
            pkg = this.selectShortestPackage(pkg, element);
        }
        if (!infos.isEmpty()) {
            System.out.printf("Using package: %s\n", pkg);
            this.generateOutput(pkg, infos, roundEnv);
        }
        return true;
    }

    private String selectShortestPackage(String pkg, Element elem) {
        Element pe = elem;
        while ((pe = pe.getEnclosingElement()) != null && pe.getKind() != ElementKind.PACKAGE) {
        }
        String p = ((PackageElement)pe).getQualifiedName().toString();
        if (pkg == null || p.length() < pkg.length()) {
            System.out.printf("Setting package: %s\n", p);
            return p;
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateOutput(String pkg, Set<RoutingTemplateInfo> infos, RoundEnvironment roundEnv) {
        Template template;
        GStringTemplateEngine engine = new GStringTemplateEngine();
        URL resource = Thread.currentThread().getContextClassLoader().getResource(TEMPLATE);
        if (resource == null) {
            throw new IllegalStateException("Cannot find route template: groovy/routes.groovy");
        }
        try {
            template = engine.createTemplate(resource);
        }
        catch (IOException | ClassNotFoundException | CompilationFailedException e) {
            throw new IllegalStateException("Cannot load route template: groovy/routes.groovy. Reason: " + e.getMessage(), e);
        }
        System.out.printf("Package: %s\n", pkg);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pkg", pkg);
        params.put("routes", infos);
        Writable output = template.make(params);
        String clsName = pkg + ".Routes";
        System.out.printf("Generating routes class: %s\n", clsName);
        Filer filer = this.processingEnv.getFiler();
        Writer sourceWriter = null;
        try {
            JavaFileObject file = filer.createSourceFile(clsName, new Element[0]);
            sourceWriter = file.openWriter();
            output.writeTo(sourceWriter);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "While generating sources for routes class: '" + clsName + "', error: " + e.getMessage());
        }
        finally {
            if (sourceWriter != null) {
                try {
                    sourceWriter.close();
                }
                catch (IOException e) {}
            }
        }
        String resName = "META-INF/services/" + RouteCollection.class.getName();
        Writer svcWriter = null;
        try {
            FileObject file = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", resName, null);
            System.out.printf("Generating routes class service entry for: %s in: %s\n", clsName, file.toUri());
            svcWriter = file.openWriter();
            svcWriter.write(clsName);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "While generating service configuration for routes class: '" + resName + "', error: " + e.getMessage());
        }
        finally {
            if (svcWriter != null) {
                try {
                    svcWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

