/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.resolver;

import java.net.URI;
import org.vertx.java.core.Vertx;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.resolver.RepoResolver;

public abstract class HttpRepoResolver
implements RepoResolver {
    protected final Vertx vertx;
    protected final String repoHost;
    protected final int repoPort;
    protected final String contentRoot;

    public HttpRepoResolver(Vertx vertx, String repoID) {
        this.vertx = vertx;
        try {
            URI uri = new URI(repoID);
            this.repoHost = uri.getHost();
            int port = uri.getPort();
            if (port == -1) {
                port = 80;
            }
            this.repoPort = port;
            this.contentRoot = uri.getPath();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(repoID + " is not a valid repository identifier");
        }
    }

    @Override
    public abstract boolean getModule(String var1, ModuleIdentifier var2);
}

