/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.file.impl.ClasspathPathResolver;
import org.vertx.java.core.file.impl.ModuleFileSystemPathResolver;
import org.vertx.java.core.impl.CountingCompletionHandler;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.DefaultVertx;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.DecodeException;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.PlatformManagerException;
import org.vertx.java.platform.Verticle;
import org.vertx.java.platform.VerticleFactory;
import org.vertx.java.platform.impl.DefaultContainer;
import org.vertx.java.platform.impl.Deployment;
import org.vertx.java.platform.impl.ModuleClassLoader;
import org.vertx.java.platform.impl.ModuleFields;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.ModuleReference;
import org.vertx.java.platform.impl.ModuleReloader;
import org.vertx.java.platform.impl.PlatformManagerInternal;
import org.vertx.java.platform.impl.Redeployer;
import org.vertx.java.platform.impl.VerticleHolder;
import org.vertx.java.platform.impl.WrappedVertx;
import org.vertx.java.platform.impl.resolver.BintrayRepoResolver;
import org.vertx.java.platform.impl.resolver.MavenLocalRepoResolver;
import org.vertx.java.platform.impl.resolver.MavenRepoResolver;
import org.vertx.java.platform.impl.resolver.OldRepoResolver;
import org.vertx.java.platform.impl.resolver.RepoResolver;

public class DefaultPlatformManager
implements PlatformManagerInternal,
ModuleReloader {
    private static final Logger log = LoggerFactory.getLogger(DefaultPlatformManager.class);
    private static final int BUFFER_SIZE = 4096;
    private static final String MODS_DIR_PROP_NAME = "vertx.mods";
    private static final char COLON = ':';
    private static final String LANG_IMPLS_SYS_PROP_ROOT = "vertx.langs.";
    private static final String LANG_PROPS_FILE_NAME = "langs.properties";
    private static final String REPOS_FILE_NAME = "repos.txt";
    private static final String LOCAL_MODS_DIR = "mods";
    private static final String SYS_MODS_DIR = "sys-mods";
    private static final String VERTX_HOME_SYS_PROP = "vertx.home";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String MODULE_NAME_SYS_PROP = System.getProperty("vertx.modulename");
    private final VertxInternal vertx;
    private final Map<String, Deployment> deployments = new ConcurrentHashMap<String, Deployment>();
    private final File modRoot;
    private final File systemModRoot;
    private final ConcurrentMap<String, ModuleReference> moduleRefs = new ConcurrentHashMap<String, ModuleReference>();
    private final Redeployer redeployer;
    private final Map<String, LanguageImplInfo> languageImpls = new ConcurrentHashMap<String, LanguageImplInfo>();
    private final Map<String, String> extensionMappings = new ConcurrentHashMap<String, String>();
    private String defaultLanguageImplName;
    private final List<RepoResolver> repos = new ArrayList<RepoResolver>();
    private Handler<Void> exitHandler;
    private final ClassLoader platformClassLoader = Thread.currentThread().getContextClassLoader();
    private final boolean disableMavenLocal;

    DefaultPlatformManager() {
        this(new DefaultVertx());
    }

    DefaultPlatformManager(String hostname) {
        this(new DefaultVertx(hostname));
    }

    DefaultPlatformManager(int port, String hostname) {
        this(new DefaultVertx(port, hostname));
    }

    private DefaultPlatformManager(DefaultVertx vertx) {
        this.vertx = new WrappedVertx(vertx);
        String modDir = System.getProperty(MODS_DIR_PROP_NAME);
        this.modRoot = modDir != null && !modDir.trim().equals("") ? new File(modDir) : new File(LOCAL_MODS_DIR);
        String vertxHome = System.getProperty(VERTX_HOME_SYS_PROP);
        this.systemModRoot = vertxHome == null || modDir != null ? this.modRoot : new File(vertxHome, SYS_MODS_DIR);
        this.redeployer = new Redeployer(vertx, this);
        this.disableMavenLocal = System.getenv("VERTX_DISABLE_MAVENLOCAL") != null;
        this.loadLanguageMappings();
        this.loadRepos();
    }

    @Override
    public void registerExitHandler(Handler<Void> handler) {
        this.exitHandler = handler;
    }

    @Override
    public void deployVerticle(String main, JsonObject config, URL[] classpath, int instances, String includes, Handler<AsyncResult<String>> doneHandler) {
        this.deployVerticle(false, false, main, config, classpath, instances, includes, doneHandler);
    }

    @Override
    public void deployWorkerVerticle(boolean multiThreaded, String main, JsonObject config, URL[] classpath, int instances, String includes, Handler<AsyncResult<String>> doneHandler) {
        this.deployVerticle(true, multiThreaded, main, config, classpath, instances, includes, doneHandler);
    }

    @Override
    public void deployModule(final String moduleName, final JsonObject config, final int instances, Handler<AsyncResult<String>> doneHandler) {
        final File currentModDir = this.getDeploymentModDir();
        final Handler wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.deployModuleFromFileSystem(DefaultPlatformManager.this.modRoot, false, null, modID, config, instances, currentModDir, wrapped);
            }
        }, wrapped);
    }

    @Override
    public void deployModuleFromClasspath(final String moduleName, final JsonObject config, final int instances, final URL[] classpath, Handler<AsyncResult<String>> doneHandler) {
        final Handler wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.deployModuleFromCP(false, null, modID, config, instances, classpath, wrapped);
            }
        }, wrapped);
    }

    @Override
    public synchronized void undeploy(final String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                if (deploymentID == null) {
                    throw new NullPointerException("deploymentID cannot be null");
                }
                final Deployment dep = (Deployment)DefaultPlatformManager.this.deployments.get(deploymentID);
                if (dep == null) {
                    throw new PlatformManagerException("There is no deployment with id " + deploymentID);
                }
                Handler wrappedHandler = DefaultPlatformManager.this.wrapDoneHandler(new Handler<AsyncResult<Void>>(){

                    @Override
                    public void handle(AsyncResult<Void> res) {
                        if (res.succeeded() && dep.modID != null && dep.autoRedeploy) {
                            DefaultPlatformManager.this.redeployer.moduleUndeployed(dep);
                        }
                        if (doneHandler != null) {
                            doneHandler.handle(res);
                        } else if (res.failed()) {
                            log.error("Failed to undeploy", res.cause());
                        }
                    }
                });
                DefaultPlatformManager.this.doUndeploy(deploymentID, wrappedHandler);
            }
        }, this.wrapDoneHandler(doneHandler));
    }

    @Override
    public synchronized void undeployAll(Handler<AsyncResult<Void>> doneHandler) {
        ArrayList<String> parents = new ArrayList<String>();
        for (Map.Entry<String, Deployment> entry : this.deployments.entrySet()) {
            if (entry.getValue().parentDeploymentName != null) continue;
            parents.add(entry.getKey());
        }
        final CountingCompletionHandler count = new CountingCompletionHandler(this.vertx, parents.size());
        count.setHandler(doneHandler);
        for (String name : parents) {
            this.undeploy(name, new Handler<AsyncResult<Void>>(){

                @Override
                public void handle(AsyncResult<Void> res) {
                    if (res.failed()) {
                        count.failed(res.cause());
                    } else {
                        count.complete();
                    }
                }
            });
        }
    }

    @Override
    public Map<String, Integer> listInstances() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry<String, Deployment> entry : this.deployments.entrySet()) {
            map.put(entry.getKey(), entry.getValue().verticles.size());
        }
        return map;
    }

    @Override
    public void installModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        Handler wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.doInstallMod(modID);
                doneHandler.handle(new DefaultFutureResult<Void>((Void)null));
            }
        }, wrapped);
    }

    @Override
    public void uninstallModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        Handler wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                File modDir = new File(DefaultPlatformManager.this.modRoot, modID.toString());
                if (!modDir.exists()) {
                    throw new PlatformManagerException("Cannot find module to uninstall: " + moduleName);
                }
                DefaultPlatformManager.this.vertx.fileSystem().deleteSync(modDir.getAbsolutePath(), true);
                doneHandler.handle(new DefaultFutureResult<Void>((Void)null));
            }
        }, wrapped);
    }

    @Override
    public void pullInDependencies(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        Handler wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.doPullInDependencies(DefaultPlatformManager.this.modRoot, modID);
                doneHandler.handle(new DefaultFutureResult<Void>((Void)null));
            }
        }, wrapped);
    }

    @Override
    public void reloadModules(Set<Deployment> deps) {
        final HashSet<Deployment> parents = new HashSet<Deployment>();
        for (Deployment dep : deps) {
            parents.add(this.getTopMostDeployment(dep));
        }
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                for (final Deployment deployment : parents) {
                    if (DefaultPlatformManager.this.deployments.containsKey(deployment.name)) {
                        DefaultPlatformManager.this.doUndeploy(deployment.name, new Handler<AsyncResult<Void>>(){

                            @Override
                            public void handle(AsyncResult<Void> res) {
                                if (res.succeeded()) {
                                    DefaultPlatformManager.this.doRedeploy(deployment);
                                } else {
                                    log.error("Failed to undeploy", res.cause());
                                }
                            }
                        });
                        continue;
                    }
                    DefaultPlatformManager.this.doRedeploy(deployment);
                }
            }
        }, null);
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public void deployModuleFromZip(final String zipFileName, final JsonObject config, final int instances, Handler<AsyncResult<String>> doneHandler) {
        final Handler wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                if (zipFileName == null) {
                    throw new NullPointerException("zipFileName cannot be null");
                }
                ModuleZipInfo info = new ModuleZipInfo(false, zipFileName);
                ModuleIdentifier modID = new ModuleIdentifier("__vertx~" + UUID.randomUUID().toString() + "~__vertx");
                File modRoot = new File(TEMP_DIR + FILE_SEP + "vertx-zip-mods");
                File tempDir = new File(modRoot, modID.toString());
                tempDir.mkdirs();
                DefaultPlatformManager.this.unzipModuleData(tempDir, info, false);
                DefaultPlatformManager.this.deployModuleFromFileSystem(modRoot, false, null, modID, config, instances, null, wrapped);
            }
        }, wrapped);
    }

    @Override
    public void exit() {
        if (this.exitHandler != null) {
            this.exitHandler.handle(null);
        }
    }

    @Override
    public JsonObject config() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.config;
    }

    @Override
    public Logger logger() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.logger;
    }

    private void doRedeploy(final Deployment deployment) {
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                if (deployment.modDir != null) {
                    DefaultPlatformManager.this.deployModuleFromFileSystem(DefaultPlatformManager.this.modRoot, true, deployment.name, deployment.modID, deployment.config, deployment.instances, null, null);
                } else {
                    DefaultPlatformManager.this.deployModuleFromCP(true, deployment.name, deployment.modID, deployment.config, deployment.instances, deployment.classpath, null);
                }
            }
        }, null);
    }

    private <T> void runInBackground(final Runnable runnable, final Handler<AsyncResult<T>> doneHandler) {
        final DefaultContext context = this.vertx.getOrCreateContext();
        this.vertx.getBackgroundPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DefaultPlatformManager.this.vertx.setContext(context);
                    runnable.run();
                }
                catch (Throwable t) {
                    if (doneHandler != null) {
                        doneHandler.handle(new DefaultFutureResult<Throwable>(t));
                    } else {
                        log.error("Failed to run task", t);
                    }
                }
                finally {
                    DefaultPlatformManager.this.vertx.setContext(null);
                }
            }
        });
    }

    private void deployVerticle(final boolean worker, final boolean multiThreaded, final String main, final JsonObject config, URL[] classpath, final int instances, final String includes, Handler<AsyncResult<String>> doneHandler) {
        URL[] cp;
        final File currentModDir = this.getDeploymentModDir();
        if (classpath == null) {
            cp = this.getClasspath();
            if (cp == null) {
                throw new IllegalStateException("Cannot find parent classpath. Perhaps you are deploying the verticle from a non Vert.x thread?");
            }
        } else {
            cp = classpath;
        }
        final Handler wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                DefaultPlatformManager.this.doDeployVerticle(worker, multiThreaded, main, config, cp, instances, currentModDir, includes, wrapped);
            }
        }, wrapped);
    }

    private String getDeploymentName() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.name;
    }

    private URL[] getClasspath() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.classpath;
    }

    private File getDeploymentModDir() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.modDir;
    }

    private void doPullInDependencies(File modRoot, ModuleIdentifier modID) {
        String deploys;
        JsonObject conf;
        File modDir = new File(modRoot, modID.toString());
        if (!modDir.exists()) {
            log.error("Cannot find module to uninstall");
        }
        if ((conf = this.loadModuleConfig(modID, modDir)) == null) {
            log.error("Module " + modID + " does not contain a mod.json");
        }
        ModuleFields fields = new ModuleFields(conf);
        ArrayList<String> mods = new ArrayList<String>();
        String includes = fields.getIncludes();
        if (includes != null) {
            mods.addAll(Arrays.asList(DefaultPlatformManager.parseIncludeString(includes)));
        }
        if ((deploys = fields.getDeploys()) != null) {
            mods.addAll(Arrays.asList(DefaultPlatformManager.parseIncludeString(deploys)));
        }
        if (!mods.isEmpty()) {
            File internalModsDir = new File(modDir, LOCAL_MODS_DIR);
            if (!internalModsDir.exists() && !internalModsDir.mkdir()) {
                throw new PlatformManagerException("Failed to create directory " + internalModsDir);
            }
            for (String modName : mods) {
                File internalModDir = new File(internalModsDir, modName);
                if (internalModDir.exists()) continue;
                ModuleIdentifier theModID = new ModuleIdentifier(modName);
                ModuleZipInfo zipInfo = this.getModule(theModID);
                if (zipInfo.filename == null) continue;
                if (!internalModDir.mkdir()) {
                    throw new PlatformManagerException("Failed to create directory " + internalModDir);
                }
                this.unzipModuleData(internalModDir, zipInfo, true);
                log.info("Module " + modName + " successfully installed in mods dir of " + modName);
                this.doPullInDependencies(internalModsDir, theModID);
            }
        }
    }

    private <T> Handler<AsyncResult<T>> wrapDoneHandler(final Handler<AsyncResult<T>> doneHandler) {
        if (doneHandler == null) {
            return new AsyncResultHandler<T>(){

                @Override
                public void handle(AsyncResult<T> res) {
                    if (res.failed()) {
                        DefaultPlatformManager.this.vertx.reportException(res.cause());
                    }
                }
            };
        }
        final DefaultContext context = this.vertx.getContext();
        return new AsyncResultHandler<T>(){

            @Override
            public void handle(final AsyncResult<T> res) {
                if (context == null) {
                    doneHandler.handle(res);
                } else {
                    context.execute(new Runnable(){

                        @Override
                        public void run() {
                            doneHandler.handle(res);
                        }
                    });
                }
            }
        };
    }

    private ModuleIdentifier getEnclosingModID() {
        Deployment dep;
        VerticleHolder holder = this.getVerticleHolder();
        Deployment deployment = dep = holder == null ? null : holder.deployment;
        while (dep != null) {
            if (dep.modID != null) {
                return dep.modID;
            }
            String parentDepName = dep.parentDeploymentName;
            if (parentDepName != null) {
                dep = this.deployments.get(parentDepName);
                continue;
            }
            return ModuleIdentifier.createInternalModIDForVerticle(dep.name);
        }
        return null;
    }

    private Deployment getTopMostDeployment(Deployment dep) {
        String parentDep;
        while ((parentDep = dep.parentDeploymentName) != null) {
            dep = this.deployments.get(parentDep);
        }
        return dep;
    }

    private void doDeployVerticle(boolean worker, boolean multiThreaded, String main, JsonObject config, URL[] urls, int instances, File currentModDir, String includes, Handler<AsyncResult<String>> doneHandler) {
        ModuleReference prev;
        DefaultPlatformManager.checkWorkerContext();
        if (main == null) {
            throw new NullPointerException("main cannot be null");
        }
        if (urls == null) {
            throw new IllegalStateException("deployment classpath for deploy is null");
        }
        String depName = DefaultPlatformManager.genDepName();
        ModuleIdentifier enclosingModName = this.getEnclosingModID();
        String moduleKey = enclosingModName == null ? ModuleIdentifier.createInternalModIDForVerticle(depName).toString() : enclosingModName.toString() + "#" + main;
        ModuleReference mr = (ModuleReference)this.moduleRefs.get(moduleKey);
        if (mr == null && (prev = this.moduleRefs.putIfAbsent(moduleKey, mr = new ModuleReference(this, moduleKey, new ModuleClassLoader(this.platformClassLoader, urls, false), false))) != null) {
            mr = prev;
        }
        if (enclosingModName != null) {
            ModuleReference parentRef = (ModuleReference)this.moduleRefs.get(enclosingModName.toString());
            mr.mcl.addParent(parentRef);
            parentRef.incRef();
        }
        if (includes != null) {
            this.loadIncludedModules(this.modRoot, currentModDir, mr, includes);
        }
        this.doDeploy(depName, false, worker, multiThreaded, main, null, config, urls, instances, currentModDir, mr, this.modRoot, doneHandler);
    }

    private static void checkWorkerContext() {
        Thread t = Thread.currentThread();
        if (!t.getName().startsWith("vert.x-worker-thread")) {
            throw new IllegalStateException("Not a worker thread");
        }
    }

    private void loadLanguageMappings() {
        this.languageImpls.put("java", new LanguageImplInfo(null, "org.vertx.java.platform.impl.java.JavaVerticleFactory"));
        this.extensionMappings.put("java", "java");
        this.extensionMappings.put("class", "java");
        this.defaultLanguageImplName = "java";
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(LANG_PROPS_FILE_NAME);){
            if (is != null) {
                Properties props = new Properties();
                props.load(new BufferedInputStream(is));
                this.loadLanguageMappings(props);
            }
        }
        catch (IOException e) {
            throw new PlatformManagerException(e);
        }
        Properties sysProps = new Properties();
        Set<String> propertyNames = System.getProperties().stringPropertyNames();
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith(LANG_IMPLS_SYS_PROP_ROOT)) continue;
            String lang = propertyName.substring(LANG_IMPLS_SYS_PROP_ROOT.length());
            String value = System.getProperty(propertyName);
            sysProps.put(lang, value);
        }
        this.loadLanguageMappings(sysProps);
    }

    private void loadLanguageMappings(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            String propVal = props.getProperty(propName);
            if (propName.startsWith(".")) {
                if (propName.equals(".")) {
                    this.defaultLanguageImplName = propVal;
                    continue;
                }
                propName = propName.substring(1);
                this.extensionMappings.put(propName, propVal);
                continue;
            }
            int colonIndex = propVal.lastIndexOf(58);
            if (colonIndex == -1) {
                throw new PlatformManagerException("Language mapping: " + propVal + " does not specify an implementing module");
            }
            String moduleName = propVal.substring(0, colonIndex);
            String factoryName = propVal.substring(colonIndex + 1);
            LanguageImplInfo langImpl = new LanguageImplInfo(moduleName, factoryName);
            this.languageImpls.put(propName, langImpl);
            this.extensionMappings.put(propName, propName);
        }
    }

    private File locateModule(File modRoot, File currentModDir, ModuleIdentifier modID) {
        File modDir;
        if (currentModDir != null && (modDir = new File(new File(currentModDir, LOCAL_MODS_DIR), modID.toString())).exists()) {
            return modDir;
        }
        modDir = new File(modRoot, modID.toString());
        if (modDir.exists()) {
            return modDir;
        }
        if (!this.systemModRoot.equals(modRoot) && (modDir = new File(this.systemModRoot, modID.toString())).exists()) {
            return modDir;
        }
        return null;
    }

    private void deployModuleFromModJson(final boolean redeploy, JsonObject modJSON, String depName, ModuleIdentifier modID, JsonObject config, int instances, File modDir, File currentModDir, List<URL> moduleClasspath, File modRoot, final Handler<AsyncResult<String>> doneHandler) {
        String includes;
        ModuleIdentifier enclosingModID;
        ModuleFields fields = new ModuleFields(modJSON);
        String main = fields.getMain();
        if (main == null) {
            throw new PlatformManagerException("Runnable module " + modID + " mod.json must contain a \"main\" field");
        }
        boolean worker = fields.isWorker();
        boolean multiThreaded = fields.isMultiThreaded();
        if (multiThreaded && !worker) {
            throw new PlatformManagerException("Multi-threaded modules must be workers");
        }
        boolean preserveCwd = fields.isPreserveCurrentWorkingDirectory();
        File modDirToUse = preserveCwd ? currentModDir : modDir;
        ModuleReference mr = (ModuleReference)this.moduleRefs.get(modID.toString());
        if (mr == null) {
            boolean res = fields.isResident();
            mr = new ModuleReference(this, modID.toString(), new ModuleClassLoader(this.platformClassLoader, moduleClasspath.toArray(new URL[moduleClasspath.size()]), fields.isLoadResourcesWithTCCL()), res);
            ModuleReference prev = this.moduleRefs.putIfAbsent(modID.toString(), mr);
            if (prev != null) {
                mr = prev;
            }
        }
        if ((enclosingModID = this.getEnclosingModID()) != null) {
            ModuleReference parentRef = (ModuleReference)this.moduleRefs.get(enclosingModID.toString());
            mr.mcl.addParent(parentRef);
            parentRef.incRef();
        }
        if ((includes = fields.getIncludes()) != null) {
            this.loadIncludedModules(modRoot, modDir, mr, includes);
        }
        final boolean autoRedeploy = fields.isAutoRedeploy();
        this.doDeploy(depName, autoRedeploy, worker, multiThreaded, main, modID, config, moduleClasspath.toArray(new URL[moduleClasspath.size()]), instances, modDirToUse, mr, modRoot, new Handler<AsyncResult<String>>(){

            @Override
            public void handle(AsyncResult<String> res) {
                String deploymentID;
                if (res.succeeded() && (deploymentID = res.result()) != null && !redeploy && autoRedeploy) {
                    DefaultPlatformManager.this.redeployer.moduleDeployed((Deployment)DefaultPlatformManager.this.deployments.get(deploymentID));
                }
                if (doneHandler != null) {
                    doneHandler.handle(res);
                } else if (res.failed()) {
                    log.error("Failed to deploy", res.cause());
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadModJSONFromClasspath(ModuleIdentifier modID, ClassLoader cl) {
        try {
            ArrayList<URL> urls = Collections.list(cl.getResources("mod.json"));
            if (urls.size() < 1) {
                return null;
            }
            try (Scanner scanner = new Scanner(((URL)urls.get(0)).openStream()).useDelimiter("\\A");){
                String conf = scanner.next();
                JsonObject jsonObject = new JsonObject(conf);
                return jsonObject;
            }
            catch (NoSuchElementException e) {
                throw new PlatformManagerException("Module " + modID + " contains an empty mod.json file");
            }
            catch (DecodeException e) {
                throw new PlatformManagerException("Module " + modID + " mod.json contains invalid json");
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private void deployModuleFromCP(boolean redeploy, String depName, ModuleIdentifier modID, JsonObject config, int instances, URL[] classpath, Handler<AsyncResult<String>> doneHandler) {
        DefaultPlatformManager.checkWorkerContext();
        JsonObject modJSON = this.loadModJSONFromClasspath(modID, new URLClassLoader(classpath, this.platformClassLoader));
        if (modJSON == null) {
            throw new PlatformManagerException("Failed to find mod.json on classpath");
        }
        File modDir = this.locateModule(this.modRoot, null, modID);
        ArrayList<URL> cpList = new ArrayList<URL>(Arrays.asList(classpath));
        if (modDir != null) {
            cpList.addAll(this.getModuleClasspath(modDir));
        }
        this.deployModuleFromModJson(redeploy, modJSON, depName, modID, config, instances, null, null, cpList, this.modRoot, doneHandler);
    }

    private void deployModuleFromFileSystem(File modRoot, boolean redeploy, String depName, ModuleIdentifier modID, JsonObject config, int instances, File currentModDir, Handler<AsyncResult<String>> doneHandler) {
        DefaultPlatformManager.checkWorkerContext();
        File modDir = this.locateModule(modRoot, currentModDir, modID);
        if (modDir != null) {
            JsonObject modJSON = this.loadModuleConfig(modID, modDir);
            List<URL> urls = this.getModuleClasspath(modDir);
            this.deployModuleFromModJson(redeploy, modJSON, depName, modID, config, instances, modDir, currentModDir, urls, modRoot, doneHandler);
        } else {
            JsonObject modJSON = modID.toString().equals(MODULE_NAME_SYS_PROP) ? this.loadModJSONFromClasspath(modID, this.platformClassLoader) : null;
            if (modJSON != null) {
                this.deployModuleFromModJson(redeploy, modJSON, depName, modID, config, instances, modDir, currentModDir, new ArrayList<URL>(), modRoot, doneHandler);
            } else {
                this.doInstallMod(modID);
                this.deployModuleFromFileSystem(modRoot, redeploy, depName, modID, config, instances, currentModDir, doneHandler);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadModuleConfig(ModuleIdentifier modID, File modDir) {
        try (Scanner scanner = new Scanner(new File(modDir, "mod.json")).useDelimiter("\\A");){
            String conf = scanner.next();
            JsonObject jsonObject = new JsonObject(conf);
            return jsonObject;
        }
        catch (FileNotFoundException e) {
            throw new PlatformManagerException("Module " + modID + " does not contain a mod.json file");
        }
        catch (NoSuchElementException e) {
            throw new PlatformManagerException("Module " + modID + " contains an empty mod.json file");
        }
        catch (DecodeException e) {
            throw new PlatformManagerException("Module " + modID + " mod.json contains invalid json");
        }
    }

    private void loadIncludedModules(File modRoot, File currentModuleDir, ModuleReference mr, String includesString) {
        DefaultPlatformManager.checkWorkerContext();
        for (String moduleName : DefaultPlatformManager.parseIncludeString(includesString)) {
            ModuleIdentifier modID = new ModuleIdentifier(moduleName);
            ModuleReference includedMr = (ModuleReference)this.moduleRefs.get(moduleName);
            if (includedMr == null) {
                String includes;
                File modDir = this.locateModule(modRoot, currentModuleDir, modID);
                if (modDir == null) {
                    this.doInstallMod(modID);
                }
                modDir = this.locateModule(modRoot, currentModuleDir, modID);
                List<URL> urls = this.getModuleClasspath(modDir);
                JsonObject conf = this.loadModuleConfig(modID, modDir);
                ModuleFields fields = new ModuleFields(conf);
                boolean res = fields.isResident();
                includedMr = new ModuleReference(this, moduleName, new ModuleClassLoader(this.platformClassLoader, urls.toArray(new URL[urls.size()]), fields.isLoadResourcesWithTCCL()), res);
                ModuleReference prev = this.moduleRefs.putIfAbsent(moduleName, includedMr);
                if (prev != null) {
                    includedMr = prev;
                }
                if ((includes = fields.getIncludes()) != null) {
                    this.loadIncludedModules(modRoot, modDir, includedMr, includes);
                }
            }
            includedMr.incRef();
            mr.mcl.addParent(includedMr);
        }
    }

    private List<URL> getModuleClasspath(File modDir) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            if (modDir.exists()) {
                urls.add(modDir.toURI().toURL());
                File libDir = new File(modDir, "lib");
                if (libDir.exists()) {
                    File[] jars;
                    for (File jar : jars = libDir.listFiles()) {
                        URL jarURL = jar.toURI().toURL();
                        urls.add(jarURL);
                    }
                }
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new PlatformManagerException(e);
        }
    }

    private static String[] parseIncludeString(String sincludes) {
        if ("".equals(sincludes = sincludes.trim())) {
            log.error("Empty include string");
            return null;
        }
        String[] arr = sincludes.split(",");
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = arr[i].trim();
            }
        }
        return arr;
    }

    private void loadRepos() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(REPOS_FILE_NAME);){
            if (is != null) {
                String line;
                BufferedReader rdr = new BufferedReader(new InputStreamReader(is));
                block23: while ((line = rdr.readLine()) != null) {
                    RepoResolver resolver;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    int colonPos = line.indexOf(58);
                    if (colonPos == -1 || colonPos == line.length() - 1) {
                        throw new IllegalArgumentException("Invalid repo: " + line);
                    }
                    String type = line.substring(0, colonPos);
                    String repoID = line.substring(colonPos + 1);
                    switch (type) {
                        case "mavenLocal": {
                            if (this.disableMavenLocal) continue block23;
                            resolver = new MavenLocalRepoResolver(repoID);
                            break;
                        }
                        case "maven": {
                            resolver = new MavenRepoResolver(this.vertx, repoID);
                            break;
                        }
                        case "bintray": {
                            resolver = new BintrayRepoResolver(this.vertx, repoID);
                            break;
                        }
                        case "old": {
                            resolver = new OldRepoResolver(this.vertx, repoID);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown repo type: " + type);
                        }
                    }
                    this.repos.add(resolver);
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to load langs.properties " + e.getMessage());
        }
    }

    private void doInstallMod(ModuleIdentifier modID) {
        DefaultPlatformManager.checkWorkerContext();
        if (this.repos.isEmpty()) {
            throw new PlatformManagerException("No repositories configured!");
        }
        if (this.locateModule(this.modRoot, null, modID) != null) {
            throw new PlatformManagerException("Module is already installed");
        }
        ModuleZipInfo info = this.getModule(modID);
        this.unzipModule(modID, info, true);
    }

    private ModuleZipInfo getModule(ModuleIdentifier modID) {
        String fileName = DefaultPlatformManager.generateTmpFileName() + ".zip";
        for (RepoResolver resolver : this.repos) {
            if (!resolver.getModule(fileName, modID)) continue;
            return new ModuleZipInfo(resolver.isOldStyle(), fileName);
        }
        throw new PlatformManagerException("Module " + modID + " not found in any repositories");
    }

    private static String generateTmpFileName() {
        return TEMP_DIR + FILE_SEP + "vertx-" + UUID.randomUUID().toString();
    }

    private File unzipIntoTmpDir(ModuleZipInfo zipInfo, boolean deleteZip) {
        String tdir = DefaultPlatformManager.generateTmpFileName();
        File tdest = new File(tdir);
        if (!tdest.mkdir()) {
            throw new PlatformManagerException("Failed to create directory " + tdest);
        }
        this.unzipModuleData(tdest, zipInfo, deleteZip);
        return tdest;
    }

    private void checkCreateModDirs() {
        this.checkCreateRoot(this.modRoot);
        this.checkCreateRoot(this.systemModRoot);
    }

    private void checkCreateRoot(File modRoot) {
        if (!modRoot.exists()) {
            String smodRoot;
            try {
                smodRoot = modRoot.getCanonicalPath();
            }
            catch (IOException e) {
                throw new PlatformManagerException(e);
            }
            this.vertx.fileSystem().mkdirSync(smodRoot, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipModule(ModuleIdentifier modID, ModuleZipInfo zipInfo, boolean deleteZip) {
        String modName = modID.toString();
        String string = modName.intern();
        synchronized (string) {
            this.checkCreateModDirs();
            File fdest = new File(this.modRoot, modName);
            File sdest = new File(this.systemModRoot, modName);
            if (fdest.exists() || sdest.exists()) {
                log.warn("Module " + modID + " is already installed");
                return;
            }
            File tdest = this.unzipIntoTmpDir(zipInfo, deleteZip);
            JsonObject conf = this.loadModuleConfig(modID, tdest);
            ModuleFields fields = new ModuleFields(conf);
            boolean system = fields.isSystem();
            String moveFrom = tdest.getAbsolutePath();
            this.safeMove(moveFrom, system ? sdest.getAbsolutePath() : fdest.getAbsolutePath());
            log.info("Module " + modID + " successfully installed");
        }
    }

    private void safeMove(String source, String dest) {
        try {
            this.vertx.fileSystem().moveSync(source, dest);
        }
        catch (Exception e) {
            try {
                this.vertx.fileSystem().copySync(source, dest, true);
                this.vertx.fileSystem().deleteSync(source, true);
            }
            catch (Exception e2) {
                throw new PlatformManagerException("Failed to copy module", e2);
            }
        }
    }

    private String removeTopDir(String entry) {
        int pos = entry.indexOf(FILE_SEP);
        if (pos != -1) {
            entry = entry.substring(pos + 1);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzipModuleData(File directory, ModuleZipInfo zipinfo, boolean deleteZip) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(zipinfo.filename));
             ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = zipinfo.oldStyle ? this.removeTopDir(entry.getName()) : entry.getName();
                if (entryName.isEmpty()) continue;
                if (entry.isDirectory()) {
                    if (new File(directory, entryName).mkdir()) continue;
                    throw new PlatformManagerException("Failed to create directory");
                }
                byte[] buff = new byte[4096];
                FilterOutputStream dest = null;
                try {
                    int count;
                    FileOutputStream fos = new FileOutputStream(new File(directory, entryName));
                    dest = new BufferedOutputStream(fos, 4096);
                    while ((count = zis.read(buff, 0, 4096)) != -1) {
                        ((BufferedOutputStream)dest).write(buff, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                }
                finally {
                    if (dest == null) continue;
                    dest.close();
                }
            }
            return;
        }
        catch (Exception e) {
            throw new PlatformManagerException("Failed to unzip module", e);
        }
        finally {
            if (deleteZip && !new File(zipinfo.filename).delete()) {
                log.error("Failed to delete zip");
            }
        }
    }

    private void setPathResolver(ModuleIdentifier modID, File modDir) {
        DefaultContext context = this.vertx.getContext();
        if (modDir != null) {
            Path cwd = Paths.get(".", new String[0]).toAbsolutePath().getParent();
            Path pmodDir = Paths.get(modDir.getAbsolutePath(), new String[0]);
            Path relative = cwd.relativize(pmodDir);
            context.setPathResolver(new ModuleFileSystemPathResolver(relative));
        } else if (modID != null) {
            context.setPathResolver(new ClasspathPathResolver());
        }
    }

    private static String genDepName() {
        return "deployment-" + UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeploy(String depID, boolean autoRedeploy, boolean worker, boolean multiThreaded, String theMain, final ModuleIdentifier modID, JsonObject config, URL[] urls, int instances, final File modDir, ModuleReference mr, File modRoot, Handler<AsyncResult<String>> dHandler) {
        VerticleFactory verticleFactory;
        String parentDeploymentName;
        String extension;
        String langImplName;
        int extensionMarker;
        String main;
        DefaultPlatformManager.checkWorkerContext();
        if (dHandler == null) {
            dHandler = new Handler<AsyncResult<String>>(){

                @Override
                public void handle(AsyncResult<String> ar) {
                    if (ar.failed()) {
                        log.error("Failed to deploy", ar.cause());
                    }
                }
            };
        }
        final Handler<AsyncResult<String>> doneHandler = dHandler;
        final String deploymentID = depID != null ? depID : DefaultPlatformManager.genDepName();
        log.debug("Deploying name : " + deploymentID + " main: " + theMain + " instances: " + instances);
        LanguageImplInfo langImplInfo = null;
        int prefixMarker = theMain.indexOf(58);
        if (prefixMarker != -1) {
            String prefix = theMain.substring(0, prefixMarker);
            langImplInfo = this.languageImpls.get(prefix);
            if (langImplInfo == null) {
                throw new IllegalStateException("No language implementation known for prefix " + prefix);
            }
            main = theMain.substring(prefixMarker + 1);
        } else {
            main = theMain;
        }
        if (langImplInfo == null && (extensionMarker = main.lastIndexOf(46)) != -1 && (langImplName = this.extensionMappings.get(extension = main.substring(extensionMarker + 1))) != null && (langImplInfo = this.languageImpls.get(langImplName)) == null) {
            throw new IllegalStateException("Extension mapping for " + extension + " specified as " + langImplName + ", but no language implementation known for that name");
        }
        if (langImplInfo == null && (langImplInfo = this.languageImpls.get(this.defaultLanguageImplName)) == null) {
            throw new IllegalStateException("Default language implementation is " + this.defaultLanguageImplName + " but no language implementation known for that name");
        }
        if (langImplInfo.moduleName != null) {
            this.loadIncludedModules(modRoot, modDir, mr, langImplInfo.moduleName);
        }
        if ((parentDeploymentName = this.getDeploymentName()) != null) {
            Deployment parentDeployment = this.deployments.get(parentDeploymentName);
            if (parentDeployment == null) {
                throw new PlatformManagerException("Parent has already been undeployed!");
            }
            parentDeployment.childDeployments.add(deploymentID);
        }
        try {
            verticleFactory = mr.getVerticleFactory(langImplInfo.factoryName, this.vertx, new DefaultContainer(this));
        }
        catch (Throwable t) {
            throw new PlatformManagerException("Failed to instantiate verticle factory", t);
        }
        final CountingCompletionHandler<Void> aggHandler = new CountingCompletionHandler<Void>(this.vertx, instances);
        aggHandler.setHandler(new Handler<AsyncResult<Void>>(){

            @Override
            public void handle(AsyncResult<Void> res) {
                if (res.failed()) {
                    doneHandler.handle(new DefaultFutureResult<Throwable>(res.cause()));
                } else {
                    doneHandler.handle(new DefaultFutureResult<String>(deploymentID));
                }
            }
        });
        final Deployment deployment = new Deployment(deploymentID, main, modID, instances, config == null ? new JsonObject() : config.copy(), urls, modDir, parentDeploymentName, mr, autoRedeploy);
        mr.incRef();
        this.deployments.put(deploymentID, deployment);
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(mr.mcl);
        try {
            for (int i = 0; i < instances; ++i) {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        Verticle verticle;
                        try {
                            verticle = verticleFactory.createVerticle(main);
                        }
                        catch (Throwable t) {
                            DefaultPlatformManager.this.handleDeployFailure(t, deploymentID, aggHandler);
                            return;
                        }
                        try {
                            DefaultPlatformManager.this.addVerticle(deployment, verticle, verticleFactory, modID, main);
                            DefaultPlatformManager.this.setPathResolver(modID, modDir);
                            DefaultFutureResult<Void> vr = new DefaultFutureResult<Void>();
                            verticle.start(vr);
                            vr.setHandler((Handler)new Handler<AsyncResult<Void>>(){

                                @Override
                                public void handle(AsyncResult<Void> ar) {
                                    if (ar.succeeded()) {
                                        aggHandler.complete();
                                    } else {
                                        DefaultPlatformManager.this.handleDeployFailure(ar.cause(), deploymentID, aggHandler);
                                    }
                                }
                            });
                        }
                        catch (Throwable t) {
                            DefaultPlatformManager.this.handleDeployFailure(t, deploymentID, aggHandler);
                        }
                    }
                };
                if (worker) {
                    this.vertx.startInBackground(runner, multiThreaded);
                    continue;
                }
                this.vertx.startOnEventLoop(runner);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    private void handleDeployFailure(final Throwable t, String deploymentID, final CountingCompletionHandler<Void> handler) {
        this.doUndeploy(deploymentID, new Handler<AsyncResult<Void>>(){

            @Override
            public void handle(AsyncResult<Void> res) {
                if (res.failed()) {
                    DefaultPlatformManager.this.vertx.reportException(res.cause());
                }
                handler.failed(t);
            }
        });
    }

    private void addVerticle(Deployment deployment, Verticle verticle, VerticleFactory factory, ModuleIdentifier modID, String main) {
        String loggerName = modID + "-" + main + "-" + System.identityHashCode(verticle);
        Logger logger = LoggerFactory.getLogger(loggerName);
        DefaultContext context = this.vertx.getContext();
        VerticleHolder holder = new VerticleHolder(deployment, context, verticle, loggerName, logger, deployment.config, factory);
        deployment.verticles.add(holder);
        context.setDeploymentHandle(holder);
    }

    private VerticleHolder getVerticleHolder() {
        DefaultContext context = this.vertx.getContext();
        if (context != null) {
            return (VerticleHolder)context.getDeploymentHandle();
        }
        return null;
    }

    private void doUndeploy(String name, Handler<AsyncResult<Void>> doneHandler) {
        CountingCompletionHandler<Void> count = new CountingCompletionHandler<Void>(this.vertx);
        this.doUndeploy(name, count);
        if (doneHandler != null) {
            count.setHandler(doneHandler);
        } else {
            count.setHandler(new Handler<AsyncResult<Void>>(){

                @Override
                public void handle(AsyncResult<Void> asyncResult) {
                    if (asyncResult.failed()) {
                        log.error("Failed to undeploy", asyncResult.cause());
                    }
                }
            });
        }
    }

    private void doUndeploy(String name, final CountingCompletionHandler<Void> parentCount) {
        Deployment parent;
        if (name == null) {
            throw new NullPointerException("deployment id is null");
        }
        final Deployment deployment = this.deployments.remove(name);
        if (deployment == null) {
            parentCount.incRequired();
            parentCount.complete();
            return;
        }
        final CountingCompletionHandler<Void> count = new CountingCompletionHandler<Void>(this.vertx);
        parentCount.incRequired();
        for (String childDeployment : deployment.childDeployments) {
            this.doUndeploy(childDeployment, count);
        }
        if (!deployment.verticles.isEmpty()) {
            for (final VerticleHolder holder : deployment.verticles) {
                count.incRequired();
                holder.context.execute(new Runnable(){

                    @Override
                    public void run() {
                        holder.verticle.stop();
                        LoggerFactory.removeLogger(holder.loggerName);
                        holder.context.runCloseHooks((Handler<AsyncResult<Void>>)new AsyncResultHandler<Void>(){

                            @Override
                            public void handle(AsyncResult<Void> asyncResult) {
                                holder.context.close();
                                if (asyncResult.failed()) {
                                    count.failed(asyncResult.cause());
                                } else {
                                    count.complete();
                                }
                            }
                        });
                    }
                });
            }
        }
        if (deployment.parentDeploymentName != null && (parent = this.deployments.get(deployment.parentDeploymentName)) != null) {
            parent.childDeployments.remove(name);
        }
        count.setHandler(new Handler<AsyncResult<Void>>(){

            @Override
            public void handle(AsyncResult<Void> res) {
                deployment.moduleReference.decRef();
                if (res.failed()) {
                    parentCount.failed(res.cause());
                } else {
                    parentCount.complete();
                }
            }
        });
    }

    @Override
    public void stop() {
        this.redeployer.close();
        this.vertx.stop();
    }

    @Override
    public int checkNoModules() {
        int count = 0;
        for (Map.Entry entry : this.moduleRefs.entrySet()) {
            if (((ModuleReference)entry.getValue()).resident) continue;
            System.out.println("Module remains: " + (String)entry.getKey());
            ++count;
        }
        return count;
    }

    @Override
    public void removeModule(String moduleKey) {
        this.moduleRefs.remove(moduleKey);
    }

    private static final class ModuleZipInfo {
        final boolean oldStyle;
        final String filename;

        private ModuleZipInfo(boolean oldStyle, String filename) {
            this.oldStyle = oldStyle;
            this.filename = filename;
        }
    }

    private static class LanguageImplInfo {
        final String moduleName;
        final String factoryName;

        private LanguageImplInfo(String moduleName, String factoryName) {
            this.moduleName = moduleName;
            this.factoryName = factoryName;
        }

        public String toString() {
            return (this.moduleName == null ? ":" : this.moduleName + ":") + this.factoryName;
        }
    }
}

