/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.UUID;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.ConnectionBase;

public class DefaultNetSocket
extends ConnectionBase
implements NetSocket {
    private final String writeHandlerID = UUID.randomUUID().toString();
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Void> drainHandler;
    private final Handler<Message<Buffer>> writeHandler = new Handler<Message<Buffer>>(){

        @Override
        public void handle(Message<Buffer> msg) {
            DefaultNetSocket.this.write(msg.body());
        }
    };
    private ChannelFuture writeFuture;

    public DefaultNetSocket(VertxInternal vertx, Channel channel, DefaultContext context) {
        super(vertx, channel, context);
        vertx.eventBus().registerLocalHandler(this.writeHandlerID, this.writeHandler);
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public NetSocket write(Buffer data) {
        ByteBuf buf = data.getByteBuf();
        this.doWrite(buf);
        return this;
    }

    @Override
    public NetSocket write(String str) {
        this.doWrite(Unpooled.copiedBuffer(str, CharsetUtil.UTF_8));
        return this;
    }

    @Override
    public NetSocket write(String str, String enc) {
        if (enc == null) {
            this.write(str);
        } else {
            this.doWrite(Unpooled.copiedBuffer(str, Charset.forName(enc)));
        }
        return this;
    }

    @Override
    public NetSocket dataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
        return this;
    }

    @Override
    public NetSocket pause() {
        this.doPause();
        return this;
    }

    @Override
    public NetSocket resume() {
        this.doResume();
        return this;
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.doWriteQueueFull();
    }

    @Override
    public NetSocket endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public NetSocket drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        this.vertx.runOnContext(new VoidHandler(){

            @Override
            public void handle() {
                DefaultNetSocket.this.callDrainHandler();
            }
        });
        return this;
    }

    @Override
    public NetSocket sendFile(String filename) {
        File f = new File(PathAdjuster.adjust(this.vertx, filename));
        super.sendFile(f);
        return this;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return super.localAddress();
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public NetSocket closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    @Override
    public void close() {
        if (this.writeFuture != null) {
            this.writeFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    DefaultNetSocket.this.channel.close();
                }
            });
        } else {
            this.channel.close();
        }
    }

    @Override
    protected DefaultContext getContext() {
        return super.getContext();
    }

    @Override
    protected void handleClosed() {
        this.setContext();
        if (this.endHandler != null) {
            try {
                this.endHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
        super.handleClosed();
        if (this.vertx.eventBus() != null) {
            this.vertx.eventBus().unregisterHandler(this.writeHandlerID, this.writeHandler);
        }
    }

    @Override
    public void handleInterestedOpsChanged() {
        this.setContext();
        this.callDrainHandler();
    }

    void handleDataReceived(Buffer data) {
        if (this.dataHandler != null) {
            this.setContext();
            try {
                this.dataHandler.handle(data);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    private void doWrite(ByteBuf buff) {
        this.writeFuture = this.channel.writeAndFlush(buff);
    }

    private void callDrainHandler() {
        if (this.drainHandler != null && !this.writeQueueFull()) {
            try {
                this.drainHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }
}

