/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.commonjava.freeki.util.UrlInfo;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static String stringQueryParameter(Object value) {
        String base = String.valueOf(value);
        return "%22" + base + "%22";
    }

    public static String siblingDatabaseUrl(String dbUrl, String siblingName) {
        if (StringUtils.isEmpty(dbUrl)) {
            throw new IllegalArgumentException("Cannot calculate sibling database URL based on empty or null database URL.");
        }
        StringBuilder sb = new StringBuilder();
        int protoIdx = dbUrl.indexOf("://") + 3;
        int lastIdx = dbUrl.charAt(dbUrl.length() - 1) == '/' ? dbUrl.lastIndexOf(47, dbUrl.length() - 2) : dbUrl.lastIndexOf(47);
        if (lastIdx > protoIdx) {
            sb.append(dbUrl.substring(0, lastIdx + 1)).append(siblingName);
            return sb.toString();
        }
        throw new IllegalArgumentException("Cannot calculate sibling database URL for: '" + dbUrl + "' (cannot find last path separator '/')");
    }

    public static String buildUrl(boolean validate, String baseUrl, String ... parts) throws MalformedURLException {
        return UrlUtils.buildUrl(validate, baseUrl, null, parts);
    }

    public static String buildUrl(boolean validate, String baseUrl, Map<String, String> params, String ... parts) throws MalformedURLException {
        if (parts == null || parts.length < 1) {
            return baseUrl;
        }
        StringBuilder urlBuilder = new StringBuilder();
        if (parts[0] == null || !parts[0].startsWith(baseUrl)) {
            urlBuilder.append(baseUrl);
        }
        for (String part : parts) {
            if (part == null || part.trim().length() < 1) continue;
            if (part.startsWith("/")) {
                part = part.substring(1);
            }
            if (urlBuilder.length() > 0 && urlBuilder.charAt(urlBuilder.length() - 1) != '/') {
                urlBuilder.append("/");
            }
            urlBuilder.append(part);
        }
        if (params != null && !params.isEmpty()) {
            urlBuilder.append("?");
            boolean first = true;
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    urlBuilder.append("&");
                }
                urlBuilder.append(param.getKey()).append("=").append(param.getValue());
            }
        }
        return validate ? new URL(urlBuilder.toString()).toExternalForm() : urlBuilder.toString();
    }

    public static UrlInfo parseUrlInfo(String url) {
        return new UrlInfo(url);
    }
}

