/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.freeki.infra.render.RenderingEngine;
import org.commonjava.freeki.infra.render.RenderingException;
import org.commonjava.freeki.infra.route.Method;
import org.commonjava.freeki.infra.route.RouteHandler;
import org.commonjava.freeki.infra.route.anno.Route;
import org.commonjava.freeki.infra.route.anno.Routes;
import org.commonjava.freeki.model.Page;
import org.commonjava.freeki.rest.PathParameter;
import org.commonjava.freeki.store.FreekiStore;
import org.commonjava.freeki.util.ContentType;
import org.commonjava.mimeparse.MIMEParse;
import org.commonjava.util.logging.Logger;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class PageContentHandler
implements RouteHandler {
    private static final Set<String> PAGE_ACCEPT = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(ContentType.TEXT_HTML.value());
            this.add(ContentType.TEXT_PLAIN.value());
            this.add(ContentType.APPLICATION_JSON.value());
        }
    };
    private final FreekiStore store;
    private final RenderingEngine engine;
    private final Logger logger = new Logger(this.getClass());

    public PageContentHandler(FreekiStore store, RenderingEngine engine) {
        this.store = store;
        this.engine = engine;
    }

    @Routes(value={@Route(path="/api/page/:dir=(.*)/:page", method=Method.DELETE)})
    public void delete(HttpServerRequest req) throws Exception {
        String dir = req.params().get(PathParameter.DIR.param());
        String page = req.params().get(PathParameter.PAGE.param());
        if (dir == null) {
            dir = "/";
        }
        if (!this.store.hasPage(dir, page)) {
            req.response().setStatusCode(404).setStatusMessage("Not found").end();
            return;
        }
        boolean success = this.store.deletePage(dir, page);
        if (success) {
            req.response().setStatusCode(200).setStatusMessage("Deleted").end();
        } else {
            req.response().setStatusCode(417).setStatusMessage("Delete failed").end();
        }
    }

    @Routes(value={@Route(path="/api/page/:page", method=Method.PUT, contentType="text/plain"), @Route(path="/api/page/:page", method=Method.POST, contentType="text/plain"), @Route(path="/api/page/:dir=(.*)/:page", method=Method.PUT, contentType="text/plain"), @Route(path="/api/page/:dir=(.*)/:page", method=Method.POST, contentType="text/plain")})
    public void store(final HttpServerRequest req) throws Exception {
        String dir = req.params().get(PathParameter.DIR.param());
        final String page = req.params().get(PathParameter.PAGE.param());
        if (dir == null) {
            dir = "/";
        }
        final String group = dir;
        req.bodyHandler(new Handler<Buffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Buffer event) {
                block12: {
                    String content = event.getString(0, event.length());
                    try {
                        Page pageObj;
                        String title = page;
                        BufferedReader reader = new BufferedReader(new StringReader(content.toString()));
                        String firstLine = reader.readLine();
                        if (firstLine != null && firstLine.length() > 0) {
                            if (firstLine.startsWith("# ")) {
                                title = firstLine.substring(2);
                            } else {
                                String secondLine = reader.readLine();
                                if (secondLine != null && secondLine.matches("[=]+")) {
                                    title = firstLine;
                                }
                            }
                        }
                        if ((pageObj = PageContentHandler.this.store.getPage(group, page)) == null) {
                            pageObj = new Page(group, Page.serverPathFor(group, page), content.toString(), title, System.currentTimeMillis(), "unknown");
                        } else {
                            pageObj.setContent(content.toString());
                            pageObj.setUpdated(new Date());
                            if (pageObj.getTitle() == null) {
                                pageObj.setTitle(title);
                            }
                        }
                        String location = "/wiki/" + pageObj.getId();
                        if (PageContentHandler.this.store.storePage(pageObj)) {
                            req.response().putHeader("Location", location).setStatusCode(201).setStatusMessage("Created: " + page).end();
                            break block12;
                        }
                        req.response().putHeader("Location", location).setStatusCode(200).setStatusMessage("Stored updates to: " + page).end();
                    }
                    catch (Exception e) {
                        PageContentHandler.this.logger.error(e.getMessage(), e, new Object[0]);
                        req.response().setStatusCode(500).setStatusMessage(e.getMessage()).end(e.getMessage());
                    }
                }
            }
        });
    }

    @Routes(value={@Route(path="/wiki/:page", method=Method.GET), @Route(path="/wiki/:dir=(.*)/:page", method=Method.GET), @Route(path="/api/page/:page", method=Method.GET, contentType="text/plain"), @Route(path="/api/page/:dir=(.*)/:page", method=Method.GET, contentType="text/plain")})
    public void get(HttpServerRequest req) throws Exception {
        req.response().setChunked(true);
        req.response().setStatusCode(200);
        String dir = req.params().get(PathParameter.DIR.param());
        String page = req.params().get(PathParameter.PAGE.param());
        if (dir == null) {
            dir = "/";
        }
        this.logger.info("Page: %s\n", page);
        this.logger.info("Dir: %s\n", dir);
        String mimeAccept = req.headers().get("Recommended-Content-Type");
        if (mimeAccept == null) {
            String acceptHeader = req.headers().get("Accept");
            mimeAccept = MIMEParse.bestMatch(PAGE_ACCEPT, acceptHeader);
        }
        ContentType type = ContentType.find(mimeAccept);
        try {
            Page pg = this.store.getPage(dir, page);
            String rendered = this.engine.render(pg, type);
            req.response().end(rendered);
        }
        catch (IOException | RenderingException e) {
            this.logger.error("Failed to retrieve group: %s. Reason: %s", e, dir, e.getMessage());
            throw e;
        }
    }
}

