/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;

class InstructionGroupCreator
implements RuleMethodProcessor {
    private final Map<String, Integer> memberModifiers = new HashMap<String, Integer>();
    private RuleMethod method;

    InstructionGroupCreator() {
    }

    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return ruleMethod.containsExplicitActions() || ruleMethod.containsVars();
    }

    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        this.method = Preconditions.checkArgNotNull(ruleMethod, "method");
        this.createGroups();
        for (InstructionGroup object : ruleMethod.getGroups()) {
            this.sort(object);
            this.markUngroupedEnclosedNodes(object);
            this.verify(object);
        }
        for (InstructionGraphNode instructionGraphNode : ruleMethod.getGraphNodes()) {
            if (instructionGraphNode.getGroup() != null) continue;
            this.verifyAccess(instructionGraphNode);
        }
    }

    private void createGroups() {
        for (InstructionGraphNode instructionGraphNode : this.method.getGraphNodes()) {
            if (!instructionGraphNode.isActionRoot() && !instructionGraphNode.isVarInitRoot()) continue;
            InstructionGroup instructionGroup = new InstructionGroup(instructionGraphNode);
            this.markGroup(instructionGraphNode, instructionGroup);
            this.method.getGroups().add(instructionGroup);
        }
    }

    private void markGroup(InstructionGraphNode instructionGraphNode, InstructionGroup instructionGroup) {
        Checks.ensure(instructionGraphNode == instructionGroup.getRoot() || !instructionGraphNode.isActionRoot() && !instructionGraphNode.isVarInitRoot(), "Method '%s' contains illegal nesting of ACTION and/or Var initializer constructs", this.method.name);
        if (instructionGraphNode.getGroup() != null) {
            return;
        }
        instructionGraphNode.setGroup(instructionGroup);
        if (!instructionGraphNode.isXLoad()) {
            if (instructionGraphNode.isVarInitRoot()) {
                Preconditions.checkState(instructionGraphNode.getPredecessors().size() == 2);
                this.markGroup(instructionGraphNode.getPredecessors().get(1), instructionGroup);
            } else {
                for (InstructionGraphNode instructionGraphNode2 : instructionGraphNode.getPredecessors()) {
                    this.markGroup(instructionGraphNode2, instructionGroup);
                }
            }
        }
    }

    private void sort(InstructionGroup instructionGroup) {
        final InsnList insnList = this.method.instructions;
        Collections.sort(instructionGroup.getNodes(), new Comparator<InstructionGraphNode>(){

            @Override
            public int compare(InstructionGraphNode instructionGraphNode, InstructionGraphNode instructionGraphNode2) {
                return Integer.valueOf(insnList.indexOf(instructionGraphNode.getInstruction())).compareTo(insnList.indexOf(instructionGraphNode2.getInstruction()));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void markUngroupedEnclosedNodes(InstructionGroup instructionGroup) {
        block0: while (true) {
            int n = this.getIndexOfFirstInsn(instructionGroup);
            int n2 = this.getIndexOfLastInsn(instructionGroup);
            while (true) {
                if (n >= n2) {
                    return;
                }
                InstructionGraphNode instructionGraphNode = this.method.getGraphNodes().get(n);
                if (instructionGraphNode.getGroup() == null) {
                    this.markGroup(instructionGraphNode, instructionGroup);
                    this.sort(instructionGroup);
                    continue block0;
                }
                ++n;
            }
            break;
        }
    }

    private void verify(InstructionGroup instructionGroup) {
        int n;
        List<InstructionGraphNode> list = instructionGroup.getNodes();
        Preconditions.checkState(list.get(n = list.size() - 1) == instructionGroup.getRoot());
        for (int i = 0; i < n; ++i) {
            InstructionGraphNode instructionGraphNode = list.get(i);
            Checks.ensure(!instructionGraphNode.isXStore(), "An ACTION or Var initializer in rule method '%s' contains illegal writes to a local variable or parameter", this.method.name);
            this.verifyAccess(instructionGraphNode);
        }
        Checks.ensure(this.getIndexOfLastInsn(instructionGroup) - this.getIndexOfFirstInsn(instructionGroup) == n, "Error during bytecode analysis of rule method '%s': Incontinuous group block", this.method.name);
    }

    private void verifyAccess(InstructionGraphNode instructionGraphNode) {
        switch (instructionGraphNode.getInstruction().getOpcode()) {
            case 178: 
            case 180: {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)instructionGraphNode.getInstruction();
                Checks.ensure(!this.isPrivateField(fieldInsnNode.owner, fieldInsnNode.name), "Rule method '%s' contains an illegal access to private field '%s'.\nMark the field protected or package-private if you want to prevent public access!", this.method.name, fieldInsnNode.name);
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodInsnNode methodInsnNode = (MethodInsnNode)instructionGraphNode.getInstruction();
                Checks.ensure(!this.isPrivate(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc), "Rule method '%s' contains an illegal call to private method '%s'.\nMark '%s' protected or package-private if you want to prevent public access!", this.method.name, methodInsnNode.name, methodInsnNode.name);
            }
        }
    }

    private int getIndexOfFirstInsn(InstructionGroup instructionGroup) {
        return this.method.instructions.indexOf(instructionGroup.getNodes().get(0).getInstruction());
    }

    private int getIndexOfLastInsn(InstructionGroup instructionGroup) {
        List<InstructionGraphNode> list = instructionGroup.getNodes();
        return this.method.instructions.indexOf(list.get(list.size() - 1).getInstruction());
    }

    private boolean isPrivateField(String string, String string2) {
        String string3 = string + '#' + string2;
        Integer n = this.memberModifiers.get(string3);
        if (n == null) {
            n = AsmUtils.getClassField(string, string2).getModifiers();
            this.memberModifiers.put(string3, n);
        }
        return Modifier.isPrivate(n);
    }

    private boolean isPrivate(String string, String string2, String string3) {
        return "<init>".equals(string2) ? this.isPrivateInstantiation(string, string3) : this.isPrivateMethod(string, string2, string3);
    }

    private boolean isPrivateMethod(String string, String string2, String string3) {
        String string4 = string + '#' + string2 + '#' + string3;
        Integer n = this.memberModifiers.get(string4);
        if (n == null) {
            n = AsmUtils.getClassMethod(string, string2, string3).getModifiers();
            this.memberModifiers.put(string4, n);
        }
        return Modifier.isPrivate(n);
    }

    private boolean isPrivateInstantiation(String string, String string2) {
        Integer n = this.memberModifiers.get(string);
        if (n == null) {
            n = AsmUtils.getClassForInternalName(string).getModifiers();
            this.memberModifiers.put(string, n);
        }
        if (Modifier.isPrivate(n)) {
            return true;
        }
        String string3 = string + "#<init>#" + string2;
        n = this.memberModifiers.get(string3);
        if (n == null) {
            n = AsmUtils.getClassConstructor(string, string2).getModifiers();
            this.memberModifiers.put(string3, n);
        }
        return Modifier.isPrivate(n);
    }
}

