/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.LineIterator;
import org.commonjava.freeki.infra.anno.RenderKey;
import org.commonjava.freeki.model.MetadataKeys;
import org.commonjava.freeki.model.io.DateSerializer;
import org.commonjava.freeki.util.UrlUtils;
import org.commonjava.util.logging.Logger;

@RenderKey(key="page", contentTemplate="${data.content}")
public class Page {
    private static final String COMMENT_START = "<!---";
    private static final String COMMENT_END = "-->";
    private static final char LS = '\n';
    private static final String KVS = ": ";
    private final transient Logger logger = new Logger(this.getClass());
    private String id;
    private String title;
    private Date created = new Date();
    private Date updated = new Date();
    private String currentAuthor;
    private String content;
    private String group;
    private final Map<String, String> metadata = new HashMap<String, String>();

    public Page() {
    }

    public Page(String group, String id, String content, long lastUpdated) throws MalformedURLException {
        this.group = group;
        this.updated = new Date(lastUpdated);
        this.id = Page.serverPathFor(group, id);
        this.content = this.parse(content);
    }

    public Page(String group, String id, String content, String title, long created, String author) throws MalformedURLException {
        this.group = group;
        this.updated = new Date(created);
        this.created = new Date(created);
        this.content = content;
        this.title = title;
        this.currentAuthor = author;
        this.id = id;
    }

    public void repair() throws MalformedURLException {
        this.id = Page.serverPathFor(this.group, this.title);
    }

    public String getContent() {
        return this.content;
    }

    public Page setContent(String content) {
        this.content = content;
        return this;
    }

    public void syncContentWithTitle() {
        String title = this.getTitle();
        if (this.content != null) {
            boolean prependTitle = false;
            LineIterator li = new LineIterator(new StringReader(this.content));
            while (li.hasNext()) {
                String line = li.next();
                if (line.trim().length() <= 0) continue;
                if (title == null) {
                    title = line;
                    break;
                }
                if (title == null || line.trim().endsWith(title.trim())) break;
                prependTitle = true;
                break;
            }
            if (prependTitle) {
                this.content = "#" + title + "\n\n" + this.content;
            }
        } else if (title != null) {
            this.content = "#" + title + "\n\n";
        }
        this.setTitle(title);
    }

    public String getTitle() {
        return this.title;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getCurrentAuthor() {
        return this.currentAuthor;
    }

    public Page setTitle(String title) {
        this.title = title;
        return this;
    }

    public Page setCreated(Date created) {
        this.created = created;
        return this;
    }

    public Page setUpdated(Date updated) {
        this.updated = updated;
        return this;
    }

    public Page setCurrentAuthor(String currentAuthor) {
        this.currentAuthor = currentAuthor;
        return this;
    }

    public Page setGroup(String group) {
        this.group = group;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public CharSequence render() {
        StringBuilder sb = new StringBuilder();
        sb.append(COMMENT_START).append('\n').append((Object)MetadataKeys.TITLE).append(KVS).append(this.title).append('\n').append('\n').append((Object)MetadataKeys.CREATED).append(KVS).append(DateSerializer.formatDate(this.created)).append('\n').append((Object)MetadataKeys.CURRENT_AUTHOR).append(KVS).append(this.currentAuthor).append('\n').append(COMMENT_END).append('\n').append('\n');
        if (!this.content.startsWith("#" + this.title)) {
            sb.append('#').append(this.title).append('\n').append('\n');
        }
        sb.append(this.content);
        return sb;
    }

    private String parse(String content) throws MalformedURLException {
        String parsedId;
        String[] lines = content.split(Pattern.quote("\n"));
        boolean commentStarted = false;
        int headerSize = 0;
        block7: for (String line : lines) {
            int idx;
            ++headerSize;
            if (line.trim().startsWith(COMMENT_START)) {
                commentStarted = true;
                continue;
            }
            if (line.trim().endsWith(COMMENT_END)) break;
            if (!commentStarted || (idx = line.indexOf(58)) <= 0) continue;
            String key = line.substring(0, idx).trim().toLowerCase();
            String value = line.substring(idx + 1).trim();
            MetadataKeys mk = MetadataKeys.metadataKey(key);
            if (mk == null) {
                this.metadata.put(key, value);
                continue;
            }
            switch (mk) {
                case TITLE: {
                    this.title = value;
                    continue block7;
                }
                case CREATED: {
                    try {
                        this.created = DateSerializer.parseDate(value);
                    }
                    catch (ParseException e) {
                        this.logger.error("Failed to parse creation date '%s' on page: '%s'", value, this.title == null ? "Unknown page" : this.title);
                    }
                    continue block7;
                }
                case CURRENT_AUTHOR: {
                    this.currentAuthor = value;
                    continue block7;
                }
            }
        }
        if ((parsedId = Page.serverPathFor(this.group, this.title)) != null) {
            this.id = parsedId;
        }
        boolean contentStarted = false;
        StringBuilder sb = new StringBuilder();
        for (int i = headerSize + 1; i < lines.length; ++i) {
            if (!contentStarted) {
                if (lines[i].isEmpty()) continue;
                contentStarted = true;
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(lines[i]);
        }
        return sb.toString();
    }

    public static String readTitle(BufferedReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        String line = null;
        boolean headerStarted = false;
        String title = null;
        while ((line = reader.readLine()) != null) {
            int idx;
            if (line.trim().startsWith(COMMENT_START)) {
                headerStarted = true;
                continue;
            }
            if (line.trim().endsWith(COMMENT_END)) break;
            if (!headerStarted || (idx = line.indexOf(58)) <= 0) continue;
            String key = line.substring(0, idx).trim().toLowerCase();
            String value = line.substring(idx + 1).trim();
            if (!MetadataKeys.TITLE.name().equalsIgnoreCase(key)) continue;
            title = value;
            break;
        }
        return title;
    }

    public boolean updateFrom(Page pg) {
        if (pg.group != null && !this.group.equals(pg.group)) {
            return false;
        }
        if (pg.title != null && !this.title.equals(pg.title)) {
            return false;
        }
        this.currentAuthor = pg.currentAuthor;
        this.updated = pg.updated;
        this.content = pg.content;
        return true;
    }

    public static String serverPathFor(String group, String title) throws MalformedURLException {
        if (title == null) {
            return null;
        }
        return UrlUtils.buildUrl(false, group, Page.idFor(title));
    }

    public static String idFor(String title) {
        if (title == null) {
            return null;
        }
        return title.toLowerCase().replaceAll("[^-_a-zA-Z0-9]+", "-");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return String.format("Page [id=%s, title=%s, group=%s]", this.id, this.title, this.group);
    }
}

