/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.infra.render.tmpl;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import org.codehaus.groovy.control.CompilationFailedException;
import org.commonjava.freeki.conf.GTemplateConfig;
import org.commonjava.freeki.infra.render.ContentRenderer;
import org.commonjava.freeki.infra.render.RenderUtils;
import org.commonjava.freeki.infra.render.RenderingException;
import org.commonjava.freeki.util.ContentType;
import org.pegdown.PegDownProcessor;

public class GTHtmlRenderer
implements ContentRenderer {
    private static final ContentType[] TYPES = new ContentType[]{ContentType.TEXT_HTML};
    private final GStringTemplateEngine engine;
    private final PegDownProcessor proc;
    private final GTemplateConfig config;

    public GTHtmlRenderer(GStringTemplateEngine engine, PegDownProcessor proc, GTemplateConfig config) {
        this.engine = engine;
        this.proc = proc;
        this.config = config;
    }

    @Override
    public ContentType[] getContentTypes() {
        return TYPES;
    }

    @Override
    public String render(Object data) throws RenderingException {
        String path = this.config.getTemplate(ContentType.TEXT_HTML, RenderUtils.getTemplateKey(data));
        try {
            Template template;
            File templateFile;
            String content;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("data", data);
            String ct = RenderUtils.getContentTemplate(data);
            if (ct == null) {
                content = null;
            } else {
                Template contentTemplate = this.engine.createTemplate(ct);
                Writable out = contentTemplate.make(map);
                StringWriter writer = new StringWriter();
                out.writeTo(writer);
                content = writer.toString();
            }
            if (content != null) {
                String renderedMarkdown = this.proc.markdownToHtml(content);
                map.put("rendered", renderedMarkdown);
            }
            if ((templateFile = new File(this.config.getBrandingDir(), path)).exists() && !templateFile.isDirectory()) {
                template = this.engine.createTemplate(templateFile);
            } else {
                URL u = Thread.currentThread().getContextClassLoader().getResource(path);
                Template template2 = template = u == null ? null : this.engine.createTemplate(u);
            }
            if (template == null) {
                throw new RenderingException("Failed to locate template: %s", path);
            }
            Writable output = template.make(map);
            StringWriter writer = new StringWriter();
            output.writeTo(writer);
            String html = writer.toString();
            return html;
        }
        catch (IOException | ClassNotFoundException | CompilationFailedException e) {
            throw new RenderingException("Failed to load template: %s. Reason: %s", (Throwable)e, path, e.getMessage());
        }
    }
}

